/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.graph.GraphUtil;

public class GraphUtilDemo {
    public static void pointsAlongACurveDemo() {
        double len;
        Ellipse2D.Double e = new Ellipse2D.Double(50.0, 50.0, 100.0, 100.0);
        final GeneralPath p = new GeneralPath(e);
        double[] points = new double[]{10.0, 20.0, 30.0, 100.0, 200.0};
        final Point2D.Double[] result = new Point2D.Double[points.length];
        final double[] orientation = new double[points.length];
        points[points.length - 1] = len = GraphUtil.pointsAlongCurve(p.getPathIterator(null, 0.001), null, null, null, false);
        GraphUtil.pointsAlongCurve(p.getPathIterator(null, 0.001), points, result, orientation, false);
        JPanel panel = new JPanel(){

            public void paintComponent(Graphics g1) {
                Graphics2D g = (Graphics2D)g1;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.draw(p);
                for (int i = 0; i < result.length; ++i) {
                    if (result[i] == null) continue;
                    AffineTransform at = new AffineTransform();
                    at.translate(result[i].x, result[i].y);
                    at.rotate(orientation[i]);
                    g.setTransform(at);
                    double w = g.getFontMetrics().getStringBounds("A", g).getWidth();
                    g.drawString("A", (int)(-w / 2.0), 0);
                }
            }
        };
        panel.setMinimumSize(new Dimension(300, 300));
        panel.setPreferredSize(new Dimension(300, 300));
        JFrame frame = new JFrame();
        frame.setContentPane(panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        GraphUtilDemo.pointsAlongACurveDemo();
    }
}

