/*
 * Decompiled with CFR 0.152.
 */
package pds.label;

import java.io.PrintStream;

public class PDSValue {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_LITERAL = 2;
    public String mValue = "";
    public String mUnits = "";
    public int mType = 0;

    public int length() {
        int len = 0;
        switch (this.mType) {
            case 1: 
            case 2: {
                len += 2;
            }
        }
        len += this.mValue.length();
        if (this.mUnits.length() > 0) {
            len += this.mUnits.length() + 3;
        }
        return len;
    }

    public void print() {
        this.print(System.out, 0, 4, 78);
    }

    public void print(PrintStream out, int offset, int indentLength, int maxLength) {
        switch (this.mType) {
            case 1: {
                out.print("\"");
                break;
            }
            case 2: {
                out.print("'");
            }
        }
        String buffer = this.isQuoted() ? this.mValue : this.wrapPad(this.mValue, offset, indentLength, maxLength);
        out.print(buffer);
        switch (this.mType) {
            case 1: {
                out.print("\"");
                break;
            }
            case 2: {
                out.print("'");
            }
        }
        if (this.mUnits.length() > 0) {
            out.print(" <" + this.mUnits + ">");
        }
    }

    public String formatValue() {
        return this.formatValue(false);
    }

    public String formatValue(boolean plain) {
        String buffer = "";
        buffer = this.mValue;
        if (!plain) {
            switch (this.mType) {
                case 1: {
                    buffer = "\"" + buffer + "\"";
                    break;
                }
                case 2: {
                    buffer = "'" + buffer + "'";
                }
            }
        }
        if (this.mUnits.length() > 0) {
            buffer = buffer + " <" + this.mUnits + ">";
        }
        return buffer;
    }

    public boolean isQuoted() {
        switch (this.mType) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public String wrapPad(String text, int offset, int indentLength, int maxLength) {
        int i;
        String indent = "";
        String result = "";
        String newline = "\r\n";
        for (i = 0; i < indentLength; ++i) {
            indent = indent + " ";
        }
        String buffer = "";
        String[] line = text.split(newline);
        for (i = 0; i < line.length; ++i) {
            line[i] = line[i].trim();
            if (line[i].length() > 0) {
                if (buffer.length() > 0) {
                    buffer = buffer + " ";
                }
                buffer = buffer + line[i];
                int n = buffer.length();
                while (n + offset + indentLength > maxLength) {
                    for (int j = maxLength - offset - indentLength; j > 0; --j) {
                        if (buffer.charAt(j) != ' ') continue;
                        if (offset == 0) {
                            result = result + indent;
                        }
                        result = result + buffer.substring(0, j);
                        result = result + newline;
                        buffer = buffer.substring(j + 1);
                        break;
                    }
                    n = buffer.length();
                    offset = 0;
                }
                continue;
            }
            if (buffer.length() > 0) {
                if (offset == 0) {
                    result = result + indent;
                }
                result = result + buffer + newline;
            }
            if (line.length > 1) {
                result = result + newline;
            }
            buffer = "";
            offset = 0;
        }
        if (buffer.length() > 0) {
            if (offset == 0) {
                result = result + indent;
            }
            result = result + buffer;
        }
        return result;
    }

    public void dump(PrintStream out) {
        out.print("Type: ");
        switch (this.mType) {
            case 2: {
                out.println("LITERAL");
                break;
            }
            case 1: {
                out.println("STRING");
                break;
            }
            case 0: {
                out.println("NONE");
            }
        }
        out.println("Value: " + this.mValue);
        out.println("Units: " + this.mUnits);
    }
}

