/*
 * Decompiled with CFR 0.152.
 */
package pds.label;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import pds.label.PDSElement;
import pds.label.PDSException;
import pds.label.PDSItem;
import pds.label.PDSValue;

public class PDSLabel {
    public ArrayList mElement = new ArrayList();
    public String mPathName = "";
    int mLineCount = 0;
    PrintStream mLog = System.out;

    public PDSLabel() {
    }

    public PDSLabel(PrintStream log) {
        this.setLog(log);
    }

    public String version() {
        return "1.0.0.3";
    }

    public void reset() {
        this.mElement = new ArrayList();
    }

    public static void main(String[] args) {
        int output = 0;
        if (args.length == 0) {
            System.out.println("Proper usage: pds.label.PDSLabel pathname [dump|xml]");
            return;
        }
        ArrayList files = null;
        PDSLabel label = new PDSLabel();
        try {
            if (label.isLabel(args[0])) {
                System.out.println("Parsing label: " + args[0]);
                label.parse(args[0]);
            } else {
                System.out.println("Parsing XML: " + args[0]);
                label.parseXML(args[0]);
            }
        }
        catch (Exception e) {
            label.printMessage(e.getMessage());
            e.printStackTrace(System.out);
            return;
        }
        if (args.length > 1) {
            if (args[1].compareToIgnoreCase("dump") == 0) {
                output = 0;
            }
            if (args[1].compareToIgnoreCase("xml") == 0) {
                output = 1;
            }
        }
        switch (output) {
            case 1: {
                label.printXML(System.out);
                break;
            }
            default: {
                files = label.filePointers();
                if (files == null) {
                    System.out.println("No file pointers.");
                } else {
                    Iterator i = files.iterator();
                    while (i.hasNext()) {
                        System.out.println((String)i.next());
                    }
                }
                System.out.println("----------");
                label.print();
            }
        }
    }

    public boolean isLabel(String pathName) {
        String buffer = "";
        int c = 0;
        boolean label = false;
        try {
            FileInputStream file = new FileInputStream(pathName);
            int i = 0;
            while ((c = file.read()) != -1) {
                buffer = buffer + (char)c;
                if (++i != 14) continue;
            }
            if (buffer.compareTo("CCSD3ZF0000100") == 0) {
                label = true;
            }
            if (buffer.compareTo("PDS_VERSION_ID") == 0) {
                label = true;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to open file: " + pathName);
            System.out.println("    Reason: " + e.getMessage());
        }
        return label;
    }

    public boolean isValidItem(PDSItem item) {
        if (item == null) {
            return false;
        }
        return item.valid();
    }

    public boolean parse(String pathName) throws PDSException {
        boolean status;
        this.mPathName = pathName;
        try {
            FileInputStream file = new FileInputStream(this.mPathName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(file));
            status = this.parse(reader, pathName);
            reader.close();
            file.close();
        }
        catch (Exception e) {
            throw new PDSException(e.getMessage());
        }
        return status;
    }

    public boolean parse(InputStream stream) throws PDSException {
        boolean status;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            status = this.parse(reader, "<stream>");
            reader.close();
        }
        catch (Exception e) {
            throw new PDSException(e.getMessage());
        }
        return status;
    }

    public boolean parse(BufferedReader reader, String source) throws PDSException {
        boolean more = true;
        boolean good = true;
        this.reset();
        try {
            good = true;
            while (more) {
                PDSElement element = new PDSElement(this.mLineCount, source);
                more = element.parse(reader);
                if (!more) continue;
                this.mElement.add(element);
                this.mLineCount = element.mLineCount;
            }
        }
        catch (Exception e) {
            throw new PDSException(e.getMessage());
        }
        return good;
    }

    public boolean parseXML(String pathName) throws PDSException {
        boolean status;
        this.mPathName = pathName;
        try {
            FileInputStream file = new FileInputStream(this.mPathName);
            status = this.parseXML(file);
            file.close();
        }
        catch (Exception e) {
            throw new PDSException(e.getMessage());
        }
        return status;
    }

    public boolean parseXML(InputStream stream) throws PDSException {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(stream);
        }
        catch (Exception e) {
            throw new PDSException(e.getMessage());
        }
        this.pushNode(doc, null);
        return true;
    }

    public boolean pushNode(Node node, PDSElement parentElement) throws PDSException {
        PDSElement element = parentElement;
        ++this.mLineCount;
        switch (node.getNodeType()) {
            case 8: {
                element = new PDSElement(this.mLineCount);
                element.mType = 4;
                element.parseValue(node.getNodeValue());
                this.mElement.add(element);
                break;
            }
            case 1: {
                if (parentElement != null && !parentElement.isObject()) {
                    parentElement.setValue(parentElement.mKeyword);
                    parentElement.mKeyword = "OBJECT";
                }
                element = new PDSElement(this.mLineCount);
                element.mKeyword = node.getNodeName();
                this.mElement.add(element);
                break;
            }
            case 3: {
                String buffer = node.getNodeValue();
                buffer = buffer.trim();
                if (buffer.length() <= 0 || parentElement == null || parentElement.isObject()) break;
                parentElement.setValue(buffer);
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.pushNode(list.item(i), element);
        }
        if (node.getNodeType() == 1 && element != null && element.isObject()) {
            element = new PDSElement(this.mLineCount);
            element.mKeyword = "END_OBJECT";
            element.setValue(node.getNodeName());
            this.mElement.add(element);
        }
        return true;
    }

    public String pathName() {
        return this.mPathName;
    }

    public String path() {
        int n = this.mPathName.lastIndexOf(47);
        if (n != -1) {
            return this.mPathName.substring(0, n + 1);
        }
        n = this.mPathName.lastIndexOf(92);
        if (n != -1) {
            return this.mPathName.substring(0, n + 1);
        }
        return "";
    }

    public PDSItem findObject(String name) {
        return this.findObject(name, 0, -1);
    }

    public PDSItem findObject(String name, PDSItem item) {
        if (item == null) {
            return this.findObject(name);
        }
        return this.findObject(name, item.mStart, item.mEnd);
    }

    public PDSItem findNextObject(String name, PDSItem item) {
        return this.findNextObject(name, item, null);
    }

    public PDSItem findNextObject(String name, PDSItem item, PDSItem object) {
        if (item == null) {
            return this.findObject(name, object);
        }
        if (item.mEnd == -1) {
            return null;
        }
        if (object == null) {
            return this.findObject(name, item.mEnd, -1);
        }
        return this.findObject(name, item.mEnd, object.mEnd);
    }

    public PDSItem findObject(String name, int startAt, int endAt) {
        PDSElement element;
        int i;
        PDSItem item = new PDSItem();
        if (startAt == -1) {
            startAt = 0;
        }
        if (endAt == -1) {
            endAt = this.mElement.size();
        }
        if (startAt >= this.mElement.size()) {
            return null;
        }
        if (endAt > this.mElement.size()) {
            endAt = this.mElement.size();
        }
        name = name.replaceAll("\\*", ".*");
        for (i = startAt; i < endAt; ++i) {
            element = (PDSElement)this.mElement.get(i);
            if (element.mKeyword.compareTo("OBJECT") != 0 || element.mValue.size() == 0) continue;
            PDSValue value = (PDSValue)element.mValue.get(0);
            String buffer = value.mValue.trim();
            if (!buffer.matches(name)) continue;
            item.mStart = i;
            break;
        }
        if (item.mStart == -1) {
            return null;
        }
        int k = 0;
        for (i = item.mStart; i < endAt; ++i) {
            element = (PDSElement)this.mElement.get(i);
            if (element.mKeyword.compareTo("OBJECT") == 0) {
                ++k;
            }
            if (element.mKeyword.compareTo("END_OBJECT") != 0 || --k > 0) continue;
            item.mEnd = i + 1;
            break;
        }
        return item;
    }

    public String getElementValue(String name) {
        return this.getElementValue(name, false);
    }

    public String getElementValue(String name, boolean plain) {
        return this.getElementValue(name, null, plain);
    }

    public String getElementValue(String name, PDSItem section, boolean plain) {
        PDSItem item = this.findItem(name, section);
        if (item == null) {
            return "";
        }
        if (!item.valid()) {
            return "";
        }
        PDSElement element = this.getElement(item);
        return element.valueString(plain);
    }

    public String getElementValueInObject(String name) {
        return this.getElementValueInObject(name, null, true);
    }

    public String getElementValueInObject(String name, PDSItem section, boolean plain) {
        PDSItem item;
        PDSItem object = new PDSItem();
        if (section != null) {
            object.mStart = section.mStart;
            object.mEnd = section.mEnd;
        }
        if ((item = this.findItemInObject(name, object)) == null) {
            return "";
        }
        if (!item.valid()) {
            return "";
        }
        PDSElement element = this.getElement(item);
        return element.valueString(plain);
    }

    public PDSItem findItem(String name) {
        return this.findItem(name, 0, -1);
    }

    public PDSItem findNextItemInObject(String name, PDSItem item, PDSItem section) {
        int startAt = 0;
        int endAt = -1;
        if (section != null) {
            startAt = section.mStart + 1;
            endAt = section.mEnd;
        }
        if (item != null) {
            startAt = item.mEnd;
        }
        return this.findItem(name, startAt, endAt, false);
    }

    public PDSItem findItemInObject(String name, PDSItem context) {
        return this.findItem(name, context.mStart, context.mEnd, false);
    }

    public PDSItem findItem(String name, PDSItem item) {
        if (item == null) {
            return this.findItem(name);
        }
        return this.findItem(name, item.mStart, item.mEnd, true);
    }

    public PDSItem findItem(String name, int startAt, int endAt) {
        return this.findItem(name, startAt, endAt, true);
    }

    public PDSItem findItem(String name, int startAt, int endAt, boolean global) {
        PDSItem item = new PDSItem();
        if (startAt == -1) {
            startAt = 0;
        }
        if (endAt == -1) {
            endAt = this.mElement.size();
        }
        name = name.replaceAll("\\^", "\\\\^");
        name = name.replaceAll("\\*", ".*");
        for (int i = startAt; i < endAt; ++i) {
            PDSItem object;
            PDSElement element = (PDSElement)this.mElement.get(i);
            if (element.mKeyword.matches(name)) {
                item.mStart = i;
                item.mEnd = i + 1;
                break;
            }
            if (global || !element.mKeyword.matches("OBJECT") || i == startAt || !this.isValidItem(object = this.findObject(element.valueString(true), i, -1))) continue;
            i += object.mEnd - object.mStart;
        }
        return item;
    }

    public PDSItem findNextItem(String name, PDSItem item) {
        if (item == null) {
            return this.findItem(name);
        }
        return this.findItem(name, item.mEnd, -1);
    }

    public PDSItem nextItem(PDSItem item) {
        PDSItem nextItem = new PDSItem();
        if (item.mEnd < this.mElement.size()) {
            nextItem.mStart = item.mEnd;
            nextItem.mEnd = nextItem.mStart + 1;
        }
        return nextItem;
    }

    public PDSElement getElement(PDSItem item) {
        if (item.valid() && item.mStart < this.mElement.size()) {
            return (PDSElement)this.mElement.get(item.mStart);
        }
        return null;
    }

    public PDSElement getElement(String name) {
        PDSItem item = this.findItem(name, 0, -1);
        if (!item.valid()) {
            return null;
        }
        PDSElement element = this.getElement(item);
        return element;
    }

    public PDSElement getElement(String name, PDSItem section) {
        PDSItem item = this.findItem(name, section);
        if (!item.valid()) {
            return null;
        }
        PDSElement element = this.getElement(item);
        return element;
    }

    public void replace(PDSItem item, PDSLabel label) {
        this.insertAfter(item, label);
        this.remove(item);
    }

    public void add(PDSElement element) {
        this.mElement.add(element);
    }

    public void add(PDSLabel label) {
        this.mElement.addAll(label.mElement);
    }

    public void insertBefore(PDSItem item, PDSLabel label) {
        if (!item.valid()) {
            return;
        }
        this.mElement.addAll(item.mStart, label.mElement);
    }

    public void insertAfter(PDSItem item, PDSLabel label) {
        if (!item.valid()) {
            return;
        }
        if (item.mEnd >= this.mElement.size()) {
            this.add(label);
        } else {
            this.mElement.addAll(item.mEnd, label.mElement);
        }
    }

    public void insertBefore(PDSItem item, PDSElement element) {
        if (!item.valid()) {
            return;
        }
        this.mElement.add(item.mStart, element);
    }

    public void insertAfter(PDSItem item, PDSElement element) {
        if (!item.valid()) {
            return;
        }
        if (item.mEnd >= this.mElement.size()) {
            this.add(element);
        } else {
            this.mElement.add(item.mEnd, element);
        }
    }

    public void remove(PDSItem item) {
        if (!item.valid()) {
            return;
        }
        if (item.mEnd > this.mElement.size()) {
            item.mEnd = this.mElement.size();
        }
        for (int i = item.mStart; i < item.mEnd; ++i) {
            this.mElement.remove(item.mStart);
        }
    }

    public PDSLabel extract(PDSItem item) {
        PDSLabel label = new PDSLabel();
        if (item.valid()) {
            for (int i = item.mStart; i < item.mEnd; ++i) {
                PDSElement element = (PDSElement)this.mElement.get(i);
                PDSElement newElement = element.copy();
                label.mElement.add(newElement);
            }
        }
        return label;
    }

    public ArrayList filePointers() {
        PDSItem item = new PDSItem();
        ArrayList<String> list = new ArrayList<String>();
        item.empty();
        item = this.findNextItem("^*", item);
        while (item.valid()) {
            PDSElement element = this.getElement(item);
            for (int i = 0; i < element.mValue.size(); ++i) {
                PDSValue value = (PDSValue)element.mValue.get(i);
                if (value.mType != 1) continue;
                String buffer = new String();
                buffer = value.mValue;
                boolean add = true;
                for (String temp : list) {
                    if (temp.compareTo(buffer) != 0) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                list.add(buffer);
            }
            item = this.findNextItem("^*", item);
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public void print() {
        this.print(System.out);
    }

    public void print(String pathName) {
        this.mPathName = pathName;
        try {
            FileOutputStream file = new FileOutputStream(this.mPathName);
            PrintStream out = new PrintStream(file);
            this.print(out);
        }
        catch (IOException e) {
            System.out.println("Unable to open file: " + this.mPathName);
            System.out.println("    Reason: " + e.getMessage());
            return;
        }
    }

    public void print(String pathName, int indent, int equal) {
        this.mPathName = pathName;
        try {
            FileOutputStream file = new FileOutputStream(this.mPathName);
            PrintStream out = new PrintStream(file);
            this.print(out, indent, equal);
        }
        catch (IOException e) {
            System.out.println("Unable to open file: " + this.mPathName);
            System.out.println("    Reason: " + e.getMessage());
            return;
        }
    }

    public void print(PrintStream out) {
        this.print(out, 2, 29, 0, -1);
        out.print("END\r\n");
    }

    public void print(PrintStream out, int indent, int equal) {
        this.print(out, indent, equal, 0, -1);
        out.print("END\r\n");
    }

    public void print(PrintStream out, int indent, int equal, PDSItem item) {
        if (item == null) {
            this.print(out, indent, equal);
        } else {
            this.print(out, indent, equal, item.mStart, item.mEnd);
        }
    }

    public void print(PrintStream out, int indent, int equal, int startAt, int endAt) {
        int level = 0;
        if (startAt == -1) {
            startAt = 0;
        }
        if (endAt == -1) {
            endAt = this.mElement.size();
        }
        for (int i = startAt; i < endAt; ++i) {
            PDSElement element = (PDSElement)this.mElement.get(i);
            if (element.mKeyword.compareTo("END_OBJECT") == 0) {
                --level;
            }
            element.print(out, indent, equal, level);
            if (element.mKeyword.compareTo("OBJECT") != 0) continue;
            ++level;
        }
    }

    public void printVariable(PrintStream out) {
        int occurance = 1;
        int startAt = 0;
        int endAt = this.mElement.size();
        for (int i = startAt; i < endAt; ++i) {
            PDSElement element = (PDSElement)this.mElement.get(i);
            if (element.mKeyword.compareTo("OBJECT") == 0) {
                ++occurance;
            }
            if (element.mKeyword.compareTo("END") == 0) continue;
            PDSElement temp = element.copy();
            if (temp.mKeyword.length() == 0) continue;
            temp.mKeyword = "$" + temp.mKeyword.replace('^', 'p') + "_" + occurance;
            temp.print(out, 0, 29, 0);
        }
    }

    public void printMessage(String text) {
        this.mLog.println("Unable to parse file: " + this.mPathName);
        this.mLog.println("   Reason: " + text);
    }

    public void setLog(PrintStream stream) {
        this.mLog = stream;
    }

    public Document getDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            doc = docBuilder.newDocument();
            this.pushObject(doc, null, "LABEL", 0);
        }
        catch (Exception e) {
            doc = null;
        }
        return doc;
    }

    public void printXML(PrintStream out) {
        try {
            Document doc = this.getDocument();
            TransformerFactory transfac = TransformerFactory.newInstance();
            try {
                transfac.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception ie) {
                // empty catch block
            }
            Transformer trans = transfac.newTransformer(this.getDefaultStyleSheet());
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(out);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public StreamSource getDefaultStyleSheet() {
        StringReader reader = new StringReader("<!DOCTYPE stylesheet [   <!ENTITY cr \"<xsl:text> </xsl:text>\">]><xsl:stylesheet   xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"   xmlns:xalan=\"http://xml.apache.org/xslt\"   version=\"1.0\"><xsl:output method=\"xml\" indent=\"yes\" xalan:indent-amount=\"4\"/><!-- copy out the xml --><xsl:template match=\"* | @*\">   <xsl:copy><xsl:copy-of select=\"@*\"/><xsl:apply-templates/></xsl:copy></xsl:template></xsl:stylesheet>");
        return new StreamSource(reader);
    }

    public int pushObject(Document doc, Element parent, String name, int start) {
        int i;
        Element object = doc.createElement(name);
        if (parent == null) {
            doc.appendChild(object);
        } else {
            parent.appendChild(object);
        }
        block4: for (i = start; i < this.mElement.size(); ++i) {
            PDSElement element = (PDSElement)this.mElement.get(i);
            String value = element.valueString(true, false);
            if (element.mKeyword.matches("OBJECT")) {
                i = this.pushObject(doc, object, value, i + 1);
                continue;
            }
            if (element.mKeyword.matches("END_OBJECT") && value.matches(name)) {
                return i++;
            }
            switch (element.mType) {
                case 4: {
                    Comment comment = doc.createComment(element.mComment);
                    object.appendChild(comment);
                    continue block4;
                }
                case 3: {
                    continue block4;
                }
                default: {
                    Element elem;
                    String keyword = element.mKeyword;
                    String prefix = keyword.substring(0, 4);
                    if (prefix.compareToIgnoreCase("CCSD") == 0) {
                        value = keyword;
                        keyword = "SFDU";
                    }
                    if (keyword.charAt(0) == '^') {
                        boolean pointer = true;
                        keyword = keyword.substring(1);
                        elem = doc.createElement("POINTER");
                        elem.setAttribute("object", keyword);
                    } else {
                        elem = doc.createElement(keyword);
                        if (element.mType == 1) {
                            elem.setAttribute("list", "ordered");
                        }
                        if (element.mType == 2) {
                            elem.setAttribute("list", "unordered");
                        }
                    }
                    object.appendChild(elem);
                    Text text = doc.createTextNode(value);
                    elem.appendChild(text);
                }
            }
        }
        return i;
    }

    public String toString() {
        return this.mPathName + ":" + this.mLineCount;
    }
}

