/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.das2.util.filesystem.AppletHttpProtocol;
import org.das2.util.filesystem.DefaultHttpProtocol;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.ProgressMonitor;

public abstract class WebFileSystem
extends FileSystem {
    protected final File localRoot;
    private boolean applet;
    protected WebProtocol protocol;
    protected boolean offline = true;
    public static final String PROP_OFFLINE = "offline";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static File getDownloadDirectory() {
        File local = System.getProperty("user.name").equals("Web") ? new File("/tmp") : new File(System.getProperty("user.home"));
        local = new File(local, ".das2/fsCache/wfs/");
        return local;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        boolean oldOffline = offline;
        this.offline = offline;
        this.propertyChangeSupport.firePropertyChange(PROP_OFFLINE, oldOffline, offline);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected WebFileSystem(URL root, File localRoot) {
        super(root);
        this.localRoot = localRoot;
        if (localRoot == null) {
            if (root.getProtocol().equals("http")) {
                this.protocol = new AppletHttpProtocol();
            }
        } else if (root.getProtocol().equals("http")) {
            this.protocol = new DefaultHttpProtocol();
        }
    }

    protected static File localRoot(URL root) {
        File local = FileSystem.settings().getLocalCacheDir();
        String s = root.getProtocol() + "/" + root.getHost() + "/" + root.getFile();
        local = new File(local, s);
        local.mkdirs();
        return local;
    }

    protected abstract void downloadFile(String var1, File var2, File var3, ProgressMonitor var4) throws IOException;

    public String getLocalRootAbsPath() {
        return this.localRoot.getAbsolutePath();
    }

    public File getLocalRoot() {
        return this.localRoot;
    }

    public abstract boolean isDirectory(String var1) throws IOException;

    public abstract String[] listDirectory(String var1) throws IOException;

    public String[] listDirectory(String directory, String regex) throws IOException {
        String[] names = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].endsWith("/")) {
                names[i] = names[i].substring(0, names[i].length() - 1);
            }
            if (!pattern.matcher(names[i]).matches()) continue;
            result.add(names[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public URL getURL(String filename) {
        try {
            filename = FileSystem.toCanonicalFilename(filename);
            return new URL(this.root + filename.substring(1));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String filename = file.toString().substring(this.localRoot.toString().length());
        filename = filename.replaceAll("\\\\", "/");
        return filename;
    }

    public String getLocalName(URL url) {
        if (!url.toString().startsWith(this.root.toString())) {
            throw new IllegalArgumentException("url \"" + url + "\"is not of this web file system");
        }
        String filename = FileSystem.toCanonicalFilename(url.toString().substring(this.root.toString().length()));
        return filename;
    }

    public FileObject getFileObject(String filename) {
        WebFileObject f = new WebFileObject(this, filename, null);
        return f;
    }

    protected void copyStream(InputStream is, OutputStream out, ProgressMonitor monitor) throws IOException {
        byte[] buffer = new byte[2048];
        int bytesRead = is.read(buffer, 0, 2048);
        long totalBytesRead = bytesRead;
        while (bytesRead > -1) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException();
            }
            monitor.setTaskProgress(totalBytesRead);
            out.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer, 0, 2048);
            totalBytesRead += (long)bytesRead;
            logger.finest("transferring data");
        }
    }

    public String toString() {
        return "wfs " + this.root;
    }

    public boolean isAppletMode() {
        return this.applet;
    }

    public void setAppletMode(boolean applet) {
        this.applet = applet;
    }
}

