/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.HttpFileSystem;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class WebFileObject
extends FileObject {
    WebFileSystem wfs;
    String pathname;
    File localFile;
    Date modifiedDate;
    boolean isRoot;
    boolean isFolder;
    Map<String, String> metadata;
    boolean isFolderResolved = false;

    public boolean canRead() {
        return true;
    }

    synchronized void maybeLoadMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = this.wfs.protocol.getMetadata(this);
        }
    }

    public FileObject[] getChildren() throws IOException {
        if (!this.isFolder) {
            throw new IllegalArgumentException(this.toString() + "is not a folder");
        }
        String[] list = this.wfs.listDirectory(this.pathname);
        FileObject[] result = new FileObject[list.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new WebFileObject(this.wfs, list[i], new Date(System.currentTimeMillis()));
        }
        return result;
    }

    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (this.wfs.protocol != null) {
            return this.wfs.protocol.getInputStream(this, monitor);
        }
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (!this.localFile.exists()) {
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, monitor);
        }
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        return new WebFileObject(this.wfs, this.wfs.getLocalName(this.localFile.getParentFile()), new Date(System.currentTimeMillis()));
    }

    public long getSize() {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        return this.localFile.length();
    }

    public boolean isData() {
        return !this.isFolder;
    }

    public boolean isFolder() {
        if (this.isFolderResolved) {
            return this.isFolder;
        }
        throw new RuntimeException("IOException in constructor prevented us from resolving");
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Date lastModified() {
        if (this.modifiedDate == null) {
            try {
                Map<String, String> meta = this.wfs.protocol.getMetadata(this);
                String stime = meta.get("Last-Modified");
                if (stime != null) {
                    this.modifiedDate = new Date(Date.parse(stime));
                    return this.modifiedDate;
                }
                this.modifiedDate = new Date();
            }
            catch (IOException ex) {
                Logger.getLogger(WebFileObject.class.getName()).log(Level.SEVERE, null, ex);
                return new Date();
            }
        }
        return this.modifiedDate;
    }

    protected File getLocalFile() {
        return this.localFile;
    }

    public boolean exists() {
        if (this.localFile.exists()) {
            return true;
        }
        try {
            if (this.wfs.protocol != null) {
                this.maybeLoadMetadata();
                return "true".equals(this.metadata.get("exist"));
            }
            Logger.getLogger("das2.filesystem").fine("This implementation of WebFileObject.exists() is not optimal");
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, new NullProgressMonitor());
            return this.localFile.exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected WebFileObject(WebFileSystem wfs, String pathname, Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        this.wfs = wfs;
        this.pathname = pathname;
        this.isFolderResolved = false;
        if (!wfs.isAppletMode()) {
            this.localFile = new File(wfs.getLocalRoot(), pathname);
            if (FileSystem.settings().getPersistence() == FileSystemSettings.Persistence.SESSION) {
                this.localFile.deleteOnExit();
            }
            try {
                if (!this.localFile.canRead()) {
                    if (wfs.isDirectory(pathname)) {
                        this.localFile.mkdirs();
                        this.isFolder = true;
                        if ("".equals(pathname)) {
                            this.isRoot = true;
                        }
                    } else {
                        this.isFolder = false;
                    }
                } else {
                    this.isFolder = this.localFile.isDirectory();
                }
                this.isFolderResolved = true;
            }
            catch (IOException ex) {
                this.isFolderResolved = false;
            }
        }
    }

    public String toString() {
        return "[" + this.wfs + "]" + this.getNameExt();
    }

    public String getNameExt() {
        return this.pathname;
    }

    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        InputStream in = this.getInputStream(monitor);
        return Channels.newChannel(in);
    }

    public File getFile(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        Date remoteDate;
        if (this.wfs.isAppletMode()) {
            throw new SecurityException("getFile cannot be used with applets.");
        }
        boolean download = false;
        if (monitor == null) {
            throw new NullPointerException("monitor may not be null");
        }
        if (this.wfs instanceof HttpFileSystem) {
            URL url = this.wfs.getURL(this.getNameExt());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            remoteDate = new Date(connection.getLastModified());
        } else {
            remoteDate = new Date(this.localFile.lastModified());
        }
        if (this.localFile.exists()) {
            Date localFileLastModified = new Date(this.localFile.lastModified());
            if (remoteDate.after(localFileLastModified)) {
                FileSystem.logger.fine("remote file is newer than local copy of " + this.getNameExt() + ", download.");
                download = true;
            }
        } else {
            download = true;
        }
        if (download) {
            if (!this.localFile.getParentFile().exists()) {
                this.localFile.getParentFile().mkdirs();
            }
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, monitor);
        }
        return this.localFile;
    }

    public boolean isLocal() {
        if (this.wfs.isAppletMode()) {
            return false;
        }
        try {
            boolean download = false;
            if (this.localFile.exists()) {
                Date remoteDate;
                if (this.wfs instanceof HttpFileSystem) {
                    URL url = this.wfs.getURL(this.getNameExt());
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("HEAD");
                    connection.connect();
                    remoteDate = new Date(connection.getLastModified());
                } else {
                    remoteDate = new Date(this.localFile.lastModified());
                }
                Date localFileLastModified = new Date(this.localFile.lastModified());
                if (remoteDate.after(localFileLastModified)) {
                    FileSystem.logger.fine("remote file is newer than local copy of " + this.getNameExt() + ", download.");
                    download = true;
                }
            } else {
                download = true;
            }
            return !download;
        }
        catch (IOException e) {
            return false;
        }
    }
}

