/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileObject;

public class LocalFileSystem
extends FileSystem {
    File localRoot;

    protected LocalFileSystem(URL root) throws FileSystem.FileSystemOfflineException {
        super(root);
        if (!"file".equals(root.getProtocol())) {
            throw new IllegalArgumentException("protocol not file: " + root);
        }
        String surl = root.toString();
        if (!surl.endsWith("/")) {
            surl = surl + "/";
        }
        String[] split = FileSystem.splitUrl(surl);
        this.localRoot = new File(split[2].substring(split[0].length()));
        if (!this.localRoot.exists()) {
            File[] roots = File.listRoots();
            if (Arrays.asList(roots).contains(this.localRoot)) {
                throw new FileSystem.FileSystemOfflineException();
            }
            throw new IllegalArgumentException("root does not exist: " + root);
        }
        boolean b = new File("xxx").equals(new File("XXX"));
        this.properties.put("caseInsensitive", b);
    }

    public boolean isDirectory(String filename) {
        return new File(this.localRoot, filename).isDirectory();
    }

    String getLocalName(File file) {
        if (!file.toString().startsWith(this.localRoot.toString())) {
            throw new IllegalArgumentException("file \"" + file + "\"is not of this web file system");
        }
        String filename = file.toString().substring(this.localRoot.toString().length());
        filename = filename.replaceAll("\\\\", "/");
        return filename;
    }

    public String[] listDirectory(String directory) {
        File f = new File(this.localRoot, directory);
        File[] files = f.listFiles();
        String[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getName() + (files[i].isDirectory() ? "/" : "");
        }
        return result;
    }

    public String[] listDirectory(String directory, String regex) {
        File f = new File(this.localRoot, directory);
        final Pattern pattern = Pattern.compile(regex);
        File[] files = f.listFiles(new FilenameFilter(){

            public boolean accept(File file, String name) {
                return pattern.matcher(name).matches();
            }
        });
        String[] result = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = files[i].getName() + (files[i].isDirectory() ? "/" : "");
        }
        return result;
    }

    public String toString() {
        String s = String.valueOf(this.localRoot);
        if (!(s = s.replaceAll("\\\\", "/")).endsWith("/")) {
            s = s + "/";
        }
        return "lfs " + s;
    }

    public FileObject getFileObject(String filename) {
        return new LocalFileObject(this, this.localRoot, filename);
    }

    public File getLocalRoot() {
        return this.localRoot;
    }
}

