/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.das2.DasApplication;
import org.das2.util.Base64;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFileSystem
extends WebFileSystem {
    private HashMap listings;
    private static HashMap instances = new HashMap();
    private HashMap downloads = new HashMap();
    private String userPass;

    private HttpFileSystem(URL root, File localRoot) {
        super(root, localRoot);
        this.listings = new HashMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized HttpFileSystem createHttpFileSystem(URL root) throws FileSystem.FileSystemOfflineException {
        if (instances.containsKey(root.toString())) {
            logger.finer("reusing " + root);
            return (HttpFileSystem)instances.get(root.toString());
        }
        try {
            File local;
            HttpURLConnection urlc = (HttpURLConnection)root.openConnection();
            urlc.setRequestMethod("HEAD");
            if (root.getUserInfo() != null) {
                String encode = Base64.encodeBytes(root.getUserInfo().getBytes());
                urlc.setRequestProperty("Authorization", "Basic " + encode);
            }
            boolean offline = true;
            urlc.connect();
            if (urlc.getResponseCode() != 200 && urlc.getResponseCode() != 403) {
                if (!FileSystem.settings().isAllowOffline()) throw new FileSystem.FileSystemOfflineException("" + urlc.getResponseCode() + ": " + urlc.getResponseMessage());
                logger.fine("remote filesystem is offline, allowing access to local cache.");
            } else {
                offline = false;
            }
            if (DasApplication.hasAllPermission()) {
                local = HttpFileSystem.localRoot(root);
                logger.finer("initializing httpfs " + root + " at " + local);
            } else {
                local = null;
                logger.finer("initializing httpfs " + root + " in applet mode");
            }
            HttpFileSystem result = new HttpFileSystem(root, local);
            result.offline = offline;
            instances.put(root.toString(), result);
            return result;
        }
        catch (FileSystem.FileSystemOfflineException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileSystem.FileSystemOfflineException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void downloadFile(String filename, File f, File partFile, ProgressMonitor monitor) throws IOException {
        block34: {
            logger.fine("downloadFile(" + filename + ")");
            HashMap hashMap = this.downloads;
            synchronized (hashMap) {
                ProgressMonitor mon = (ProgressMonitor)this.downloads.get(filename);
                if (mon != null) {
                    monitor.setProgressMessage("Waiting for file to download");
                    while (mon != null) {
                        while (!mon.isStarted()) {
                            try {
                                this.downloads.wait(100L);
                            }
                            catch (InterruptedException e) {}
                        }
                        monitor.setTaskSize(mon.getTaskSize());
                        monitor.started();
                        if (monitor.isCancelled()) {
                            mon.cancel();
                        }
                        monitor.setTaskProgress(mon.getTaskProgress());
                        try {
                            this.downloads.wait(100L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        mon = (ProgressMonitor)this.downloads.get(filename);
                        logger.finest("waiting for download");
                    }
                    monitor.finished();
                    if (f.exists()) {
                        return;
                    }
                    throw new FileNotFoundException("expected to find " + f);
                }
                this.downloads.put(filename, monitor);
                boolean waitForAnother = false;
            }
            try {
                HttpURLConnection hurlc;
                logger.fine("downloadFile " + filename);
                URL remoteURL = new URL(this.root.toString() + filename);
                URLConnection urlc = remoteURL.openConnection();
                if (this.root.getUserInfo() != null) {
                    String encode = new String(Base64.encodeBytes(this.root.getUserInfo().getBytes()));
                    urlc.setRequestProperty("Authorization", "Basic " + encode);
                }
                if ((hurlc = (HttpURLConnection)urlc).getResponseCode() == 404) {
                    logger.fine("" + hurlc.getResponseCode() + " URL: " + remoteURL);
                    throw new FileNotFoundException("not found: " + remoteURL);
                }
                if (hurlc.getResponseCode() != 200) {
                    logger.fine("" + hurlc.getResponseCode() + " URL: " + remoteURL);
                    throw new IOException(hurlc.getResponseMessage());
                }
                monitor.setTaskSize(urlc.getContentLength());
                if (!f.getParentFile().exists()) {
                    logger.fine("make dirs " + f.getParentFile());
                    f.getParentFile().mkdirs();
                }
                if (partFile.exists()) {
                    logger.fine("clobber file " + f);
                    if (!partFile.delete()) {
                        logger.fine("Unable to clobber file " + f + ", better use it for now.");
                        return;
                    }
                }
                if (partFile.createNewFile()) {
                    InputStream in = urlc.getInputStream();
                    logger.fine("transferring bytes of " + filename);
                    monitor.setLabel("downloading file");
                    monitor.started();
                    FileOutputStream out = new FileOutputStream(partFile);
                    try {
                        this.copyStream(in, out, monitor);
                        monitor.finished();
                        out.close();
                        in.close();
                        partFile.renameTo(f);
                        break block34;
                    }
                    catch (IOException e) {
                        out.close();
                        in.close();
                        partFile.delete();
                        throw e;
                    }
                }
                throw new IOException("couldn't create local file: " + f);
            }
            finally {
                HashMap hashMap2 = this.downloads;
                synchronized (hashMap2) {
                    this.downloads.remove(filename);
                    this.downloads.notifyAll();
                }
            }
        }
    }

    protected Map<String, Object> getHeadMeta(String f) throws IOException {
        String realName = f;
        try {
            URL ur = new URL(this.root, f);
            HttpURLConnection connect = (HttpURLConnection)ur.openConnection();
            connect.setRequestMethod("HEAD");
            HttpURLConnection.setFollowRedirects(false);
            connect.connect();
            HttpURLConnection.setFollowRedirects(true);
            if (connect.getResponseCode() == 303) {
                String surl = connect.getHeaderField("Location");
                if (surl.startsWith(this.root.toString())) {
                    realName = surl.substring(this.root.toString().length());
                }
                connect.disconnect();
                ur = new URL(this.root, realName);
                connect = (HttpURLConnection)ur.openConnection();
                connect.setRequestMethod("HEAD");
                connect.connect();
            }
            boolean exists = connect.getResponseCode() != 404;
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.putAll(connect.getHeaderFields());
            connect.disconnect();
            return result;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public boolean isDirectory(String filename) throws IOException {
        if (this.localRoot == null) {
            return filename.endsWith("/");
        }
        File f = new File(this.localRoot, filename);
        if (f.exists()) {
            return f.isDirectory();
        }
        if (filename.endsWith("/")) {
            return true;
        }
        File parentFile = f.getParentFile();
        String parent = this.getLocalName(parentFile);
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        String[] list = this.listDirectory(parent);
        String lookFor = filename.startsWith("/") ? filename.substring(1) + "/" : filename + "/";
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(lookFor)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listDirectory(String directory) throws IOException {
        if (!this.isDirectory(directory = HttpFileSystem.toCanonicalFilename(directory))) {
            throw new IllegalArgumentException("is not a directory: " + directory);
        }
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        HashMap hashMap = this.listings;
        synchronized (hashMap) {
            if (this.listings.containsKey(directory)) {
                return (String[])this.listings.get(directory);
            }
            URL[] list = HtmlUtil.getDirectoryListing(this.getURL(directory));
            String[] result = new String[list.length];
            int n = directory.length();
            for (int i = 0; i < list.length; ++i) {
                URL url = list[i];
                result[i] = this.getLocalName(url).substring(n);
            }
            this.listings.put(directory, result);
            return result;
        }
    }

    @Override
    public String[] listDirectory(String directory, String regex) throws IOException {
        if (!this.isDirectory(directory = HttpFileSystem.toCanonicalFilename(directory))) {
            throw new IllegalArgumentException("is not a directory: " + directory);
        }
        String[] listing = this.listDirectory(directory);
        Pattern pattern = Pattern.compile(regex + "/?");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < listing.length; ++i) {
            if (!pattern.matcher(listing[i]).matches()) continue;
            result.add(listing[i]);
        }
        return result.toArray(new String[result.size()]);
    }
}

