/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.Base64;
import org.das2.util.filesystem.FileSystem;

public class HtmlUtil {
    public static boolean isDirectory(URL url) {
        String file = url.getFile();
        return file.charAt(file.length() - 1) != '/';
    }

    public static URL[] getDirectoryListing(URL url) throws IOException {
        FileSystem.logger.finer("listing " + url);
        String file = url.getFile();
        if (file.charAt(file.length() - 1) != '/') {
            url = new URL(url.toString() + '/');
        }
        ArrayList<URL> urlList = new ArrayList<URL>();
        long t0 = System.currentTimeMillis();
        URLConnection urlConnection = url.openConnection();
        urlConnection.setAllowUserInteraction(false);
        int contentLength = 10000;
        if (url.getUserInfo() != null) {
            String encode = new String(Base64.encodeBytes(url.getUserInfo().getBytes()));
            urlConnection.setRequestProperty("Authorization", "Basic " + encode);
        }
        InputStream urlStream = urlConnection.getInputStream();
        byte[] b = new byte[10000];
        int numRead = urlStream.read(b);
        StringBuffer contentBuffer = new StringBuffer(contentLength);
        contentBuffer.append(new String(b, 0, numRead));
        while (numRead != -1) {
            FileSystem.logger.finest("download listing");
            numRead = urlStream.read(b);
            if (numRead == -1) continue;
            String newContent = new String(b, 0, numRead);
            contentBuffer.append(newContent);
        }
        urlStream.close();
        String content = contentBuffer.toString();
        String hrefRegex = "(?i)href\\s*=\\s*([\"'])(.+?)\\1";
        Pattern hrefPattern = Pattern.compile(hrefRegex);
        Matcher matcher = hrefPattern.matcher(content);
        while (matcher.find()) {
            FileSystem.logger.finest("parse listing");
            String strLink = matcher.group(2);
            URL urlLink = null;
            try {
                urlLink = new URL(url, strLink);
                strLink = urlLink.toString();
            }
            catch (MalformedURLException e) {
                System.err.println("bad URL: " + url + " " + strLink);
                continue;
            }
            if (!urlLink.toString().startsWith(url.toString()) || null != urlLink.getQuery()) continue;
            urlList.add(urlLink);
        }
        return urlList.toArray(new URL[urlList.size()]);
    }
}

