/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.das2.util.filesystem.WebFileObject;
import org.das2.util.filesystem.WebProtocol;
import org.das2.util.monitor.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebProtocol
implements WebProtocol {
    @Override
    public InputStream getInputStream(WebFileObject fo, ProgressMonitor mon) throws IOException {
        if (fo.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (!fo.localFile.exists()) {
            File partFile = new File(fo.localFile.toString() + ".part");
            fo.wfs.downloadFile(fo.pathname, fo.localFile, partFile, mon);
        }
        return new FileInputStream(fo.localFile);
    }

    @Override
    public Map<String, String> getMetadata(WebFileObject fo) throws IOException {
        if (!fo.wfs.getRootURL().getProtocol().equals("ftp")) {
            String realName = fo.pathname;
            URL ur = new URL(fo.wfs.root, realName);
            HttpURLConnection connect = (HttpURLConnection)ur.openConnection();
            connect.setRequestMethod("HEAD");
            HttpURLConnection.setFollowRedirects(false);
            connect.connect();
            HttpURLConnection.setFollowRedirects(true);
            if (connect.getResponseCode() == 303) {
                String surl = connect.getHeaderField("Location");
                if (surl.startsWith(fo.wfs.root.toString())) {
                    realName = surl.substring(fo.wfs.root.toString().length());
                }
                connect.disconnect();
                ur = new URL(fo.wfs.root, realName);
                connect = (HttpURLConnection)ur.openConnection();
                connect.setRequestMethod("HEAD");
                connect.connect();
            }
            boolean exists = connect.getResponseCode() != 404;
            HashMap<String, String> result = new HashMap<String, String>();
            Map<String, List<String>> fields = connect.getHeaderFields();
            for (String key : fields.keySet()) {
                List<String> value = fields.get(key);
                result.put(key, value.get(0));
            }
            result.put("exist", String.valueOf(exists));
            connect.disconnect();
            return result;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        URL url = new URL(fo.wfs.getRootURL(), fo.pathname);
        URLConnection urlc = url.openConnection();
        try {
            urlc.connect();
            urlc.getInputStream().close();
            result.put("exist", "true");
        }
        catch (IOException ex) {
            result.put("exist", "false");
        }
        return result;
    }
}

