/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakListenerManager {
    public static <L extends EventListener> L weakListener(Object target, Class<L> listenerClass, L listener) {
        String removeMethod = "remove" + listenerClass.getSimpleName();
        return WeakListenerManager.weakListener(target, removeMethod, listenerClass, listener);
    }

    public static <L extends EventListener> L weakListener(Object target, String removeMethod, Class<L> listenerClass, L listener) {
        for (Method m : target.getClass().getMethods()) {
            Class<?>[] params = m.getParameterTypes();
            if (!m.getName().equals(removeMethod) || params.length != 1 || params[0] != listenerClass) continue;
            return WeakListenerManager.weakListener(target, m, listenerClass, listener);
        }
        throw new IllegalArgumentException("No suitable remove method found");
    }

    public static <L extends EventListener> L weakListener(Object target, Method removeMethod, Class<L> listenerClass, L listener) {
        Handler h = new Handler(target, removeMethod, listener);
        Class[] type = new Class[]{listenerClass};
        Object proxy = Proxy.newProxyInstance(null, type, (InvocationHandler)h);
        return (L)((EventListener)listenerClass.cast(proxy));
    }

    private static class Handler
    implements InvocationHandler {
        private final Object target;
        private final Method removeMethod;
        private final WeakReference listener;

        private Handler(Object target, Method removeMethod, Object listener) {
            this.target = target;
            this.removeMethod = removeMethod;
            this.listener = new WeakReference<Object>(listener);
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object l = this.listener.get();
            if (method.getDeclaringClass() == Object.class) {
                String name = method.getName();
                if (name.equals("equals")) {
                    return proxy == args[0];
                }
                if (name.equals("toString")) {
                    return "Proxy@" + System.identityHashCode(proxy) + "[" + this.listener.get() + "]";
                }
                if (name.equals("hashCode")) {
                    return this.hashCode();
                }
                return null;
            }
            if (l == null) {
                try {
                    this.removeMethod.invoke(this.target, proxy);
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                return null;
            }
            return method.invoke(l, args);
        }
    }
}

