/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.components.DasProgressPanel;
import org.das2.dasml.DOMBuilder;
import org.das2.dasml.SerializeUtil;
import org.das2.graph.DasCanvas;
import org.das2.util.filesystem.Glob;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PersistentStateSupport {
    String ext;
    private File currentFile;
    JMenu openRecentMenu;
    SerializationStrategy strategy;
    Component component;
    private JMenuItem saveMenuItem;
    private JLabel currentFileLabel;
    private List recentFiles;
    private boolean dirty;
    public static final String PROPERTY_OPENING = "opening";
    public static final String PROPERTY_SAVING = "saving";
    public static final String PROPERTY_DIRTY = "dirty";
    public static final String PROPERTY_CURRENT_FILE = "currentFile";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean opening;
    private boolean saving;
    private boolean currentFileOpened;

    private static SerializationStrategy getCanvasStrategy(final DasCanvas canvas) {
        return new SerializationStrategy(){

            public Element serialize(Document document, ProgressMonitor monitor) {
                DOMBuilder builder = new DOMBuilder(canvas);
                Element element = builder.serialize(document, DasProgressPanel.createFramed("Serializing Canvas"));
                return element;
            }

            public void deserialize(Document document, ProgressMonitor monitor) {
                Element element = document.getDocumentElement();
                SerializeUtil.processElement(element, canvas);
            }
        };
    }

    public PersistentStateSupport(DasCanvas canvas, String extension) {
        this(canvas, PersistentStateSupport.getCanvasStrategy(canvas), extension);
    }

    private void refreshRecentFilesMenu() {
        if (this.openRecentMenu != null) {
            this.openRecentMenu.removeAll();
            for (int i = 0; i < this.recentFiles.size(); ++i) {
                final File f = (File)this.recentFiles.get(i);
                AbstractAction a = new AbstractAction(String.valueOf(f)){

                    public void actionPerformed(ActionEvent e) {
                        PersistentStateSupport.this.open(f);
                    }
                };
                this.openRecentMenu.add(a);
            }
        }
    }

    private void setRecentFiles(String code) {
        this.recentFiles = new ArrayList();
        if (code.equals("")) {
            return;
        }
        String[] ss = code.split("::");
        for (int i = 0; i < ss.length; ++i) {
            File f = new File(ss[i]);
            if (this.recentFiles.contains(f)) continue;
            this.recentFiles.add(f);
        }
        this.refreshRecentFilesMenu();
    }

    private String getRencentFilesString() {
        if (this.recentFiles.size() == 0) {
            return "";
        }
        String result = String.valueOf(this.recentFiles.get(0));
        for (int i = 1; i < this.recentFiles.size(); ++i) {
            result = result + "::" + String.valueOf(this.recentFiles.get(i));
        }
        return result;
    }

    public PersistentStateSupport(Component parent, SerializationStrategy strategy, String extension) {
        this.strategy = strategy;
        this.ext = "." + extension;
        Preferences prefs = Preferences.userNodeForPackage(PersistentStateSupport.class);
        String currentFileString = prefs.get("PersistentStateSupport" + this.ext, "");
        if (!currentFileString.equals("")) {
            this.setCurrentFile(new File(currentFileString));
        }
        String recentFileString = prefs.get("PersistentStateSupport" + this.ext + "_recent", "");
        this.setRecentFiles(recentFileString);
    }

    private FileFilter simpleFilter(final String glob) {
        final Pattern pattern = Glob.getPattern(glob);
        return new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() || pattern.matcher(pathname.getName()).matches();
            }

            public String getDescription() {
                return glob;
            }
        };
    }

    public Action createSaveAsAction() {
        return new AbstractAction("Save As..."){

            public void actionPerformed(ActionEvent e) {
                PersistentStateSupport.this.saveAs();
            }
        };
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser();
        if (this.getCurrentFile() != null) {
            chooser.setCurrentDirectory(this.getCurrentFile().getParentFile());
        }
        if (this.getCurrentFile() != null) {
            chooser.setSelectedFile(this.getCurrentFile());
        }
        chooser.setFileFilter(this.simpleFilter("*" + this.ext));
        int result = chooser.showSaveDialog(this.component);
        if (result == 0) {
            File f = chooser.getSelectedFile();
            if (!f.getName().endsWith(this.ext)) {
                f = new File(f.getPath() + this.ext);
            }
            this.setCurrentFile(f);
            this.setCurrentFileOpened(true);
            if (this.saveMenuItem != null) {
                this.saveMenuItem.setText("Save");
            }
            if (this.currentFileLabel != null) {
                this.currentFileLabel.setText(String.valueOf(this.getCurrentFile()));
            }
            this.addToRecent(this.getCurrentFile());
            this.save(this.getCurrentFile());
        }
    }

    protected void saveImpl(File f) throws Exception {
        FileOutputStream out = new FileOutputStream(f);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = this.strategy.serialize(document, DasProgressPanel.createFramed("Serializing"));
        document.appendChild(element);
        StringWriter writer = new StringWriter();
        DOMImplementationLS ls = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
        LSOutput output = ls.createLSOutput();
        output.setEncoding("UTF-8");
        output.setByteStream(out);
        LSSerializer serializer = ls.createLSSerializer();
        serializer.write(document, output);
        ((OutputStream)out).close();
    }

    private void save(final File file) {
        this.setSaving(true);
        Runnable run = new Runnable(){

            public void run() {
                try {
                    File f = file;
                    if (!f.getName().endsWith(PersistentStateSupport.this.ext)) {
                        f = new File(f.getPath() + PersistentStateSupport.this.ext);
                    }
                    PersistentStateSupport.this.saveImpl(f);
                    Preferences prefs = Preferences.userNodeForPackage(PersistentStateSupport.class);
                    prefs.put("PersistentStateSupport" + PersistentStateSupport.this.ext, PersistentStateSupport.this.getCurrentFile().getAbsolutePath());
                    PersistentStateSupport.this.setSaving(false);
                    PersistentStateSupport.this.setDirty(false);
                    PersistentStateSupport.this.update();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new RuntimeException(ex);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        new Thread(run, "PersistentStateSupport.save").start();
    }

    public Action createSaveAction() {
        return new AbstractAction("Save"){

            public void actionPerformed(ActionEvent e) {
                if (PersistentStateSupport.this.getCurrentFile() == null) {
                    PersistentStateSupport.this.saveAs();
                } else {
                    PersistentStateSupport.this.save(PersistentStateSupport.this.getCurrentFile());
                }
            }
        };
    }

    public Action createQuitAction() {
        return new AbstractAction("Quit"){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
    }

    public JMenuItem createSaveMenuItem() {
        this.saveMenuItem = new JMenuItem(this.createSaveAction());
        if (this.getCurrentFile() != null) {
            this.saveMenuItem.setText("Save");
        }
        return this.saveMenuItem;
    }

    public JMenu createOpenRecentMenu() {
        JMenu menu = new JMenu("Open Recent");
        menu.add(String.valueOf(this.getCurrentFile()));
        this.openRecentMenu = menu;
        this.refreshRecentFilesMenu();
        return menu;
    }

    public JLabel createCurrentFileLabel() {
        this.currentFileLabel = new JLabel("                  ");
        return this.currentFileLabel;
    }

    private static Document readDocument(File file) throws IOException, ParserConfigurationException, SAXException {
        FileInputStream in = new FileInputStream(file);
        InputSource source = new InputSource();
        source.setCharacterStream(new InputStreamReader(in));
        ErrorHandler eh = null;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        builder.setErrorHandler(eh);
        Document document = builder.parse(source);
        return document;
    }

    private void addToRecent(File file) {
        if (this.recentFiles.contains(file)) {
            return;
        }
        this.recentFiles.add(0, file);
        while (this.recentFiles.size() > 7) {
            this.recentFiles.remove(7);
        }
        Preferences prefs = Preferences.userNodeForPackage(PersistentStateSupport.class);
        prefs.put("PersistentStateSupport" + this.ext + "_recent", this.getRencentFilesString());
        this.refreshRecentFilesMenu();
    }

    public Action createOpenAction() {
        return new AbstractAction("Open..."){

            public void actionPerformed(ActionEvent ev) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    if (PersistentStateSupport.this.getCurrentFile() != null) {
                        chooser.setCurrentDirectory(PersistentStateSupport.this.getCurrentFile().getParentFile());
                    }
                    chooser.setFileFilter(PersistentStateSupport.this.simpleFilter("*" + PersistentStateSupport.this.ext));
                    int result = chooser.showOpenDialog(PersistentStateSupport.this.component);
                    if (result == 0) {
                        PersistentStateSupport.this.open(chooser.getSelectedFile());
                        PersistentStateSupport.this.addToRecent(PersistentStateSupport.this.getCurrentFile());
                        if (PersistentStateSupport.this.saveMenuItem != null) {
                            PersistentStateSupport.this.saveMenuItem.setText("Save");
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected void openImpl(File file) throws Exception {
        Document document = PersistentStateSupport.readDocument(file);
        this.strategy.deserialize(document, DasProgressPanel.createFramed("deserializing"));
    }

    private void open(final File file) {
        this.setOpening(true);
        Runnable run = new Runnable(){

            public void run() {
                try {
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(PersistentStateSupport.this.component, "File not found: " + file, "File not found", 2);
                        return;
                    }
                    PersistentStateSupport.this.openImpl(file);
                    PersistentStateSupport.this.setOpening(false);
                    PersistentStateSupport.this.setDirty(false);
                    PersistentStateSupport.this.setCurrentFile(file);
                    PersistentStateSupport.this.setCurrentFileOpened(true);
                    PersistentStateSupport.this.update();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        new Thread(run, "PersistentStateSupport.open").start();
    }

    public void close() {
        this.setCurrentFile(null);
    }

    public void markDirty() {
        this.setDirty(true);
        this.update();
    }

    private void update() {
        if (this.currentFileLabel != null) {
            this.currentFileLabel.setText(this.getCurrentFile() + (this.dirty ? " *" : ""));
        }
    }

    public PersistentStateSupport() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_DIRTY, new Boolean(oldDirty), new Boolean(dirty));
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File currentFile) {
        File oldFile = this.currentFile;
        this.currentFile = currentFile;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_CURRENT_FILE, oldFile, currentFile);
    }

    public boolean isOpening() {
        return this.opening;
    }

    public boolean isSaving() {
        return this.saving;
    }

    private void setOpening(boolean b) {
        boolean old = this.opening;
        this.opening = b;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_OPENING, (Object)old, (Object)b);
    }

    private void setSaving(boolean b) {
        boolean old = this.saving;
        this.saving = b;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_SAVING, (Object)old, (Object)b);
    }

    public boolean isCurrentFileOpened() {
        return this.currentFileOpened;
    }

    public void setCurrentFileOpened(boolean currentFileOpened) {
        boolean oldCurrentFileOpened = this.currentFileOpened;
        this.currentFileOpened = currentFileOpened;
        this.propertyChangeSupport.firePropertyChange("currentFileOpened", new Boolean(oldCurrentFileOpened), new Boolean(currentFileOpened));
    }

    public static interface SerializationStrategy {
        public Element serialize(Document var1, ProgressMonitor var2) throws IOException;

        public void deserialize(Document var1, ProgressMonitor var2);
    }
}

