/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class NBConsoleFormatter
extends Formatter {
    boolean coalesce = true;
    String lastMessage = null;
    int coalesceHits = 0;

    public String format(LogRecord rec) {
        if (this.coalesce && this.lastMessage != null && this.lastMessage.equals(rec.getMessage())) {
            ++this.coalesceHits;
            return "";
        }
        StackTraceElement[] st = new Throwable().getStackTrace();
        String result = rec.getLoggerName() + "  [" + Thread.currentThread().getName() + "]\n" + rec.getLevel().getLocalizedName() + ": " + rec.getMessage() + "\n\tat " + st[7] + (st.length > 8 ? "\n\tat " + st[8] + "\n" : "\n");
        if (this.coalesceHits > 0) {
            result = "(Last message repeats " + (this.coalesceHits + 1) + " times)\n" + result;
        }
        this.coalesceHits = 0;
        this.lastMessage = rec.getMessage();
        return result;
    }
}

