/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class InflaterChannel
implements ReadableByteChannel {
    private boolean closed = false;
    private boolean eof = false;
    private ReadableByteChannel in;
    private Inflater inflater;
    private ByteBuffer buf;
    private byte[] outBuf;

    public InflaterChannel(ReadableByteChannel in) {
        this.in = in;
        byte[] array = new byte[4096];
        this.buf = ByteBuffer.wrap(array);
        this.inflater = new Inflater();
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
            this.in = null;
            this.inflater.end();
            this.inflater = null;
            this.buf = null;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public synchronized int read(ByteBuffer dst) throws IOException {
        try {
            int totalOut;
            int bytesRead;
            int length;
            int offset;
            byte[] outBuf;
            if (this.closed) {
                throw new ClosedChannelException();
            }
            if (this.eof && this.inflater.finished()) {
                return -1;
            }
            if (dst.hasArray()) {
                outBuf = dst.array();
                offset = dst.arrayOffset() + dst.position();
                length = dst.remaining();
            } else {
                outBuf = this.outBuf == null ? (this.outBuf = new byte[4096]) : this.outBuf;
                offset = 0;
                length = Math.min(outBuf.length, dst.remaining());
            }
            for (totalOut = 0; totalOut < length; totalOut += bytesRead) {
                if (this.inflater.needsInput()) {
                    this.buf.clear();
                    if (this.in.read(this.buf) == -1) {
                        this.eof = true;
                    }
                    this.buf.flip();
                    this.inflater.setInput(this.buf.array(), this.buf.arrayOffset(), this.buf.remaining());
                }
                bytesRead = this.inflater.inflate(outBuf, offset + totalOut, length - totalOut);
                if (!this.inflater.finished()) continue;
            }
            if (dst.hasArray()) {
                dst.position(dst.position() + totalOut);
            } else {
                dst.put(outBuf, 0, totalOut);
            }
            return totalOut;
        }
        catch (DataFormatException dfe) {
            this.eof = true;
            this.close();
            IOException ioe = new IOException(dfe.getMessage());
            ioe.initCause(dfe);
            throw ioe;
        }
    }
}

