/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.das2.DasApplication;

public final class DasExceptionHandler {
    private static final String UNCAUGHT = "An unexpected error has occurred.  The system may not be able to recover properly.  Please report this error to the Das2 bug database at http://bugs-pw.physics.uiowa.edu/.  Please include all error information and a description of how you encountered the error.  For your convenience, you may click the \"Show Details\" button then click the \"Save to file\" button to save all the relevant error messages to a file.\n";

    public static void handle(Throwable t) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            t.printStackTrace();
        } else {
            DasExceptionHandler.showExceptionDialog(t, "");
        }
    }

    public static void handleUncaught(Throwable t) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            t.printStackTrace();
        } else {
            DasExceptionHandler.showExceptionDialog(t, UNCAUGHT);
        }
    }

    private static void showExceptionDialog(final Throwable t, String extraInfo) {
        String errorMessage = extraInfo + t.getClass().getName() + "\n" + (t.getMessage() == null ? "" : t.getMessage());
        final JDialog dialog = new JDialog(DasApplication.getDefaultApplication().getMainFrame());
        dialog.setTitle("Error in das2");
        dialog.setModal(false);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        JTextArea messageArea = new JTextArea(10, 40);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setEditable(false);
        messageArea.setText(errorMessage);
        JScrollPane message = new JScrollPane(messageArea);
        message.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)message, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton("Ok");
        final JToggleButton details = new JToggleButton("Show Details");
        buttonPanel.add(ok);
        buttonPanel.add(details);
        mainPanel.add((Component)buttonPanel, "South");
        dialog.getContentPane().add((Component)mainPanel, "Center");
        final JTextArea traceArea = new JTextArea(10, 40);
        traceArea.setLineWrap(false);
        traceArea.setEditable(false);
        traceArea.setTabSize(4);
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        traceArea.setText(writer.toString());
        final JPanel stackPane = new JPanel(new BorderLayout());
        stackPane.add((Component)new JScrollPane(traceArea), "North");
        stackPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel buttonPanel2 = new JPanel(new FlowLayout(2));
        buttonPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        JButton dump = new JButton("Dump to STDERR");
        JButton save = new JButton("Save to file");
        buttonPanel2.add(dump);
        buttonPanel2.add(save);
        stackPane.add((Component)buttonPanel2, "South");
        Dimension size = message.getPreferredSize();
        size.width = stackPane.getPreferredSize().width;
        message.setPreferredSize(size);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        details.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (details.isSelected()) {
                    details.setText("Less Details");
                    dialog.getContentPane().add((Component)stackPane, "South");
                    dialog.pack();
                } else {
                    details.setText("More Details");
                    dialog.getContentPane().remove(stackPane);
                    dialog.pack();
                }
            }
        });
        dump.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text = traceArea.getText();
                System.err.print(text);
            }
        });
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    int result = chooser.showSaveDialog(dialog);
                    if (result == 0) {
                        File selected = chooser.getSelectedFile();
                        PrintWriter out = new PrintWriter(new FileOutputStream(selected));
                        t.printStackTrace(out);
                        out.close();
                    }
                }
                catch (IOException ioe) {
                    DasExceptionHandler.handle(ioe);
                }
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }
}

