/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.das2.system.DasLogger;

public class ArgumentList {
    int nposition;
    String programName;
    String[] positionKeys;
    HashMap values;
    HashMap descriptions;
    HashMap names;
    HashMap reverseNames;
    HashMap formUsed;
    HashMap abbrevs;
    HashMap isBoolean;
    ArrayList requireOneOfList;
    boolean allowUndefinedSwitch = false;
    private String UNSPECIFIED = new String("__unspecified__");
    private String REFERENCEWITHOUTVALUE = new String("__referencewithoutvalue__");
    private String UNDEFINED_SWITCH = new String("__undefinedSwitch__");
    private String FALSE = new String("__false__");
    private String TRUE = new String("__true__");
    private static final Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);

    public ArgumentList(String programName) {
        this.programName = programName;
        this.positionKeys = new String[10];
        this.values = new HashMap();
        this.descriptions = new HashMap();
        this.names = new HashMap();
        this.reverseNames = new HashMap();
        this.abbrevs = new HashMap();
        this.formUsed = new HashMap();
        this.requireOneOfList = new ArrayList();
    }

    public String getValue(String key) {
        if (this.values.containsKey(key)) {
            return (String)this.values.get(key);
        }
        throw new IllegalArgumentException("No such key: " + key);
    }

    public Preferences getPreferences() {
        return new AbstractPreferences(null, ""){

            protected void putSpi(String key, String value) {
                ArgumentList.this.formUsed.put(key, value);
                ArgumentList.this.values.put(key, value);
            }

            protected String getSpi(String key) {
                if (ArgumentList.this.formUsed.containsKey(key)) {
                    return (String)ArgumentList.this.values.get(key);
                }
                return null;
            }

            protected void removeSpi(String key) {
            }

            protected void removeNodeSpi() throws BackingStoreException {
            }

            protected String[] keysSpi() throws BackingStoreException {
                return ArgumentList.this.values.keySet().toArray(new String[ArgumentList.this.values.size()]);
            }

            protected String[] childrenNamesSpi() throws BackingStoreException {
                return new String[0];
            }

            protected AbstractPreferences childSpi(String name) {
                return null;
            }

            protected void syncSpi() throws BackingStoreException {
            }

            protected void flushSpi() throws BackingStoreException {
            }
        };
    }

    public boolean getBooleanValue(String key) {
        return this.values.get(key) == this.TRUE;
    }

    public void addPositionArgument(int position, String key, String description) {
        if (position > this.nposition) {
            throw new IllegalArgumentException("Position arguments must be specified 0,1,2,3: position=" + position);
        }
        if (position > this.positionKeys.length) {
            throw new IllegalArgumentException("Position too big: position=" + position);
        }
        this.nposition = position + 1;
        this.positionKeys[position] = key;
        this.descriptions.put(key, description);
        this.values.put(key, this.UNSPECIFIED);
    }

    public void requireOneOf(String[] keyNames) {
        this.requireOneOfList.add(keyNames);
    }

    public void addOptionalPositionArgument(int position, String key, String defaultValue, String description) {
        this.addPositionArgument(position, key, description);
        this.values.put(key, defaultValue);
    }

    public void addSwitchArgument(String name, String abbrev, String key, String description) {
        if (abbrev == null && name == null) {
            throw new IllegalArgumentException("both abbrev and name are null, one must be specified");
        }
        this.descriptions.put(key, description);
        if (abbrev != null) {
            if (this.abbrevs.containsKey(abbrev)) {
                throw new IllegalArgumentException("abbrev already used: " + abbrev);
            }
            this.abbrevs.put(abbrev, key);
        }
        if (name != null) {
            this.names.put(name, key);
            this.reverseNames.put(key, name);
        }
        this.values.put(key, this.UNSPECIFIED);
    }

    public void addOptionalSwitchArgument(String name, String abbrev, String key, String defaultValue, String description) {
        this.addSwitchArgument(name, abbrev, key, description);
        this.values.put(key, defaultValue);
    }

    public void addBooleanSwitchArgument(String name, String abbrev, String key, String description) {
        if (key.equals("commandLinePrefs")) {
            this.allowUndefinedSwitch = true;
        }
        this.addOptionalSwitchArgument(name, abbrev, key, this.FALSE, description);
    }

    public void printUsage() {
        Object description;
        Object key;
        String s = "Usage: " + this.programName + " ";
        for (int i = 0; i < this.nposition; ++i) {
            String key2 = this.positionKeys[i];
            s = this.values.get(key2) != this.UNSPECIFIED ? s + "[" + this.descriptions.get(key2) + "] " : s + "<" + this.descriptions.get(key2) + "> ";
        }
        System.err.println(s);
        Set set = this.names.keySet();
        for (Object name : set) {
            key = this.names.get(name);
            s = "  ";
            description = this.descriptions.get(key);
            s = this.values.get(key) != this.UNSPECIFIED ? (this.values.get(key) == this.FALSE || this.values.get(key) == this.TRUE ? s + "--" + name + "   " + description : s + "--" + name + "=" + description + " ") : s + "--" + name + "=" + description + " (required)";
            System.err.println(s);
        }
        set = this.abbrevs.keySet();
        for (Object abbrev : set) {
            key = this.abbrevs.get(abbrev);
            s = "  ";
            description = this.descriptions.get(key);
            s = this.values.get(key) != this.UNSPECIFIED ? (this.values.get(key) == this.FALSE || this.values.get(key) == this.TRUE ? s + "-" + abbrev + "   \t" + description : s + "-" + abbrev + "=" + description + " ") : s + "-" + abbrev + "=" + description + " (required)";
            System.err.println(s);
        }
    }

    private void checkArgs() {
        boolean error = false;
        ArrayList<String> errorList = new ArrayList<String>();
        int i = 0;
        while (!error & i < this.nposition) {
            if (this.values.get(this.positionKeys[i]) == this.UNSPECIFIED) {
                errorList.add("Expected more positional arguments, only got " + i);
                error = true;
            }
            ++i;
        }
        if (!error) {
            for (Object key : this.values.keySet()) {
                if (key.equals("help") || key.equals("--help")) {
                    this.printUsage();
                    System.exit(-1);
                }
                if (this.values.get(key) == this.UNSPECIFIED) {
                    errorList.add("Argument needed: --" + this.reverseNames.get(key));
                }
                if (this.values.get(key) == this.REFERENCEWITHOUTVALUE) {
                    errorList.add("Switch requires argument: " + this.formUsed.get(key));
                }
                if (this.values.get(key) != this.UNDEFINED_SWITCH || this.allowUndefinedSwitch) continue;
                errorList.add("Not a valid switch: " + this.formUsed.get(key));
            }
        }
        if (!error) {
            for (i = 0; i < this.requireOneOfList.size(); ++i) {
                String[] keys = (String[])this.requireOneOfList.get(i);
                boolean haveValue = false;
                for (int j = 0; j < keys.length; ++j) {
                    if (!(!this.values.get(keys[j]).equals(this.UNSPECIFIED) & !this.values.get(keys[j]).equals(this.UNDEFINED_SWITCH) & !this.values.get(keys[j]).equals(this.REFERENCEWITHOUTVALUE))) continue;
                    haveValue = true;
                }
                if (haveValue) continue;
                StringBuffer list = new StringBuffer((String)this.reverseNames.get(keys[0]));
                for (int j = 1; j < keys.length; ++j) {
                    list.append(", " + (String)this.reverseNames.get(keys[j]));
                }
                errorList.add("One of the following needs to be specified: " + list.toString());
            }
        }
        if (errorList.size() > 0) {
            this.printUsage();
            System.err.println("");
            for (int ii = 0; ii < errorList.size(); ++ii) {
                System.err.println(errorList.get(ii));
            }
            System.exit(-1);
        }
    }

    public Map getMap() {
        return new HashMap(this.values);
    }

    public Map getOptions() {
        HashMap result = new HashMap();
        List<String> exclude = Arrays.asList(this.positionKeys);
        for (String key : this.values.keySet()) {
            if (exclude.contains(key) || !this.formUsed.containsKey(key)) continue;
            result.put(key, this.values.get(key));
        }
        return result;
    }

    private int processSwitch(String[] args, int i) {
        String key;
        if (args[i].startsWith("--")) {
            String name = args[i].substring(2);
            if (name.indexOf(61) != -1) {
                name = name.substring(0, name.indexOf(61));
            }
            key = (String)this.names.get(name);
        } else {
            String abbrev = args[i].substring(1);
            if (abbrev.indexOf(61) != -1) {
                abbrev = abbrev.substring(0, abbrev.indexOf(61));
            }
            key = (String)this.abbrevs.get(abbrev);
        }
        if (key == null) {
            key = args[i];
            this.values.put(key, this.UNDEFINED_SWITCH);
            this.formUsed.put(key, args[i]);
            logger.finer("undefined switch: " + key);
        } else {
            this.formUsed.put(key, args[i]);
            if (this.values.get(key) == this.FALSE || this.values.get(key) == this.TRUE) {
                this.values.put(key, this.TRUE);
            } else {
                String value;
                if (args[i].indexOf(61) != -1) {
                    value = args[i].substring(args[i].indexOf(61) + 1);
                } else if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    value = args[i + 1];
                    ++i;
                } else {
                    value = this.REFERENCEWITHOUTVALUE;
                }
                if (value.startsWith("\"")) {
                    value = value.substring(1, value.length() - 2);
                }
                logger.finer("switch key: " + key + "=" + value);
                this.values.put(key, value);
            }
        }
        return i;
    }

    public void process(String[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            sb.append(" ");
        }
        logger.fine("args: " + sb.toString());
        int iposition = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                i = this.processSwitch(args, i);
                continue;
            }
            String key = this.positionKeys[iposition];
            logger.finer("position key: " + key + "=" + args[i]);
            String vv = args[i];
            if (vv.startsWith("\"")) {
                vv = vv.substring(1, vv.length() - 2);
            }
            this.values.put(key, args[i]);
            ++iposition;
            this.formUsed.put(key, args[i]);
        }
        this.checkArgs();
    }

    public void printPrefsSettings() {
        String s = "Explicit Settings: \n";
        s = s + this.programName + " ";
        for (int i = 0; i < this.nposition; ++i) {
            String key = this.positionKeys[i];
            if (this.formUsed.get(key) == null) continue;
            s = s + this.formUsed.get(key);
        }
        Set set = this.names.keySet();
        for (Object name : set) {
            Object key = this.names.get(name);
            String value = (String)this.formUsed.get(key);
            if (value == null) continue;
            if (value == this.TRUE) {
                s = s + "--" + name;
            }
            if (value == this.FALSE) continue;
            s = s + "--" + name + "=" + value + " ";
        }
        System.err.println(s);
    }
}

