/*
 * Decompiled with CFR 0.152.
 */
package org.das2.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;

public class UserMessageCenter {
    private static UserMessageCenter instance;
    List messageRecords;
    HashMap sources = new HashMap();
    int tabCount;
    private JTabbedPane pane;
    private JFrame frame;

    public static UserMessageCenter getDefault() {
        if (instance == null) {
            instance = new UserMessageCenter();
        }
        return instance;
    }

    private UserMessageCenter() {
        this.createComponents();
        this.messageRecords = new ArrayList();
    }

    public void notifyUser(Object source, String message) {
        JTextPane textComponent = new JTextPane();
        if (message.startsWith("<html>")) {
            textComponent.setContentType("text/html");
        }
        try {
            textComponent.getEditorKit().read(new StringReader(message), textComponent.getDocument(), 0);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        this.notifyUser(source, textComponent);
    }

    private void notifyUser(Object source, JTextPane message) {
        HashMap sourceMessages = (HashMap)this.sources.get(source);
        if (sourceMessages != null && sourceMessages.containsKey(message.getText())) {
            this.frame.setVisible(true);
            return;
        }
        if (sourceMessages == null) {
            sourceMessages = new HashMap();
            this.sources.put(source, sourceMessages);
        }
        sourceMessages.put(message.getText(), null);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)message, "Center");
        JButton nextButton = new JButton(this.getNextAction());
        panel.add((Component)nextButton, "South");
        this.pane.add((Component)panel, this.tabCount);
        ++this.tabCount;
        if (this.tabCount > 0) {
            this.frame.setVisible(true);
        }
        MessageRecord record = new MessageRecord();
        record.component = panel;
        record.nextButton = nextButton;
        this.messageRecords.add(record);
        this.update();
    }

    private void update() {
        for (int i = 0; i < this.messageRecords.size(); ++i) {
            MessageRecord record = (MessageRecord)this.messageRecords.get(i);
            record.nextButton.setEnabled(i < this.messageRecords.size() - 1);
        }
    }

    private Action getNextAction() {
        return new AbstractAction("Next >>"){

            public void actionPerformed(ActionEvent e) {
                UserMessageCenter.this.next();
            }
        };
    }

    private void next() {
        int currentTab = this.pane.getSelectedIndex();
        if (currentTab < this.tabCount - 1) {
            this.pane.setSelectedIndex(++currentTab);
        }
    }

    private void prev() {
        int currentTab = this.pane.getSelectedIndex();
        if (currentTab > 0) {
            this.pane.setSelectedIndex(--currentTab);
        }
    }

    private void createComponents() {
        this.frame = new JFrame("das2 messages");
        this.frame.setDefaultCloseOperation(1);
        this.pane = new JTabbedPane();
        this.pane.setOpaque(true);
        this.pane.setPreferredSize(new Dimension(400, 300));
        this.pane.setMinimumSize(this.pane.getPreferredSize());
        this.frame.setContentPane(this.pane);
        this.frame.pack();
    }

    public void notifyUser(Object source, Throwable e) {
        this.notifyUser(source, e.getMessage());
    }

    class MessageRecord {
        JButton nextButton;
        Component component;

        MessageRecord() {
        }
    }
}

