/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream.test;

import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.PacketDescriptor;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.stream.StreamProducer;
import org.das2.stream.StreamXDescriptor;
import org.das2.stream.StreamYScanDescriptor;

public class RipplesStream {
    private boolean compress;
    double x1;
    double y1;
    double p1;
    double x2;
    double y2;
    double p2;

    public RipplesStream(boolean compress) {
        this(14.0, 17.0, 10.0, 20.0, 60.0, 15.0, compress);
    }

    public RipplesStream(double x1, double y1, double p1, double x2, double y2, double p2, boolean compress) {
        this.x1 = x1;
        this.y1 = y1;
        this.p1 = p1;
        this.x2 = x2;
        this.y2 = y2;
        this.p2 = p2;
        this.compress = compress;
    }

    public void produceRipplesStream(WritableByteChannel out) {
        try {
            StreamProducer producer = new StreamProducer(out);
            StreamDescriptor sd = new StreamDescriptor();
            if (this.compress) {
                sd.setCompression("deflate");
            }
            producer.streamDescriptor(sd);
            int nx = 100;
            int ny = 100;
            double[] y = new double[ny];
            for (int j = 0; j < y.length; ++j) {
                y[j] = j;
            }
            StreamXDescriptor xDescriptor = new StreamXDescriptor();
            xDescriptor.setDataTransferType(DataTransferType.getByName("ascii10"));
            xDescriptor.setUnits(Units.dimensionless);
            StreamYScanDescriptor yscan = new StreamYScanDescriptor();
            yscan.setDataTransferType(DataTransferType.getByName("ascii10"));
            yscan.setYCoordinates(y);
            PacketDescriptor pd = new PacketDescriptor();
            pd.setXDescriptor(xDescriptor);
            pd.addYDescriptor(yscan);
            producer.packetDescriptor(pd);
            double[] z = new double[ny];
            DatumVector[] scans = new DatumVector[1];
            for (int i = 0; i < nx; ++i) {
                Datum xTag = Datum.create((double)i);
                for (int j = 0; j < y.length; ++j) {
                    double rad1 = Math.sqrt(((double)i - this.x1) * ((double)i - this.x1) + ((double)j - this.y1) * ((double)j - this.y1));
                    double exp1 = Math.exp(-rad1 / this.p1) * Math.cos(Math.PI * this.p1 * rad1);
                    double rad2 = Math.sqrt((i - nx * 2 / 3) * (i - nx * 2 / 3) + (j - ny * 2 / 3) * (j - ny * 2 / 3));
                    double exp2 = Math.exp(-rad2 / this.p2) * Math.cos(Math.PI * this.p2 * rad2);
                    z[j] = exp1 + exp2;
                }
                scans[0] = DatumVector.newDatumVector(z, Units.dimensionless);
                producer.packet(pd, xTag, scans);
            }
            producer.streamClosed(sd);
        }
        catch (StreamException se) {
            se.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        List<String> argList = Arrays.asList(args);
        boolean c = argList.contains("-c");
        WritableByteChannel out = Channels.newChannel(System.out);
        RipplesStream rs = new RipplesStream(c);
        rs.produceRipplesStream(out);
    }
}

