/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.das2.DasException;
import org.das2.DasIOException;
import org.das2.client.DataSetDescriptorNotAvailableException;
import org.das2.client.StandardDataStreamSource;
import org.das2.client.StreamDataSetDescriptor;
import org.das2.dataset.DataSetDescriptor;
import org.das2.datum.Datum;
import org.das2.stream.StreamDescriptor;

public class LocalFileStandardDataStreamSource
implements StandardDataStreamSource {
    private File file;

    public LocalFileStandardDataStreamSource(File file) {
        this.file = file;
    }

    public InputStream getInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end) throws DasException {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException ioe) {
            throw new DasIOException(ioe);
        }
    }

    public InputStream getReducedInputStream(StreamDataSetDescriptor dsd, Datum start, Datum end, Datum timeResolution) throws DasException {
        return this.getInputStream(dsd, start, end);
    }

    public void reset() {
    }

    public static DataSetDescriptor newDataSetDescriptor(Map map) throws DataSetDescriptorNotAvailableException {
        String filename = (String)map.get("file");
        File file = new File(filename);
        StreamDescriptor sd = new StreamDescriptor();
        return new StreamDataSetDescriptor(sd, new LocalFileStandardDataStreamSource(file));
    }
}

