/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.stream.DataTransferType;
import org.das2.stream.SkeletonDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StreamXDescriptor
implements SkeletonDescriptor,
Cloneable {
    private Datum base;
    private Units baseUnits = Units.us2000;
    private Units units = null;
    private DataTransferType transferType = DataTransferType.SUN_REAL4;
    Map properties = new HashMap();

    public StreamXDescriptor() {
    }

    public StreamXDescriptor(Element element) {
        if (element.getTagName().equals("x")) {
            this.processElement(element);
        } else {
            this.processLegacyElement(element);
        }
    }

    private void processElement(Element element) {
        String typeStr = element.getAttribute("type");
        DataTransferType type = DataTransferType.getByName(typeStr);
        if (type == null) {
            throw new RuntimeException("Illegal transfer type: " + typeStr);
        }
        this.transferType = type;
        if (type instanceof DataTransferType.Time) {
            this.units = ((DataTransferType.Time)type).getUnits();
        } else {
            String unitsString = element.getAttribute("units");
            this.units = Units.getByName(unitsString);
        }
        String baseString = element.getAttribute("base");
        if (baseString != null && !baseString.equals("") && this.baseUnits instanceof TimeLocationUnits) {
            this.base = TimeUtil.createValid(baseString);
        }
    }

    private void processLegacyElement(Element element) {
        String typeStr = element.getAttribute("type");
        DataTransferType type = DataTransferType.getByName(typeStr);
        if (type == null) {
            throw new RuntimeException("Illegal transfer type: " + typeStr);
        }
        this.transferType = type;
    }

    public Datum getBase() {
        return this.base;
    }

    public void setBase(Datum base) {
        this.base = base;
    }

    public int getSizeBytes() {
        return this.transferType.getSizeBytes();
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public void setDataTransferType(DataTransferType transferType) {
        this.transferType = transferType;
        if (transferType instanceof DataTransferType.Time) {
            if (this.units == null) {
                throw new IllegalArgumentException("please set the units first!!!");
            }
            ((DataTransferType.Time)transferType).units = this.units;
        }
    }

    public DataTransferType getDataTransferType() {
        return this.transferType;
    }

    public Datum readDatum(ByteBuffer input) {
        return Datum.create(this.transferType.read(input), this.units);
    }

    public DatumVector read(ByteBuffer input) {
        return DatumVector.newDatumVector(new double[]{this.transferType.read(input)}, this.units);
    }

    public void writeDatum(Datum datum, ByteBuffer output) {
        this.transferType.write(datum.doubleValue(this.units), output);
    }

    public void write(DatumVector input, ByteBuffer output) {
        this.transferType.write(input.doubleValue(0, this.units), output);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("x");
        if (this.base != null) {
            element.setAttribute("base", this.base.toString());
        }
        element.setAttribute("units", this.units.toString());
        element.setAttribute("type", this.transferType.toString());
        return element;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Map getProperties() {
        return new HashMap(this.properties);
    }
}

