/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import org.das2.DasException;
import org.das2.client.DataSetStreamHandler;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.stream.StreamException;
import org.das2.util.StreamTool;
import org.das2.util.monitor.NullProgressMonitor;

public class StreamUtil {
    private static final String DATA_SET_ID_PREFIX = "class:org.das2.stream.test.LocalFileStandardDataStreamSource?file=";

    public static TableDataSet loadTableDataSet(String filename) {
        try {
            filename = URLEncoder.encode(filename, "UTF-8");
            DataSetDescriptor dsd = DataSetDescriptor.create(DATA_SET_ID_PREFIX + filename);
            dsd.setDefaultCaching(false);
            DataSet ds = dsd.getDataSet(null, null, null, null);
            return (TableDataSet)ds;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
    }

    public static DataSet loadDataSetNew(String filename) throws IOException, StreamException {
        FileInputStream in = new FileInputStream(filename);
        FileChannel channel = in.getChannel();
        DataSetStreamHandler handler = new DataSetStreamHandler(new HashMap(), new NullProgressMonitor());
        StreamTool.readStream(channel, handler);
        return handler.getDataSet();
    }

    public static DataSet loadDataSet(String filename) {
        try {
            filename = URLEncoder.encode(filename, "UTF-8");
            DataSetDescriptor dsd = DataSetDescriptor.create(DATA_SET_ID_PREFIX + filename);
            dsd.setDefaultCaching(false);
            DataSet ds = dsd.getDataSet(null, null, null, null);
            return ds;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
    }
}

