/*
 * Decompiled with CFR 0.152.
 */
package org.das2.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.das2.DasProperties;

public abstract class StreamProcessor {
    public abstract void process(InputStream var1, OutputStream var2) throws IOException;

    public InputStream process(final InputStream in) throws IOException {
        final PipedOutputStream out = new PipedOutputStream();
        PipedInputStream pin = new PipedInputStream(out);
        Runnable r = new Runnable(){

            public void run() {
                try {
                    StreamProcessor.this.process(in, out);
                    out.close();
                }
                catch (IOException e) {
                    try {
                        out.write(StreamProcessor.this.getDasExceptionStream(e));
                    }
                    catch (IOException e2) {
                        DasProperties.getLogger().severe(e2.toString());
                        throw new RuntimeException(e2);
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
        return pin;
    }

    public byte[] getDasExceptionStream(Throwable t) {
        String exceptionString = "[xx]<exception rootCause=\"" + t.toString() + "\"/>";
        return exceptionString.getBytes();
    }
}

