/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math.matrix;

import org.das2.math.matrix.Matrix;

public class CompositeMatrix
extends Matrix {
    private Matrix m1;
    private Matrix m2;

    public CompositeMatrix(Matrix m1, Matrix m2) {
        super(m1.rowCount(), m1.columnCount());
        if (m1.rowCount() != m2.rowCount() && m1.columnCount() != m2.columnCount()) {
            throw new IllegalArgumentException("m1 and m2 must have the same number of rows and columns");
        }
        this.m1 = m1;
        this.m2 = m2;
    }

    public double get(int row, int col) {
        return this.m1.get(row, col);
    }

    public void rowTimes(int row, double s) {
        this.m1.rowTimes(row, s);
        this.m2.rowTimes(row, s);
    }

    public void rowTimesAddTo(int srcRow, double s, int dstRow) {
        this.m1.rowTimesAddTo(srcRow, s, dstRow);
        this.m2.rowTimesAddTo(srcRow, s, dstRow);
    }

    public void set(int row, int col, double d) {
        throw new UnsupportedOperationException("Setting values not supported");
    }

    public void swapRows(int row1, int row2) {
        this.m1.swapRows(row1, row2);
        this.m2.swapRows(row1, row2);
    }
}

