/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import org.das2.math.AlgorithmUI;
import org.das2.math.AnimateControl;
import org.das2.math.RealWindow;
import org.das2.math.RealWindowGraphics;
import org.das2.math.Triangulation;
import org.das2.math.TriangulationCanvas;

abstract class TriangulationAlgorithm {
    String algName;
    TriangulationCanvas triCanvas;
    AnimateControl aniControl;
    AlgorithmUI algorithmUI;
    RealWindow w;
    RealWindowGraphics rWG;
    final int nStates = 5;
    boolean[] state = new boolean[5];
    static final int triangulationState = 0;
    static final int pointState = 1;
    static final int triangleState = 2;
    static final int insideState = 4;
    static final int edgeState = 5;

    public TriangulationAlgorithm(Triangulation t, RealWindow w, String name, int nPoints) {
        this.algName = name;
        this.aniControl = new AnimateControl(this, nPoints);
        this.algorithmUI = new AlgorithmUI(this, name, nPoints, this.aniControl.getPause());
        this.triCanvas = new TriangulationCanvas(t, w, this);
        for (int s = 0; s < 5; ++s) {
            this.state[s] = false;
        }
        this.triCanvas.needToClear = true;
    }

    public void setCanvas(TriangulationCanvas tc) {
        this.triCanvas = tc;
    }

    public AnimateControl control() {
        return this.aniControl;
    }

    public AlgorithmUI algorithmUI() {
        return this.algorithmUI;
    }

    public TriangulationCanvas canvas() {
        return this.triCanvas;
    }

    public void setAlgorithmState(int stateVar, boolean value) {
        this.state[stateVar] = value;
    }

    public void pause() {
        if (this.aniControl.mode() == 0) {
            try {
                this.wait(this.aniControl.getPause());
            }
            catch (InterruptedException e) {}
        } else {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void animate(int state) {
        if ((this.aniControl.animate(1) || this.aniControl.animate(3)) && state == 0) {
            this.triCanvas.needToClear = true;
        }
        this.setAlgorithmState(state, true);
        this.triCanvas.repaint();
        this.pause();
        this.setAlgorithmState(state, false);
    }

    public void reset() {
        for (int s = 0; s < 5; ++s) {
            this.state[s] = false;
        }
        this.triCanvas.needToClear = true;
    }

    public synchronized void nextStep() {
        this.notify();
    }

    public abstract void triangulate(Triangulation var1);

    public abstract void draw(RealWindowGraphics var1, Triangulation var2);
}

