/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.das2.math.Circle;
import org.das2.math.RealPoint;
import org.das2.math.RealWindow;

class RealWindowGraphics {
    RealWindow w = null;
    Dimension v = null;
    Graphics g = null;
    float scale = 1.0f;
    static final float realPointRadius = 0.04f;
    static final int pixelPointRadius = 4;
    static final int halfPixelPointRadius = 2;

    RealWindowGraphics(RealWindow w) {
        this.w = new RealWindow(w);
    }

    RealWindowGraphics(RealWindow w, Dimension d, Graphics g) {
        this.w = new RealWindow(w);
        this.v = new Dimension(d.width, d.height);
        this.g = g;
        this.calculateScale();
    }

    public void setWindow(RealWindow w) {
        this.w = new RealWindow(w);
        this.calculateScale();
    }

    public void setViewport(Dimension d) {
        this.v = new Dimension(d.width, d.height);
        this.calculateScale();
    }

    public void setGraphics(Graphics g) {
        this.g = g;
    }

    public Graphics getGraphics(Graphics g) {
        return g;
    }

    public void calculateScale() {
        float sy;
        float sx = (float)this.v.width / this.w.width();
        this.scale = sx < (sy = (float)this.v.height / this.w.height()) ? sx : sy;
    }

    public void drawTriangle(RealPoint p1, RealPoint p2, RealPoint p3, Color c) {
        this.drawLine(p1, p2, c);
        this.drawLine(p2, p3, c);
        this.drawLine(p3, p1, c);
    }

    public void drawLine(RealPoint p1, RealPoint p2, Color c) {
        this.g.setColor(c);
        int x1 = (int)(p1.x() * this.scale);
        int y1 = (int)(p1.y() * this.scale);
        int x2 = (int)(p2.x() * this.scale);
        int y2 = (int)(p2.y() * this.scale);
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void drawPoint(RealPoint p, Color c) {
        this.g.setColor(c);
        this.g.fillOval((int)(this.scale * p.x()) - 2, (int)(this.scale * p.y()) - 2, 4, 4);
    }

    public void drawCircle(Circle circle, Color c) {
        this.drawCircle(circle.center().x(), circle.center().y(), circle.radius(), c);
    }

    public void drawCircle(RealPoint p, float r, Color c) {
        this.drawCircle(p.x(), p.y(), r, c);
    }

    public void drawCircle(float x, float y, float r, Color c) {
        this.g.setColor(c);
        this.g.drawOval((int)(this.scale * (x - r)), (int)(this.scale * (y - r)), (int)(2.0f * r * this.scale), (int)(2.0f * r * this.scale));
    }

    public void fillCircle(float x, float y, float r, Color c) {
        this.g.setColor(c);
        this.g.fillOval((int)(this.scale * (x - r)), (int)(this.scale * (y - r)), (int)(2.0f * r * this.scale), (int)(2.0f * r * this.scale));
    }
}

