/*
 * Decompiled with CFR 0.152.
 */
package org.das2.math;

import java.awt.Dimension;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class Contour {
    public static final String PLANE_X = "x";
    public static final String PLANE_Y = "y";

    public static VectorDataSet contour(TableDataSet tds, DatumVector levels) {
        if (tds.tableCount() > 1) {
            throw new IllegalArgumentException("TableDataSet can only have one table");
        }
        ContourPlot cp = new ContourPlot(tds, levels);
        return cp.performContour();
    }

    public static VectorDataSet contour(TableDataSet tds, Datum level) {
        if (tds.tableCount() > 1) {
            throw new IllegalArgumentException("TableDataSet can only have one table");
        }
        Units units = level.getUnits();
        double value = level.doubleValue(units);
        ContourPlot cp = new ContourPlot(tds, DatumVector.newDatumVector(new double[]{value}, units));
        return cp.performContour();
    }

    public static final class ContourPlot {
        TableDataSet zz;
        Units zunits;
        long idx;
        static final boolean SHOW_NUMBERS = true;
        static final int BLANK = 32;
        static final int PLOT_MARGIN = 20;
        static final int WEE_BIT = 3;
        static final int NUMBER_LENGTH = 3;
        int xSteps;
        int ySteps;
        boolean logInterpolation = false;
        Dimension d;
        double deltaX;
        double deltaY;
        int ncv;
        int[] l1 = new int[4];
        int[] l2 = new int[4];
        int[] ij = new int[2];
        int[] i1 = new int[2];
        int[] i2 = new int[2];
        int[] i3 = new int[6];
        int ibkey;
        int icur;
        int jcur;
        int ii;
        int jj;
        int elle;
        int ix;
        int iedge;
        int iflag;
        int ni;
        int ks;
        int cntrIndex;
        int prevIndex;
        int idir;
        int nxidir;
        int k;
        double z1;
        double z2;
        double cval;
        double zMax;
        double zMin;
        double[] intersect = new double[4];
        double[] xy = new double[2];
        double[] prevXY = new double[2];
        float[] cv;
        boolean jump;

        public ContourPlot(TableDataSet tds, DatumVector contourValues) {
            this.zz = tds;
            this.xSteps = tds.getXLength();
            this.ySteps = tds.getYLength(0);
            this.zunits = tds.getZUnits();
            this.ncv = contourValues.getLength();
            this.cv = new float[this.ncv];
            for (int i = 0; i < this.ncv; ++i) {
                this.cv[i] = (float)contourValues.get(i).doubleValue(this.zunits);
            }
        }

        public VectorDataSet performContour() {
            VectorDataSetBuilder builder = new VectorDataSetBuilder(Units.dimensionless, this.zz.getZUnits());
            builder.setProperty("xTagWidth", Units.dimensionless.createDatum(1));
            builder.addPlane(Contour.PLANE_X, this.zz.getXUnits());
            builder.addPlane(Contour.PLANE_Y, this.zz.getYUnits());
            int workLength = 2 * this.xSteps * this.ySteps * this.ncv;
            boolean[] workSpace = new boolean[workLength];
            this.idx = 0L;
            this.ContourPlotKernel(builder, workSpace);
            return builder.toVectorDataSet();
        }

        final int sign(int a, int b) {
            a = Math.abs(a);
            if (b < 0) {
                return -a;
            }
            return a;
        }

        final double getYValue(double findex) {
            int indx = (int)(findex -= 1.0);
            if (indx == this.zz.getYLength(0)) {
                --indx;
            }
            double fp = findex - (double)indx;
            double y0 = this.zz.getYTagDouble(0, indx, this.zz.getYUnits());
            if (fp > 0.0) {
                double y1 = this.zz.getYTagDouble(0, indx + 1, this.zz.getYUnits());
                return y0 + fp * (y1 - y0);
            }
            return y0;
        }

        final double getXValue(double findex) {
            int indx = (int)(findex -= 1.0);
            if (indx == this.zz.getXLength()) {
                --indx;
            }
            double fp = findex - (double)indx;
            double x0 = this.zz.getXTagDouble(indx, this.zz.getXUnits());
            if (fp > 0.0) {
                double x1 = this.zz.getXTagDouble(indx + 1, this.zz.getXUnits());
                return x0 + fp * (x1 - x0);
            }
            return x0;
        }

        void DrawKernel(VectorDataSetBuilder dsbuilder) {
            if (this.iflag != 1 && this.iflag != 4 && this.iflag != 5) {
                ++this.idx;
            }
            dsbuilder.insertY(this.idx, this.cval);
            dsbuilder.insertY(this.idx, this.getXValue(this.xy[0]), Contour.PLANE_X);
            dsbuilder.insertY(this.idx, this.getYValue(this.xy[1]), Contour.PLANE_Y);
            ++this.idx;
        }

        final void DetectBoundary() {
            this.ix = 1;
            if (this.ij[1 - this.elle] != 1) {
                this.ii = this.ij[0] - this.i1[1 - this.elle];
                this.jj = this.ij[1] - this.i1[this.elle];
                if (!this.zunits.isFill(this.zz.getDouble(this.ii - 1, this.jj - 1, this.zunits))) {
                    this.ii = this.ij[0] + this.i2[this.elle];
                    this.jj = this.ij[1] + this.i2[1 - this.elle];
                    if (!this.zunits.isFill(this.zz.getDouble(this.ii - 1, this.jj - 1, this.zunits))) {
                        this.ix = 0;
                    }
                }
                if (this.ij[1 - this.elle] >= this.l1[1 - this.elle]) {
                    this.ix += 2;
                    return;
                }
            }
            this.ii = this.ij[0] + this.i1[1 - this.elle];
            this.jj = this.ij[1] + this.i1[this.elle];
            if (this.zunits.isFill(this.zz.getDouble(this.ii - 1, this.jj - 1, this.zunits))) {
                this.ix += 2;
                return;
            }
            if (this.zunits.isFill(this.zz.getDouble(this.ij[0], this.ij[1], this.zunits))) {
                this.ix += 2;
            }
        }

        boolean Routine_label_020() {
            this.l2[0] = this.ij[0];
            this.l2[1] = this.ij[1];
            this.l2[2] = -this.ij[0];
            this.l2[3] = -this.ij[1];
            this.idir = 0;
            this.nxidir = 1;
            this.k = 1;
            this.ij[0] = Math.abs(this.ij[0]);
            this.ij[1] = Math.abs(this.ij[1]);
            if (this.zunits.isFill(this.zz.getDouble(this.ij[0] - 1, this.ij[1] - 1, this.zunits))) {
                this.elle = this.idir % 2;
                this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                return true;
            }
            this.elle = 0;
            return false;
        }

        boolean Routine_label_050() {
            block2: {
                while (true) {
                    if (this.ij[this.elle] >= this.l1[this.elle]) {
                        if (++this.elle <= 1) continue;
                        this.elle = this.idir % 2;
                        this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                        if (!this.Routine_label_150()) continue;
                        return true;
                    }
                    this.ii = this.ij[0] + this.i1[this.elle];
                    this.jj = this.ij[1] + this.i1[1 - this.elle];
                    if (!this.zunits.isFill(this.zz.getDouble(this.ii - 1, this.jj - 1, this.zunits))) break block2;
                    if (++this.elle <= 1) continue;
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    if (this.Routine_label_150()) break;
                }
                return true;
            }
            this.jump = false;
            return false;
        }

        boolean Routine_label_150() {
            while (true) {
                if (this.ij[this.elle] < this.l1[this.k - 1]) {
                    int n = this.elle;
                    this.ij[n] = this.ij[n] + 1;
                    if (this.ij[this.elle] > this.l2[this.k - 1]) {
                        this.l2[this.k - 1] = this.ij[this.elle];
                        this.idir = this.nxidir;
                        this.k = this.nxidir = this.idir + 1;
                        if (this.nxidir > 3) {
                            this.nxidir = 0;
                        }
                    }
                    this.ij[0] = Math.abs(this.ij[0]);
                    this.ij[1] = Math.abs(this.ij[1]);
                    if (this.zunits.isFill(this.zz.getDouble(this.ij[0] - 1, this.ij[1] - 1, this.zunits))) {
                        this.elle = this.idir % 2;
                        this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                        continue;
                    }
                    this.elle = 0;
                    return false;
                }
                if (this.idir != this.nxidir) {
                    this.ij[this.elle] = this.l1[this.k - 1];
                    this.k = ++this.nxidir;
                    this.elle = 1 - this.elle;
                    this.ij[this.elle] = this.l2[this.k - 1];
                    if (this.nxidir <= 3) continue;
                    this.nxidir = 0;
                    continue;
                }
                if (this.ibkey != 0) {
                    return true;
                }
                this.ibkey = 1;
                this.ij[0] = this.icur;
                this.ij[1] = this.jcur;
                if (!this.Routine_label_020()) break;
            }
            return false;
        }

        short Routine_label_200(VectorDataSetBuilder dsbuilder, boolean[] workSpace) {
            while (true) {
                this.xy[this.elle] = 1.0 * (double)this.ij[this.elle] + this.intersect[this.iedge - 1];
                this.xy[1 - this.elle] = 1.0 * (double)this.ij[1 - this.elle];
                workSpace[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle] = true;
                this.DrawKernel(dsbuilder);
                if (this.iflag >= 4) {
                    this.icur = this.ij[0];
                    this.jcur = this.ij[1];
                    return 1;
                }
                this.ContinueContour();
                if (!workSpace[2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle]) {
                    return 2;
                }
                this.iflag = 5;
                this.iedge = this.ks + 2;
                if (this.iedge > 4) {
                    this.iedge -= 4;
                }
                this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
            }
        }

        boolean CrossedByContour(boolean[] workSpace) {
            this.ii = this.ij[0] + this.i1[this.elle];
            this.jj = this.ij[1] + this.i1[1 - this.elle];
            this.z1 = this.zz.getDouble(this.ij[0] - 1, this.ij[1] - 1, this.zunits);
            this.z2 = this.zz.getDouble(this.ii - 1, this.jj - 1, this.zunits);
            this.cntrIndex = 0;
            while (this.cntrIndex < this.ncv) {
                float x;
                int i = 2 * (this.xSteps * (this.ySteps * this.cntrIndex + this.ij[1] - 1) + this.ij[0] - 1) + this.elle;
                if (!workSpace[i] && (double)(x = this.cv[this.cntrIndex]) > Math.min(this.z1, this.z2) && (double)x <= Math.max(this.z1, this.z2)) {
                    workSpace[i] = true;
                    return true;
                }
                ++this.cntrIndex;
            }
            return false;
        }

        void ContinueContour() {
            this.ni = 1;
            if (this.iedge >= 3) {
                this.ij[0] = this.ij[0] - this.i3[this.iedge - 1];
                this.ij[1] = this.ij[1] - this.i3[this.iedge + 1];
            }
            for (int local_k = 1; local_k < 5; local_k = (int)((short)(local_k + 1))) {
                if (local_k == this.iedge) continue;
                this.ii = this.ij[0] + this.i3[local_k - 1];
                this.jj = this.ij[1] + this.i3[local_k];
                this.z1 = this.zz.getDouble(this.ii - 1, this.jj - 1, this.zunits);
                this.ii = this.ij[0] + this.i3[local_k];
                this.jj = this.ij[1] + this.i3[local_k + 1];
                this.z2 = this.zz.getDouble(this.ii - 1, this.jj - 1, this.zunits);
                if (!(this.cval > Math.min(this.z1, this.z2)) || !(this.cval <= Math.max(this.z1, this.z2))) continue;
                if (local_k == 1 || local_k == 4) {
                    double zz = this.z2;
                    this.z2 = this.z1;
                    this.z1 = zz;
                }
                this.intersect[local_k - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
                ++this.ni;
                this.ks = local_k;
            }
            if (this.ni != 2) {
                this.ks = 5 - this.iedge;
                if (this.intersect[2] >= this.intersect[0]) {
                    this.ks = 3 - this.iedge;
                    if (this.ks <= 0) {
                        this.ks += 4;
                    }
                }
            }
            this.elle = this.ks - 1;
            this.iflag = 1;
            this.jump = true;
            if (this.ks >= 3) {
                this.ij[0] = this.ij[0] + this.i3[this.ks - 1];
                this.ij[1] = this.ij[1] + this.i3[this.ks + 1];
                this.elle = this.ks - 3;
            }
        }

        void ContourPlotKernel(VectorDataSetBuilder dsbuilder, boolean[] workSpace) {
            this.l1[0] = this.xSteps;
            this.l1[1] = this.ySteps;
            this.l1[2] = -1;
            this.l1[3] = -1;
            this.i1[0] = 1;
            this.i1[1] = 0;
            this.i2[0] = 1;
            this.i2[1] = -1;
            this.i3[0] = 1;
            this.i3[1] = 0;
            this.i3[2] = 0;
            this.i3[3] = 1;
            this.i3[4] = 1;
            this.i3[5] = 0;
            this.prevXY[0] = 0.0;
            this.prevXY[1] = 0.0;
            this.xy[0] = 1.0;
            this.xy[1] = 1.0;
            this.cntrIndex = 0;
            this.prevIndex = -1;
            this.iflag = 6;
            this.DrawKernel(dsbuilder);
            this.icur = Math.max(1, Math.min((int)Math.floor(this.xy[0]), this.xSteps));
            this.jcur = Math.max(1, Math.min((int)Math.floor(this.xy[1]), this.ySteps));
            this.ibkey = 0;
            this.ij[0] = this.icur;
            this.ij[1] = this.jcur;
            if (this.Routine_label_020() && this.Routine_label_150()) {
                return;
            }
            if (this.Routine_label_050()) {
                return;
            }
            while (true) {
                short val_label_200;
                this.DetectBoundary();
                if (this.jump) {
                    if (this.ix != 0) {
                        this.iflag = 4;
                    }
                    this.iedge = this.ks + 2;
                    if (this.iedge > 4) {
                        this.iedge -= 4;
                    }
                    this.intersect[this.iedge - 1] = this.intersect[this.ks - 1];
                    val_label_200 = this.Routine_label_200(dsbuilder, workSpace);
                    if (val_label_200 == 1) {
                        if (this.Routine_label_020() && this.Routine_label_150()) {
                            return;
                        }
                        if (!this.Routine_label_050()) continue;
                        return;
                    }
                    if (val_label_200 == 2) continue;
                    return;
                }
                if (this.ix != 3 && this.ix + this.ibkey != 0 && this.CrossedByContour(workSpace)) {
                    this.iedge = this.elle + 1;
                    this.cval = this.cv[this.cntrIndex];
                    if (this.ix != 1) {
                        this.iedge += 2;
                    }
                    this.iflag = 2 + this.ibkey;
                    this.intersect[this.iedge - 1] = (this.cval - this.z1) / (this.z2 - this.z1);
                    val_label_200 = this.Routine_label_200(dsbuilder, workSpace);
                    if (val_label_200 == 1) {
                        if (this.Routine_label_020() && this.Routine_label_150()) {
                            return;
                        }
                        if (!this.Routine_label_050()) continue;
                        return;
                    }
                    if (val_label_200 == 2) continue;
                    return;
                }
                if (++this.elle > 1) {
                    this.elle = this.idir % 2;
                    this.ij[this.elle] = this.sign(this.ij[this.elle], this.l1[this.k - 1]);
                    if (this.Routine_label_150()) {
                        return;
                    }
                }
                if (this.Routine_label_050()) break;
            }
        }
    }
}

