/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.datum.Datum;
import org.das2.graph.DasAxis;
import org.das2.graph.Renderer;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ZDeformRenderer
extends Renderer {
    int dx = 20;
    int dy = 0;

    public ZDeformRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    protected void installRenderer() {
    }

    public void render(Graphics g1, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g = (Graphics2D)g1;
        TableDataSet tds = (TableDataSet)this.getDataSet();
        double zmax = TableUtil.tableMax(tds, tds.getZUnits());
        for (int itable = 0; itable < tds.tableCount(); ++itable) {
            int ny = tds.getYLength(itable);
            int nx = tds.tableEnd(itable) - tds.tableStart(itable);
            int[] iys = new int[tds.getYLength(itable)];
            for (int j = 0; j < tds.getYLength(itable); ++j) {
                iys[j] = (int)yAxis.transform(tds.getYTagDatum(itable, j));
            }
            for (int i = tds.tableStart(itable); i < tds.tableEnd(itable); ++i) {
                Datum x = tds.getXTagDatum(i);
                int ix = (int)xAxis.transform(x);
                if (ix <= -1000 || ix >= 1000) continue;
                double z0 = tds.getDouble(i, 0, tds.getZUnits());
                Line2D.Double line = new Line2D.Double();
                for (int j = 1; j < iys.length; ++j) {
                    double z1 = tds.getDouble(i, j, tds.getZUnits());
                    if (z1 > -1.0E30 && z0 > -1.0E30) {
                        line.setLine((double)ix + z0 / zmax * (double)this.dx, (double)iys[j - 1] + z0 / zmax * (double)this.dy, (double)ix + z1 / zmax * (double)this.dx, (double)iys[j] + z0 / zmax * (double)this.dy);
                        g.draw(line);
                    }
                    z0 = z1;
                }
            }
        }
    }

    protected void uninstallRenderer() {
    }

    protected Element getDOMElement(Document document) {
        return null;
    }
}

