/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.das2.CancelledOperationException;
import org.das2.dataset.CacheTag;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DataLoader;
import org.das2.graph.Renderer;
import org.das2.stream.StreamException;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;

public class XAxisDataLoader
extends DataLoader
implements DataSetUpdateListener {
    DasAxis xaxis;
    DataSetDescriptor dsd;
    ProgressMonitor progressMonitor;
    Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG, "XAxisDataLoader");
    DataLoader.Request currentRequest;
    List unsolicitedRequests;
    Object lockObject = new Object();
    private boolean fullResolution = false;

    public XAxisDataLoader(Renderer r, DataSetDescriptor dsd) {
        super(r);
        this.dsd = dsd;
        this.logger = this.logger;
        if (dsd != null) {
            dsd.addDataSetUpdateListener(this);
        }
        this.unsolicitedRequests = new ArrayList();
    }

    public void update() {
        if (this.isActive()) {
            this.logger.finer("enter XAxisDataLoader.update");
            DasPlot p = this.getRenderer().getParent();
            if (p == null) {
                this.logger.fine("plot is null, no need to load");
            } else {
                DasAxis xAxis = p.getXAxis();
                DasAxis yAxis = p.getYAxis();
                if (!xAxis.valueIsAdjusting() && !yAxis.valueIsAdjusting()) {
                    this.loadDataSet(xAxis, yAxis);
                }
            }
        } else {
            this.logger.finer("enter XAxisDataLoader.update, ignored not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSet(DasAxis xAxis, DasAxis yAxis) {
        this.logger.fine("render requests dataset for x:" + xAxis.getMemento() + " y:" + yAxis.getMemento());
        if (this.xaxis == null) {
            this.xaxis = xAxis;
        }
        if (this.xaxis.getColumn() == DasColumn.NULL) {
            this.logger.fine("column not set yet");
            return;
        }
        if (this.dsd == null) {
            this.logger.fine("dsd is null, nothing to do");
            return;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.currentRequest != null) {
                DataLoader.Request request = this.currentRequest;
                synchronized (request) {
                    if (xAxis.getMemento().equals(this.currentRequest.xmem)) {
                        this.logger.fine("ignore repeat request");
                        return;
                    }
                    this.logger.fine("cancel old request: " + this.currentRequest);
                    ProgressMonitor monitor = this.currentRequest.monitor;
                    this.currentRequest = null;
                    monitor.cancel();
                }
            }
            Datum dataRange1 = xAxis.getDataMaximum().subtract(xAxis.getDataMinimum());
            double deviceRange = Math.floor((double)xAxis.getColumn().getDMaximum() + 0.5) - Math.floor((double)xAxis.getColumn().getDMinimum() + 0.5);
            Datum resolution = this.isFullResolution() ? null : dataRange1.divide(deviceRange);
            if (deviceRange == 0.0) {
                return;
            }
            DasPlot parent = this.renderer.getParent();
            DatumRange loadRange = xAxis.getDatumRange();
            CacheTag cacheTag = new CacheTag(loadRange, resolution);
            if (this.dsd.getDataSetCache().haveStored(this.dsd, cacheTag)) {
                this.renderer.setDataSet(this.dsd.getDataSetCache().retrieve(this.dsd, cacheTag));
                this.currentRequest = null;
            } else {
                this.progressMonitor = this.getMonitor("dsd.requestDataSet " + this.dsd + ":" + loadRange + " @ " + (resolution == null ? "intrinsic" : "" + DatumUtil.asOrderOneUnits(resolution)));
                parent.repaint(0, 0, parent.getWidth(), parent.getHeight());
                this.logger.fine("request data from dsd: " + loadRange + " @ " + resolution);
                this.currentRequest = new DataLoader.Request(this.progressMonitor, xAxis.getMemento(), yAxis.getMemento());
                this.dsd.requestDataSet(loadRange.min(), loadRange.max(), resolution, this.progressMonitor, parent.getCanvas());
            }
        }
    }

    private boolean rendererHandlesException(Exception e) {
        boolean result;
        boolean bl = result = e instanceof InterruptedIOException || e instanceof NoDataInIntervalException || e instanceof StreamException || e instanceof CancelledOperationException;
        if (!result) {
            result = e.getCause() instanceof InterruptedIOException;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSetUpdated(DataSetUpdateEvent e) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.renderer.getDataLoader() != this) {
                return;
            }
            this.logger.fine("got dataset update:" + e);
            if (e.getException() != null && e.getDataSet() != null) {
                throw new IllegalStateException("both exception and data set");
            }
            if (e.getException() != null) {
                this.logger.fine("got dataset update exception: " + e.getException());
                Exception exception = e.getException();
                if (!this.rendererHandlesException(exception)) {
                    DasExceptionHandler.handle(exception);
                }
                ProgressMonitor mon = e.getMonitor();
                if (this.currentRequest != null) {
                    if (mon == null || mon == this.currentRequest.monitor) {
                        this.renderer.setException(exception);
                        this.renderer.setDataSet(null);
                        this.logger.fine("current request completed w/exception: " + this.currentRequest);
                        this.currentRequest = null;
                    } else {
                        this.logger.fine("got exception but not for currentRequest ");
                    }
                } else {
                    this.logger.fine("got exception but currentRequest ");
                }
                if (!this.rendererHandlesException(exception)) {
                    DasExceptionHandler.handle(exception);
                }
            } else {
                if (e.getDataSet() == null) {
                    this.logger.fine("got dataset update notification (no dataset).");
                    this.loadDataSet(this.renderer.getParent().getXAxis(), this.renderer.getParent().getYAxis());
                    return;
                }
                if (this.currentRequest == null) {
                    this.logger.fine("ignore update w/dataset, currentRequest=null");
                } else {
                    DataSet ds = e.getDataSet();
                    ProgressMonitor mon = e.getMonitor();
                    if (mon == null || this.currentRequest.monitor == mon) {
                        this.logger.fine("got dataset update w/dataset: " + ds);
                        if (ds != null) {
                            if (ds.getXLength() > 0) {
                                this.logger.fine("  ds range: " + DataSetUtil.xRange(ds));
                            } else {
                                this.logger.fine("  ds range: (empty)");
                            }
                        }
                        this.renderer.setDataSet(ds);
                        this.logger.fine("current request completed w/dataset: " + this.currentRequest.xmem);
                        this.currentRequest = null;
                    } else {
                        this.logger.fine("got dataset update w/dataset but not my monitor: " + ds);
                    }
                }
            }
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        this.logger.fine("set dsd: " + dsd);
        if (this.dsd != null) {
            this.dsd.removeDataSetUpdateListener(this);
        }
        this.dsd = dsd;
        if (dsd != null) {
            dsd.addDataSetUpdateListener(this);
        }
        this.update();
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dsd;
    }

    public void setReloadDataSet(boolean reloadDataSet) {
        super.setReloadDataSet(reloadDataSet);
        this.dsd.reset();
    }

    public boolean isFullResolution() {
        return this.fullResolution;
    }

    public void setFullResolution(boolean b) {
        if (this.fullResolution == b) {
            return;
        }
        this.fullResolution = b;
    }

    public DataLoader.Request getCurrentRequest() {
        return this.currentRequest;
    }

    public DataLoader.Request[] getUnsolicitedRequests() {
        return this.unsolicitedRequests.toArray(new DataLoader.Request[this.unsolicitedRequests.size()]);
    }

    public DataLoader.Request getUnsolicitedRequests(int i) {
        return (DataLoader.Request)this.unsolicitedRequests.get(i);
    }
}

