/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Displayable;
import org.das2.dasml.FormBase;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SymColor;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolLineRenderer
extends Renderer
implements Displayable {
    private Psym psym = Psym.NONE;
    private double symSize = 3.0;
    private float lineWidth = 1.0f;
    private boolean histogram = false;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    int renderCount = 0;
    int updateImageCount = 0;
    private Color color = Color.BLACK;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));
    private GeneralPath path;
    private Logger log = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    boolean updating = false;

    public SymbolLineRenderer() {
    }

    public SymbolLineRenderer(DataSet ds) {
        super(ds);
    }

    public SymbolLineRenderer(DataSetDescriptor dsd) {
        super(dsd);
    }

    private void reportCount() {
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        double tmp;
        double ymin;
        double ymax;
        double xmin;
        double xmax;
        ++this.renderCount;
        long timer0 = System.currentTimeMillis();
        VectorDataSet dataSet = (VectorDataSet)this.getDataSet();
        if (this.ds == null && this.getLastException() != null) {
            this.renderException(g, xAxis, yAxis, this.getLastException());
            return;
        }
        if (dataSet == null || dataSet.getXLength() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            this.parent.postMessage(this, "null data set", 0, null, null);
            return;
        }
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("render data set " + dataSet);
        g.setColor(this.color);
        Graphics2D graphics = (Graphics2D)g.create();
        RenderingHints hints0 = graphics.getRenderingHints();
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.log.finest("drawing psym in " + this.color);
        if (this.path != null) {
            this.psymConnector.draw(graphics, this.path, this.lineWidth);
        }
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        Rectangle r = g.getClipBounds();
        if (r == null) {
            xmax = xAxis.getDataMaximum().doubleValue(xUnits);
            xmin = xAxis.getDataMinimum().doubleValue(xUnits);
            ymax = yAxis.getDataMaximum().doubleValue(yUnits);
            ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        } else {
            xmin = xAxis.invTransform((int)r.getX()).doubleValue(xUnits);
            xmax = xAxis.invTransform((int)(r.getX() + r.getWidth())).doubleValue(xUnits);
            ymin = yAxis.invTransform((int)r.getY()).doubleValue(yUnits);
            ymax = yAxis.invTransform((int)(r.getY() + r.getHeight())).doubleValue(yUnits);
        }
        if (xmax < xmin) {
            tmp = xmax;
            xmax = xmin;
            xmin = tmp;
        }
        if (ymax < ymin) {
            tmp = ymax;
            ymax = ymin;
            ymin = tmp;
        }
        if (this.psym != Psym.NONE) {
            int ixmax;
            int ixmin = VectorUtil.closestXTag(dataSet, xmin, xUnits);
            if (ixmin > 0) {
                --ixmin;
            }
            if ((ixmax = VectorUtil.closestXTag(dataSet, xmax, xUnits)) < dataSet.getXLength() - 1) {
                ++ixmax;
            }
            for (int index = ixmin; index <= ixmax; ++index) {
                if (dataSet.getDatum(index).isFill()) continue;
                double i = xAxis.transform(dataSet.getXTagDouble(index, xUnits), xUnits);
                double j = yAxis.transform(dataSet.getDouble(index, yUnits), yUnits);
                if (Double.isNaN(j)) continue;
                ((Graphics2D)g).setStroke(new BasicStroke(this.lineWidth));
                this.psym.draw(g, i, j, (float)this.symSize);
            }
        }
        long milli = System.currentTimeMillis();
        logger.finer("render: " + (milli - timer0) + " total:" + (milli - this.lastUpdateMillis) + " fps:" + 1000.0 / (double)(milli - this.lastUpdateMillis));
        this.lastUpdateMillis = milli;
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) {
        this.updating = true;
        try {
            super.updatePlotImage(xAxis, yAxis, monitor);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("entering updatePlotImage");
        boolean histogram = this.histogram;
        VectorDataSet dataSet = (VectorDataSet)this.getDataSet();
        if (dataSet == null || dataSet.getXLength() == 0) {
            return;
        }
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        DatumRange visibleRange = xAxis.getDatumRange();
        double xmax = visibleRange.min().doubleValue(xUnits);
        double xmin = visibleRange.max().doubleValue(xUnits);
        double ymax = yAxis.getDataMaximum().doubleValue(yUnits);
        double ymin = yAxis.getDataMinimum().doubleValue(yUnits);
        if (this.psymConnector != PsymConnector.NONE) {
            double xSampleWidth;
            int ixmin = DataSetUtil.getPreviousColumn(dataSet, visibleRange.min());
            int ixmax = DataSetUtil.getNextColumn(dataSet, visibleRange.max());
            GeneralPath newPath = new GeneralPath(1, Math.max(100, 110 * (ixmax - ixmin) / 100));
            if (dataSet.getProperty("xTagWidth") != null) {
                Datum xSampleWidthDatum = (Datum)dataSet.getProperty("xTagWidth");
                xSampleWidth = xSampleWidthDatum.doubleValue(xUnits.getOffsetUnits());
            } else {
                String xSampleWidthString = (String)dataSet.getProperty("x_sample_width");
                if (xSampleWidthString != null) {
                    double xSampleWidthSeconds = Double.parseDouble(xSampleWidthString);
                    xSampleWidth = Units.seconds.convertDoubleTo(xUnits.getOffsetUnits(), xSampleWidthSeconds);
                } else {
                    xSampleWidth = 1.0E31;
                }
            }
            xSampleWidth *= 1.5;
            double x0 = Double.NaN;
            double y0 = Double.NaN;
            double i0 = Double.NaN;
            double j0 = Double.NaN;
            boolean skippedLast = true;
            for (int index = ixmin; index <= ixmax; ++index) {
                double x = dataSet.getXTagDouble(index, xUnits);
                double y = dataSet.getDouble(index, yUnits);
                double i = xAxis.transform(x, xUnits);
                double j = yAxis.transform(y, yUnits);
                if (yUnits.isFill(dataSet.getDouble(index, yUnits)) || Double.isNaN(y)) {
                    skippedLast = true;
                } else if (skippedLast) {
                    newPath.moveTo((float)i, (float)j);
                    skippedLast = false;
                } else if (Math.abs(x - x0) > xSampleWidth) {
                    newPath.lineTo((float)i0, (float)j0);
                    newPath.moveTo((float)i, (float)j);
                    skippedLast = false;
                } else {
                    if (histogram) {
                        double i1 = (i0 + i) / 2.0;
                        newPath.lineTo((float)i1, (float)j0);
                        newPath.lineTo((float)i1, (float)j);
                        newPath.lineTo((float)i, (float)j);
                    } else {
                        newPath.lineTo((float)i, (float)j);
                    }
                    skippedLast = false;
                }
                x0 = x;
                y0 = y;
                i0 = i;
                j0 = j;
            }
            this.path = newPath;
        } else {
            this.path = null;
        }
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("done updatePlotImage");
        this.updating = false;
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        this.psymConnector = p;
        this.refreshImage();
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym oldValue = this.psym;
        this.psym = psym;
        this.refreshImage();
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double symSize) {
        this.symSize = symSize;
        this.setPsym(this.psym);
        this.refreshImage();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.refreshImage();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
        this.refreshImage();
    }

    protected void installRenderer() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            DasMouseInputAdapter mouseAdapter = this.parent.mouseAdapter;
            DasPlot p = this.parent;
            mouseAdapter.addMouseModule(new MouseModule(p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
        }
    }

    protected void uninstallRenderer() {
    }

    public static SymbolLineRenderer processLinePlotElement(Element element, DasPlot parent, FormBase form) {
        String dataSetID = element.getAttribute("dataSetID");
        Psym psym = Psym.parsePsym(element.getAttribute("psym"));
        SymColor color = SymColor.parseSymColor(element.getAttribute("color"));
        SymbolLineRenderer renderer = new SymbolLineRenderer((DataSet)null);
        parent.addRenderer(renderer);
        float lineWidth = Float.parseFloat(element.getAttribute("lineWidth"));
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle(de);
        }
        renderer.setPsym(psym);
        renderer.setColor(color);
        renderer.setLineWidth(lineWidth);
        return renderer;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("lineplot");
        element.setAttribute("dataSetID", this.getDataSetID());
        element.setAttribute("psym", this.getPsym().toString());
        element.setAttribute("color", this.getColor().toString());
        return element;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        this.antiAliased = antiAliased;
        this.refreshImage();
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean b) {
        if (b != this.histogram) {
            this.histogram = b;
            this.refreshImage();
        }
    }

    public String getListLabel() {
        return String.valueOf(this.getDataSetDescriptor());
    }

    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(15, 10, 2);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        g.setRenderingHints(DasProperties.getRenderingHints());
        if (this.color.equals(Color.white)) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(new Color(0, 0, 0, 0));
        }
        g.fillRect(0, 0, 15, 10);
        g.setColor(this.color);
        Stroke stroke0 = g.getStroke();
        this.getPsymConnector().drawLine(g, 2.0, 3.0, 13.0, 7.0, 1.5f);
        g.setStroke(stroke0);
        this.psym.draw(g, 7.0, 5.0, 3.0f);
        return new ImageIcon(i);
    }

    public boolean acceptContext(int x, int y) {
        return this.path != null && this.path.intersects(x - 5, y - 5, 10.0, 10.0);
    }
}

