/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.Icon;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.components.HorizontalSpectrogramSlicer;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dasml.FormBase;
import org.das2.dataset.AveragePeakTableRebinner;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.NearestNeighborTableRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.LocationUnits;
import org.das2.datum.Units;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.HorizontalSlicerMouseModule;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasLabelAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.RowRowConnector;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StackedHistogramRenderer
extends Renderer
implements TableDataSetConsumer,
PropertyChangeListener,
Displayable {
    private DasLabelAxis yAxis = null;
    private DasAxis zAxis = null;
    private RowRowConnector zAxisConnector = null;
    private DasRow littleRow = null;
    private RebinDescriptor xBins = null;
    private PeaksIndicator peaksIndicator;
    private boolean sliceRebinnedData;
    Image plotImage;
    DatumRange imageXRange;
    DatumRange imageYRange;
    RebinListener rebinListener = new RebinListener();
    protected boolean transparentBackground = false;
    public static final String PROP_TRANSPARENTBACKGROUND = "transparentBackground";

    public StackedHistogramRenderer(DasPlot parent, DataSetDescriptor dsd, DasAxis zAxis, DasLabelAxis yAxis) {
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        zAxis.addPropertyChangeListener(this.rebinListener);
        this.setDataSetDescriptor(dsd);
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getDataSet() == null && this.getLastException() != null) {
            this.renderException(g2, xAxis, yAxis, this.getLastException());
        } else if (this.plotImage != null) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            Point2D.Float p = new Point2D.Float(xAxis.getColumn().getDMinimum(), yAxis.getRow().getDMinimum());
            g2.drawImage(this.plotImage, (int)(((Point2D)p).getX() + 0.5), (int)(((Point2D)p).getY() + 0.5), this.getParent());
        }
        g2.dispose();
    }

    protected void installRenderer() {
        DasCanvas canvas = this.parent.getCanvas();
        this.littleRow = new DasRow(canvas, 0.5, 0.6);
        this.zAxisConnector = new RowRowConnector(canvas, this.littleRow, this.zAxis.getRow(), this.parent.getColumn(), this.zAxis.getColumn());
        this.zAxisConnector.setVisible(false);
        canvas.add(this.zAxisConnector);
        this.yAxis.setFloppyItemSpacing(true);
        this.yAxis.setOutsidePadding(1);
        this.peaksIndicator = PeaksIndicator.MaxLines;
        DasMouseInputAdapter mouseAdapter = this.parent.getDasMouseInputAdapter();
        VerticalSpectrogramSlicer vSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
        VerticalSlicerMouseModule vsl = VerticalSlicerMouseModule.create(this);
        vsl.addDataPointSelectionListener(vSlicer);
        mouseAdapter.addMouseModule(vsl);
        HorizontalSpectrogramSlicer hSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
        HorizontalSlicerMouseModule hsl = HorizontalSlicerMouseModule.create(this);
        hsl.addDataPointSelectionListener(hSlicer);
        mouseAdapter.addMouseModule(hsl);
        CrossHairMouseModule ch = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
        mouseAdapter.addMouseModule(ch);
        DasPlot p = this.parent;
        mouseAdapter.addMouseModule(new MouseModule(p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
    }

    protected void uninstallRenderer() {
    }

    public void setZAxis(DasAxis zAxis) {
        this.zAxis = zAxis;
        throw new IllegalStateException("not supported");
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void setYAxis(DasAxis yAxis) {
        if (!(yAxis instanceof DasLabelAxis)) {
            throw new IllegalArgumentException("You can't call setYAxis for stackedHistogramPlot");
        }
        this.yAxis = (DasLabelAxis)yAxis;
        yAxis.addPropertyChangeListener(this);
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis_1, ProgressMonitor monitor) throws DasException {
        super.updatePlotImage(xAxis, yAxis_1, monitor);
        Color BAR_COLOR = this.getParent().getForeground();
        Color GREY_PEAKS_COLOR = Color.GRAY;
        DasPlot parent = this.getParent();
        Cursor cursor0 = parent.getCursor();
        parent.setCursor(new Cursor(3));
        DasColumn column = xAxis.getColumn();
        DasRow row = this.yAxis.getRow();
        int w = column.getWidth();
        int h = row.getHeight();
        if (w == 0) {
            return;
        }
        BufferedImage plotImage = new BufferedImage(w, h, 2);
        Graphics2D g = plotImage.createGraphics();
        if (!this.isTransparentBackground()) {
            g.setColor(this.getParent().getBackground());
            g.fillRect(0, 0, plotImage.getWidth(), plotImage.getHeight());
        }
        g.translate(-column.getDMinimum(), -row.getDMinimum());
        double iMin = column.getDMinimum();
        double jMin = row.getDMinimum();
        RebinDescriptor xbins = new RebinDescriptor(xAxis.getDataMinimum(), xAxis.getDataMaximum(), Math.abs(column.getWidth()) / 1 + 1, xAxis.isLog());
        this.imageXRange = xAxis.getDatumRange();
        this.imageYRange = this.yAxis.getDatumRange();
        int xDMax = column.getDMaximum();
        int xDMin = column.getDMinimum();
        TableDataSet xtysData = (TableDataSet)this.getDataSet();
        if (xtysData == null) {
            this.plotImage = null;
            if (this.getLastException() == null) {
                this.setLastException(new DasException("null data set"));
            }
            return;
        }
        if (xtysData.tableCount() == 0) {
            this.setLastException(new DasException("empty data set"));
            this.ds = null;
            return;
        }
        Rebinner rebinner = new Rebinner();
        TableDataSet data = (TableDataSet)rebinner.rebin(xtysData, xbins, null);
        TableDataSet peaks = (TableDataSet)data.getPlanarView("peaks");
        TableDataSet weights = (TableDataSet)data.getPlanarView("weights");
        DasLabelAxis yAxis = (DasLabelAxis)yAxis_1;
        int zmid = this.zAxis.getRow().getDMiddle();
        boolean haveLittleRow = false;
        for (int j = 0; j < data.getYLength(0); ++j) {
            int yBase;
            if (j == data.getYLength(0) - 1) {
                yBase = yAxis.getItemMin(data.getYTagDatum(0, j));
                g.setColor(GREY_PEAKS_COLOR);
                g.drawLine(xDMin, yBase, xDMax, yBase);
                g.setColor(BAR_COLOR);
            }
            yBase = yAxis.getItemMax(data.getYTagDatum(0, j));
            g.setColor(Color.lightGray);
            g.drawLine(xDMin, yBase, xDMax, yBase);
            g.setColor(BAR_COLOR);
            int yBase1 = yAxis.getItemMin(data.getYTagDatum(0, j));
            double canvasHeight = ((Component)parent).getHeight();
            if (!haveLittleRow && yBase1 <= zmid) {
                this.littleRow.setDPosition(yBase1, yBase);
                haveLittleRow = true;
                this.zAxisConnector.setVisible(true);
                this.zAxisConnector.repaint();
            }
            double[] binStarts = xbins.binStarts();
            double[] binStops = xbins.binStops();
            int y0 = yBase;
            int littleRowHeight = yBase - yBase1;
            double zAxisMax = this.zAxis.getDataMaximum().doubleValue(xtysData.getZUnits());
            double zAxisMin = this.zAxis.getDataMinimum().doubleValue(xtysData.getZUnits());
            if (yBase1 < row.getDMinimum() || yBase > row.getDMaximum()) continue;
            for (int ibin = 0; ibin < data.getXLength(); ++ibin) {
                double peakValue;
                int yHeight;
                int x0 = (int)xAxis.transform(binStarts[ibin], xbins.getUnits());
                int x1 = x0 + 1;
                double zz = data.getDouble(ibin, j, data.getZUnits());
                if (data.getZUnits().isFill(zz) || Double.isNaN(zz)) continue;
                int yAvg = (int)this.zAxis.transform(zz, data.getZUnits(), yBase, yBase1);
                yAvg = yAvg > y0 - littleRowHeight ? yAvg : y0 - littleRowHeight;
                int n = yHeight = y0 - yAvg > 0 ? y0 - yAvg : 0;
                if (peaks != null && (peakValue = peaks.getDouble(ibin, j, peaks.getZUnits())) <= zAxisMax) {
                    int yMax = (int)this.zAxis.transform(peakValue, data.getZUnits(), yBase, yBase1);
                    int n2 = yMax = y0 - yMax > 0 ? yMax : y0;
                    if (this.peaksIndicator == PeaksIndicator.MaxLines) {
                        g.drawLine(x0, yMax, x0, yMax);
                    } else if (this.peaksIndicator == PeaksIndicator.GrayPeaks) {
                        g.setColor(Color.lightGray);
                        g.drawLine(x0, yMax, x0, y0);
                        g.setColor(BAR_COLOR);
                    } else if (this.peaksIndicator == PeaksIndicator.BlackPeaks) {
                        g.setColor(BAR_COLOR);
                        g.drawLine(x0, yMax, x0, y0);
                    }
                }
                if (!(zz >= zAxisMin)) continue;
                g.drawLine(x0, yAvg, x0, yAvg + yHeight);
            }
        }
        g.dispose();
        this.plotImage = plotImage;
        parent.setCursor(cursor0);
        this.getParent().repaint();
        if (this.sliceRebinnedData) {
            this.ds = data;
        }
    }

    public DasAxis getZAxis() {
        return this.zAxis;
    }

    public void setZTitle(String title) {
        this.getZAxis().setLabel(title);
    }

    public PeaksIndicator getPeaksIndicator() {
        return this.peaksIndicator;
    }

    public void setPeaksIndicator(PeaksIndicator peaksIndicator) {
        this.peaksIndicator = peaksIndicator;
        this.refreshImage();
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setTransparentBackground(boolean transparentBackground) {
        boolean oldTransparentBackground = this.transparentBackground;
        this.transparentBackground = transparentBackground;
        this.propertyChangeSupport.firePropertyChange(PROP_TRANSPARENTBACKGROUND, oldTransparentBackground, transparentBackground);
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("stackedHistogram");
        element.setAttribute("zAxis", this.zAxis.getDasName());
        element.setAttribute("dataSetID", this.getDataSetID());
        return element;
    }

    public static Renderer processStackedHistogramElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String dataSetID = element.getAttribute("dataSetID");
        StackedHistogramRenderer renderer = new StackedHistogramRenderer(parent, null, null, (DasLabelAxis)parent.getYAxis());
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle(de);
        }
        return renderer;
    }

    public String getListLabel() {
        return "stacked histogram";
    }

    public Icon getListIcon() {
        return null;
    }

    public class Rebinner
    implements DataSetRebinner {
        DataSetRebinner highResRebinner = new NearestNeighborTableRebinner();
        DataSetRebinner lowResRebinner = new AveragePeakTableRebinner();

        Rebinner() {
        }

        public DataSet rebin(DataSet ds, RebinDescriptor x, RebinDescriptor y) throws IllegalArgumentException, DasException {
            Units rdUnits;
            Datum xwidth = (Datum)ds.getProperty("xTagWidth");
            if (xwidth == null) {
                xwidth = DataSetUtil.guessXTagWidth((TableDataSet)ds);
            }
            if ((rdUnits = x.getUnits()) instanceof LocationUnits) {
                rdUnits = ((LocationUnits)rdUnits).getOffsetUnits();
            }
            try {
                DataSet result;
                if (x.binWidth() < xwidth.doubleValue(rdUnits)) {
                    Renderer.logger.fine("using rebinner " + this.highResRebinner);
                    result = this.highResRebinner.rebin(ds, x, y);
                } else {
                    Renderer.logger.fine("using rebinner " + this.lowResRebinner);
                    result = this.lowResRebinner.rebin(ds, x, y);
                }
                return result;
            }
            catch (Exception e) {
                DasExceptionHandler.handle(e);
                return null;
            }
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            StackedHistogramRenderer.this.update();
        }
    }

    public static class PeaksIndicator
    implements Enumeration,
    Displayable {
        String id;
        public static final PeaksIndicator NoPeaks = new PeaksIndicator("None");
        public static final PeaksIndicator GrayPeaks = new PeaksIndicator("Gray Peaks");
        public static final PeaksIndicator BlackPeaks = new PeaksIndicator("Black Peaks");
        public static final PeaksIndicator MaxLines = new PeaksIndicator("Lines");

        PeaksIndicator(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public String getListLabel() {
            return this.id;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

