/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.components.HorizontalSpectrogramSlicer;
import org.das2.components.VerticalSpectrogramAverager;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dasml.FormBase;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.HorizontalDragRangeSelectorMouseModule;
import org.das2.event.HorizontalSlicerMouseModule;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpectrogramRenderer
extends Renderer
implements TableDataSetConsumer,
Displayable {
    private Object lockObject = new Object();
    private DasColorBar colorBar;
    private Image plotImage;
    private Rectangle plotImageBounds;
    private byte[] raster;
    private int rasterWidth;
    private int rasterHeight;
    DatumRange imageXRange;
    DatumRange imageYRange;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    DasAxis.Memento cmemento;
    int updateImageCount = 0;
    int renderCount = 0;
    private TableDataSet rebinDataSet;
    RebinListener rebinListener = new RebinListener();
    private static Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private RebinnerEnum rebinnerEnum;
    int count = 0;
    private boolean sliceRebinnedData = true;
    private boolean print300dpi;

    public SpectrogramRenderer(DasColorBar colorBar) {
        this(null, colorBar);
    }

    public SpectrogramRenderer(DataSetDescriptor dsd, DasColorBar colorBar) {
        super(dsd);
        this.colorBar = colorBar;
        if (this.colorBar != null) {
            colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            colorBar.addPropertyChangeListener("log", this.rebinListener);
            colorBar.addPropertyChangeListener("type", this.rebinListener);
            colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
        }
        this.setRebinner(RebinnerEnum.binAverage);
    }

    public SpectrogramRenderer(DasPlot parent, DataSetDescriptor dsd, DasColorBar colorBar) {
        this(dsd, colorBar);
        this.parent = parent;
    }

    public DasAxis getZAxis() {
        return this.colorBar;
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar cb) {
        if (this.colorBar == cb) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            this.colorBar.removePropertyChangeListener("fillColor", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().remove(this.colorBar);
            }
        }
        this.colorBar = cb;
        if (this.colorBar != null) {
            this.colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("log", this.rebinListener);
            this.colorBar.addPropertyChangeListener("type", this.rebinListener);
            this.colorBar.addPropertyChangeListener("fillColor", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().add(this.colorBar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        logger.finer("entering SpectrogramRenderer.render");
        Graphics2D g2 = (Graphics2D)g;
        ++this.renderCount;
        this.reportCount();
        Object object = this.lockObject;
        synchronized (object) {
            if (this.plotImage == null) {
                if (this.getLastException() != null) {
                    if (this.getLastException() instanceof NoDataInIntervalException) {
                        this.parent.postMessage(this, "no data in interval:!c" + this.getLastException().getMessage(), 1, null, null);
                    } else {
                        this.parent.postException(this, this.getLastException());
                    }
                } else if (this.getDataSet() == null) {
                    this.parent.postMessage(this, "no data set", 0, null, null);
                } else if (this.getDataSet().getXLength() == 0) {
                    this.parent.postMessage(this, "empty data set", 0, null, null);
                }
            } else if (this.plotImage != null) {
                Point2D.Float p = new Point2D.Float(this.plotImageBounds.x, this.plotImageBounds.y);
                int x = (int)(((Point2D)p).getX() + 0.5);
                int y = (int)(((Point2D)p).getY() + 0.5);
                if (this.parent.getCanvas().isPrintingThread() && this.print300dpi) {
                    AffineTransform atinv;
                    AffineTransformOp atop = new AffineTransformOp(AffineTransform.getScaleInstance(4.0, 4.0), 1);
                    BufferedImage image300 = atop.filter((BufferedImage)this.plotImage, null);
                    try {
                        atinv = atop.getTransform().createInverse();
                    }
                    catch (NoninvertibleTransformException ex) {
                        throw new RuntimeException(ex);
                    }
                    atinv.translate(x * 4, y * 4);
                    g2.drawImage(image300, atinv, this.getParent());
                } else {
                    g2.drawImage(this.plotImage, x, y, this.getParent());
                }
            }
        }
    }

    private static byte[] transformSimpleTableDataSet(TableDataSet rebinData, DasColorBar cb, boolean flipY) {
        int nx;
        int ny;
        if (rebinData.tableCount() > 1) {
            throw new IllegalArgumentException("TableDataSet contains more than one table");
        }
        logger.fine("converting to pixel map");
        int itable = 0;
        int h = ny = rebinData.getYLength(itable);
        int w = nx = rebinData.tableEnd(itable) - rebinData.tableStart(itable);
        Units units = cb.getUnits();
        int ncolor = cb.getType().getColorCount();
        TableDataSet weights = (TableDataSet)rebinData.getPlanarView("weights");
        byte[] pix = new byte[nx * ny];
        Arrays.fill(pix, (byte)cb.getFillColorIndex());
        for (int i = rebinData.tableStart(itable); i < rebinData.tableEnd(itable); ++i) {
            for (int j = 0; j < ny; ++j) {
                if (weights != null && !(weights.getDouble(i, j, Units.dimensionless) > 0.0)) continue;
                int index = i - 0 + (ny - j - 1) * nx;
                int icolor = cb.indexColorTransform(rebinData.getDouble(i, j, units), units);
                pix[index] = (byte)icolor;
            }
        }
        return pix;
    }

    private void reportCount() {
        if (this.updateImageCount % 10 == 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
        SpectrogramRenderer.logger.finer("entering SpectrogramRenderer.updatePlotImage");
        ++this.updateImageCount;
        this.reportCount();
        try {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block30: {
                                    var5_4 = this.lockObject;
                                    // MONITORENTER : var5_4
                                    plotImageBounds2 = this.parent.getUpdateImageBounds();
                                    if (this.raster == null || this.xmemento == null || this.ymemento == null || !xAxis.getMemento().equals(this.xmemento) || !yAxis.getMemento().equals(this.ymemento) || !this.colorBar.getMemento().equals(this.cmemento) || plotImageBounds2.width != this.rasterWidth || plotImageBounds2.height != this.rasterHeight) break block30;
                                    SpectrogramRenderer.logger.fine("same xaxis, yaxis, reusing raster");
                                    ** GOTO lbl80
                                }
                                if (this.getParent() == null || plotImageBounds2 == null || plotImageBounds2.width <= 1 || plotImageBounds2.height <= 1) {
                                    SpectrogramRenderer.logger.finest("canvas not useable!!!");
                                    // MONITOREXIT : var5_4
                                    return;
                                }
                                if (this.ds != null) break block24;
                                SpectrogramRenderer.logger.fine("got null dataset, setting image to null");
                                this.plotImage = null;
                                this.plotImageBounds = null;
                                this.rebinDataSet = null;
                                this.imageXRange = null;
                                this.imageYRange = null;
                                this.getParent().repaint();
                                // MONITOREXIT : var5_4
                                this.getParent().repaint();
                                return;
                            }
                            if (this.ds.getXLength() != 0) break block25;
                            SpectrogramRenderer.logger.fine("got empty dataset, setting image to null");
                            this.plotImage = null;
                            this.plotImageBounds = null;
                            this.rebinDataSet = null;
                            this.imageXRange = null;
                            this.imageYRange = null;
                            this.getParent().repaint();
                            // MONITOREXIT : var5_4
                            this.getParent().repaint();
                            return;
                        }
                        if (this.ds.getXUnits().isConvertableTo(xAxis.getUnits())) break block26;
                        SpectrogramRenderer.logger.fine("dataset units are incompatable with x axis.");
                        // MONITOREXIT : var5_4
                        this.getParent().repaint();
                        return;
                    }
                    if (this.ds.getYUnits().isConvertableTo(yAxis.getUnits())) break block27;
                    SpectrogramRenderer.logger.fine("dataset units are incompatable with y axis.");
                    // MONITOREXIT : var5_4
                    this.getParent().repaint();
                    return;
                }
                if (((TableDataSet)this.ds).getZUnits().isConvertableTo(this.colorBar.getUnits())) break block28;
                SpectrogramRenderer.logger.fine("dataset units are incompatable with colorbar.");
                // MONITOREXIT : var5_4
                this.getParent().repaint();
                return;
            }
            xRebinDescriptor = new RebinDescriptor(xAxis.invTransform(plotImageBounds2.x), xAxis.invTransform(plotImageBounds2.x + plotImageBounds2.width), plotImageBounds2.width, xAxis.isLog());
            yRebinDescriptor = new RebinDescriptor(yAxis.invTransform(plotImageBounds2.y + plotImageBounds2.height), yAxis.invTransform(plotImageBounds2.y), plotImageBounds2.height, yAxis.isLog());
            this.imageXRange = xAxis.getDatumRange();
            this.imageYRange = yAxis.getDatumRange();
            SpectrogramRenderer.logger.fine("rebinning to pixel resolution: " + xRebinDescriptor + "  " + yRebinDescriptor);
            SpectrogramRenderer.logger.fine("rebinning to pixel resolution: " + plotImageBounds2);
            rebinner = this.rebinnerEnum.getRebinner();
            t0 = System.currentTimeMillis();
            this.rebinDataSet = (TableDataSet)rebinner.rebin(this.ds, xRebinDescriptor, yRebinDescriptor);
            this.xmemento = xAxis.getMemento();
            this.ymemento = yAxis.getMemento();
            this.cmemento = this.colorBar.getMemento();
            SpectrogramRenderer.logger.fine("rebinning to pixel resolution: " + this.xmemento + "  " + this.ymemento);
            this.raster = SpectrogramRenderer.transformSimpleTableDataSet(this.rebinDataSet, this.colorBar, yAxis.isFlipped());
            this.rasterWidth = plotImageBounds2.width;
            this.rasterHeight = plotImageBounds2.height;
lbl80:
            // 2 sources

            model = this.colorBar.getIndexColorModel();
            plotImage2 = new BufferedImage(plotImageBounds2.width, plotImageBounds2.height, 13, model);
            r = plotImage2.getRaster();
            if (plotImageBounds2.width == this.rasterWidth && plotImageBounds2.height == this.rasterHeight) {
                r.setDataElements(0, 0, this.rasterWidth, this.rasterHeight, this.raster);
            } else {
                System.err.println("avoided raster ArrayIndex... track this down sometime...");
            }
            this.plotImage = plotImage2;
            this.plotImageBounds = plotImageBounds2;
            // MONITOREXIT : var5_4
            return;
        }
        catch (InconvertibleUnitsException ex) {
            SpectrogramRenderer.logger.fine("inconvertable units, setting image to null");
            ex.printStackTrace();
            this.plotImage = null;
            this.plotImageBounds = null;
            this.rebinDataSet = null;
            this.imageXRange = null;
            this.imageYRange = null;
            if (this.getLastException() == null) {
                this.setException(ex);
            }
            this.getParent().repaint();
            this.getParent().repaint();
            return;
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            return;
        }
        catch (NoDataInIntervalException e) {
            this.setLastException(e);
            this.plotImage = null;
            return;
        }
        finally {
            this.getParent().repaint();
        }
    }

    protected void installRenderer() {
        if (this.parent != null && this.parent.getCanvas() != null && this.colorBar != null) {
            if (this.colorBar.getColumn() == DasColumn.NULL) {
                DasColumn column = this.parent.getColumn();
                this.colorBar.setColumn(new DasColumn(null, column, 1.0, 1.0, 1.0, 2.0, 0, 0));
            }
            this.parent.getCanvas().add(this.colorBar, this.parent.getRow(), this.colorBar.getColumn());
            if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
                DasMouseInputAdapter mouseAdapter = this.parent.mouseAdapter;
                VerticalSpectrogramSlicer vSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
                VerticalSlicerMouseModule vsl = VerticalSlicerMouseModule.create(this);
                vsl.addDataPointSelectionListener(vSlicer);
                mouseAdapter.addMouseModule(vsl);
                HorizontalSpectrogramSlicer hSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
                HorizontalSlicerMouseModule hsl = HorizontalSlicerMouseModule.create(this);
                hsl.addDataPointSelectionListener(hSlicer);
                mouseAdapter.addMouseModule(hsl);
                VerticalSpectrogramAverager vAverager = VerticalSpectrogramAverager.createAverager(this.parent, this);
                HorizontalDragRangeSelectorMouseModule vrl = new HorizontalDragRangeSelectorMouseModule(this.parent, this, this.parent.getXAxis());
                vrl.addDataRangeSelectionListener(vAverager);
                mouseAdapter.addMouseModule(vrl);
                CrossHairMouseModule ch = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                mouseAdapter.addMouseModule(ch);
            }
        }
    }

    protected void uninstallRenderer() {
        if (this.colorBar != null && this.colorBar.getCanvas() != null) {
            this.colorBar.getCanvas().remove(this.colorBar);
        }
    }

    public static SpectrogramRenderer processSpectrogramElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        String dataSetID = element.getAttribute("dataSetID");
        DasColorBar colorbar = null;
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element) || !node.getNodeName().equals("zAxis")) continue;
            colorbar = SpectrogramRenderer.processZAxisElement((Element)node, form);
        }
        if (colorbar == null) {
            try {
                colorbar = (DasColorBar)form.checkValue(element.getAttribute("colorbar"), DasColorBar.class, "<colorbar>");
            }
            catch (DasPropertyException dpe) {
                dpe.setPropertyName("colorbar");
                throw dpe;
            }
        }
        SpectrogramRenderer renderer = new SpectrogramRenderer(parent, null, colorbar);
        try {
            renderer.setDataSetID(dataSetID);
        }
        catch (DasException de) {
            DasExceptionHandler.handle(de);
        }
        return renderer;
    }

    private static DasColorBar processZAxisElement(Element element, FormBase form) throws DasPropertyException, DasNameException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return DasColorBar.processColorbarElement((Element)node, form);
        }
        return null;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("spectrogram");
        element.setAttribute("dataSetID", this.getDataSetID());
        Element zAxisChild = document.createElement("zAxis");
        Element zAxisElement = this.getColorBar().getDOMElement(document);
        if (zAxisElement.getAttribute("row").equals(this.getParent().getRow().getDasName())) {
            zAxisElement.removeAttribute("row");
        }
        if (zAxisElement.getAttribute("column").equals(this.getParent().getColumn().getDasName())) {
            zAxisElement.removeAttribute("column");
        }
        zAxisChild.appendChild(zAxisElement);
        element.appendChild(zAxisChild);
        return element;
    }

    public RebinnerEnum getRebinner() {
        return this.rebinnerEnum;
    }

    public void setRebinner(RebinnerEnum rebinnerEnum) {
        RebinnerEnum old = this.rebinnerEnum;
        if (old != rebinnerEnum) {
            this.rebinnerEnum = rebinnerEnum;
            this.raster = null;
            this.plotImage = null;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("rebinner", old, rebinnerEnum);
        }
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    public String getListLabel() {
        return "spectrogram";
    }

    public Icon getListIcon() {
        return this.rebinnerEnum.getListIcon();
    }

    public DataSet getConsumedDataSet() {
        if (this.sliceRebinnedData) {
            return this.rebinDataSet;
        }
        return this.ds;
    }

    public void setDataSet(DataSet ds) {
        DataSet oldDs = this.ds;
        if (this.parent != null && oldDs != ds) {
            this.raster = null;
            this.plotImage = null;
        }
        super.setDataSet(ds);
    }

    public boolean isPrint300dpi() {
        return this.print300dpi;
    }

    public void setPrint300dpi(boolean print300dpi) {
        this.print300dpi = print300dpi;
    }

    public boolean acceptContext(int x, int y) {
        return true;
    }

    public static class RebinnerEnum
    implements Enumeration {
        DataSetRebinner rebinner;
        String label;
        public static final RebinnerEnum binAverage = new RebinnerEnum(new AverageTableRebinner(), "binAverage");
        public static final RebinnerEnum nearestNeighbor;
        public static final RebinnerEnum binAverageNoInterpolate;
        public static final RebinnerEnum binAverageNoInterpolateNoEnlarge;

        public RebinnerEnum(DataSetRebinner rebinner, String label) {
            this.rebinner = rebinner;
            this.label = label;
        }

        public Icon getListIcon() {
            return new ImageIcon(SpectrogramRenderer.class.getResource("/images/icons/rebin." + this.label + ".png"));
        }

        public String toString() {
            return this.label;
        }

        DataSetRebinner getRebinner() {
            return this.rebinner;
        }

        static {
            AverageTableRebinner rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            binAverageNoInterpolate = new RebinnerEnum(rebinner, "noInterpolate");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolate(false);
            rebinner.setEnlargePixels(false);
            binAverageNoInterpolateNoEnlarge = new RebinnerEnum(rebinner, "noInterpolateNoEnlarge");
            rebinner = new AverageTableRebinner();
            rebinner.setInterpolateType(AverageTableRebinner.Interpolate.NearestNeighbor);
            nearestNeighbor = new RebinnerEnum(rebinner, "nearestNeighbor");
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            SpectrogramRenderer.this.update();
            SpectrogramRenderer.this.refreshImage();
        }
    }
}

