/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasProperties;
import org.das2.components.propertyeditor.Displayable;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.GraphUtil;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeriesRenderer
extends Renderer
implements Displayable {
    private DefaultPlotSymbol psym = DefaultPlotSymbol.CIRCLES;
    private double symSize = 3.0;
    private double lineWidth = 1.0;
    private boolean histogram = false;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private FillStyle fillStyle = FillStyle.STYLE_FILL;
    private int renderCount = 0;
    private int updateImageCount = 0;
    private Color color = Color.BLACK;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));
    private int firstIndex;
    private int lastIndex;
    boolean updating = false;
    private Logger log = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private boolean dataSetClipped;
    Image psymImage;
    Image[] coloredPsyms;
    int cmx;
    int cmy;
    FillRenderElement fillElement = new FillRenderElement();
    ErrorBarRenderElement errorElement = new ErrorBarRenderElement();
    PsymConnectorRenderElement psymConnectorElement = new PsymConnectorRenderElement();
    PsymConnectorRenderElement[] extraConnectorElements;
    PsymRenderElement psymsElement = new PsymRenderElement();
    public static final String PROPERTY_X_DELTA_PLUS = "X_DELTA_PLUS";
    public static final String PROPERTY_X_DELTA_MINUS = "X_DELTA_MINUS";
    public static final String PROPERTY_Y_DELTA_PLUS = "Y_DELTA_PLUS";
    public static final String PROPERTY_Y_DELTA_MINUS = "Y_DELTA_MINUS";
    private boolean selected;
    private Color fillColor = Color.lightGray;
    private String colorByDataSetId = null;
    private DasColorBar colorBar;
    private boolean fillToReference;
    private Datum reference = Units.dimensionless.createDatum(0);
    private VectorDataSet colorByDataSet;
    private boolean resetDebugCounters;
    private boolean simplifyPaths = true;
    private boolean stampPsyms = true;
    public static final String PROP_STAMPPSYMS = "stampPsyms";
    public static final String PROP_LEGENDLABEL = "legendLabel";
    protected String legendLabel = "";
    private int dataSetSizeLimit = 200000;
    private double updatesPointsPerMillisecond;
    public static final String PROP_UPDATESPOINTSPERMILLISECOND = "updatesPointsPerMillisecond";
    private double renderPointsPerMillisecond;
    public static final String PROP_RENDERPOINTSPERMILLISECOND = "renderPointsPerMillisecond";
    protected boolean cadenceCheck = true;
    public static final String PROP_CADENCECHECK = "cadenceCheck";

    public SeriesRenderer() {
        this.updatePsym();
    }

    private float midPoint(DasAxis axis, double d1, Units units, double delta, Units offsetUnits, double alpha) {
        float fx1 = axis.isLog() && offsetUnits == Units.logERatio ? (float)axis.transform(Math.exp(Math.log(d1) + delta * alpha), units) : (float)axis.transform(d1 + delta * alpha, units);
        return fx1;
    }

    private void updatePsym() {
        int sx = 6 + (int)Math.ceil(this.symSize + 2.0 * this.lineWidth);
        int sy = 6 + (int)Math.ceil(this.symSize + 2.0 * this.lineWidth);
        double dcmx = this.lineWidth + (double)((int)Math.ceil(this.symSize / 2.0)) + 2.0;
        double dcmy = this.lineWidth + (double)((int)Math.ceil(this.symSize / 2.0)) + 2.0;
        BufferedImage image = new BufferedImage(sx, sy, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Object rendering = this.antiAliased ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
        g.setColor(this.color);
        if (this.parent != null) {
            g.setBackground(this.parent.getBackground());
        }
        g.setStroke(new BasicStroke((float)this.lineWidth));
        this.psym.draw(g, dcmx, dcmy, (float)this.symSize, this.fillStyle);
        this.psymImage = image;
        if (this.colorBar != null) {
            IndexColorModel model = this.colorBar.getIndexColorModel();
            this.coloredPsyms = new Image[model.getMapSize()];
            for (int i = 0; i < model.getMapSize(); ++i) {
                Color c = new Color(model.getRGB(i));
                image = new BufferedImage(sx, sy, 2);
                g = (Graphics2D)image.getGraphics();
                if (this.parent != null) {
                    g.setBackground(this.parent.getBackground());
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
                g.setColor(c);
                g.setStroke(new BasicStroke((float)this.lineWidth));
                this.psym.draw(g, dcmx, dcmy, (float)this.symSize, this.fillStyle);
                this.coloredPsyms[i] = image;
            }
        }
        this.cmx = (int)dcmx;
        this.cmy = (int)dcmy;
        this.update();
    }

    private void reportCount() {
    }

    public synchronized void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        logger.fine("ds: " + this.ds + ",  drawing indeces " + this.firstIndex + " to " + this.lastIndex);
        if (this.parent == null) {
            return;
        }
        if (this.ds == null && this.getLastException() != null) {
            this.parent.postException(this, this.getLastException());
            return;
        }
        if (this.legendLabel != null && this.legendLabel.length() > 0) {
            this.parent.addToLegend(this, (ImageIcon)this.getListIcon(), 0, this.legendLabel);
        }
        ++this.renderCount;
        this.reportCount();
        long timer0 = System.currentTimeMillis();
        DataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            this.parent.postMessage(this, "no data set", 0, null, null);
            return;
        }
        if (dataSet.getXLength() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("empty data set");
            this.parent.postMessage(this, "empty data set", 0, null, null);
            return;
        }
        TableDataSet tds = null;
        VectorDataSet vds = null;
        boolean plottable = false;
        if (dataSet instanceof VectorDataSet) {
            vds = (VectorDataSet)dataSet;
            plottable = dataSet.getYUnits().isConvertableTo(yAxis.getUnits());
        } else if (dataSet instanceof TableDataSet) {
            tds = (TableDataSet)dataSet;
            plottable = tds.getZUnits().isConvertableTo(yAxis.getUnits());
        }
        boolean bl = plottable = plottable && dataSet.getXUnits().isConvertableTo(xAxis.getUnits());
        if (!plottable) {
            this.parent.postMessage(this, "data set units cannot convert to axis units", 1, null, null);
            return;
        }
        logger.fine("rendering points: " + this.lastIndex + "  " + this.firstIndex);
        if (this.lastIndex == this.firstIndex) {
            this.parent.postMessage(this, "dataset contains no valid data", 0, null, null);
            return;
        }
        logger.fine("render data set " + dataSet);
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (tds != null) {
            String label;
            int j;
            if (this.extraConnectorElements == null) {
                return;
            }
            if (tds.getYLength(0) != this.extraConnectorElements.length) {
                return;
            }
            int maxWidth = 0;
            for (j = 0; j < tds.getYLength(0); ++j) {
                label = String.valueOf(tds.getYTagDatum(0, j));
                maxWidth = Math.max(maxWidth, g.getFontMetrics().stringWidth(label));
            }
            for (j = 0; j < tds.getYLength(0); ++j) {
                vds = tds.getYSlice(j, 0);
                graphics.setColor(this.color);
                if (this.extraConnectorElements[j] == null) continue;
                this.extraConnectorElements[j].render(graphics, xAxis, yAxis, vds, mon);
                label = String.valueOf(tds.getYTagDatum(0, j)).trim();
                this.parent.addToLegend(this, (ImageIcon)GraphUtil.colorIcon(this.extraConnectorElements[j].color, 5, 5), j, label);
            }
            return;
        }
        if (this.fillToReference) {
            this.fillElement.render(graphics, xAxis, yAxis, vds, mon);
        }
        graphics.setColor(this.color);
        this.log.finest("drawing psymConnector in " + this.color);
        int count = 0;
        count = Math.max(count, this.psymConnectorElement.render(graphics, xAxis, yAxis, vds, mon));
        count = Math.max(count, this.errorElement.render(graphics, xAxis, yAxis, vds, mon));
        if (this.psym != DefaultPlotSymbol.NONE) {
            if ((count = Math.max(count, this.psymsElement.render(graphics, xAxis, yAxis, vds, mon))) == 0) {
                this.parent.postMessage(this, "no valid points", 0, null, null);
            }
            mon.finished();
        }
        long milli = System.currentTimeMillis();
        long renderTime = milli - timer0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        this.setRenderPointsPerMillisecond(dppms);
        logger.finer("render: " + renderTime + " total:" + (milli - this.lastUpdateMillis) + " fps:" + 1000.0 / (double)(milli - this.lastUpdateMillis) + " pts/ms:" + dppms);
        this.lastUpdateMillis = milli;
        if (this.dataSetClipped) {
            this.parent.postMessage(this, "dataset clipped at " + this.dataSetSizeLimit + " points", 1, null, null);
        }
        if (count > 0 && this.lastIndex - this.firstIndex < 2) {
            this.parent.postMessage(this, "less than two points visible", 0, null, null);
        }
    }

    private synchronized void updateFirstLast(DasAxis xAxis, DasAxis yAxis, VectorDataSet dataSet) {
        int index;
        int ixmax;
        int ixmin;
        Units xUnits = xAxis.getUnits();
        Units yUnits = yAxis.getUnits();
        Boolean xMono = (Boolean)dataSet.getProperty("xMonotonic");
        if (xMono != null && xMono.booleanValue()) {
            Rectangle plotBounds;
            DatumRange visibleRange = xAxis.getDatumRange();
            if (this.parent.isOverSize() && (plotBounds = this.parent.getCacheImageBounds()) != null) {
                visibleRange = new DatumRange(xAxis.invTransform(plotBounds.x), xAxis.invTransform(plotBounds.x + plotBounds.width));
            }
            ixmin = DataSetUtil.getPreviousColumn(dataSet, visibleRange.min());
            ixmax = DataSetUtil.getNextColumn(dataSet, visibleRange.max()) + 1;
        } else {
            ixmin = 0;
            ixmax = dataSet.getXLength();
        }
        Datum sw = DataSetUtil.guessXTagWidth(dataSet);
        double xSampleWidth = sw.doubleValue(xUnits.getOffsetUnits());
        xSampleWidth *= 1.1;
        double x = Double.NaN;
        double y = Double.NaN;
        for (index = ixmin; index < ixmax; ++index) {
            boolean isValid;
            x = dataSet.getXTagDouble(index, xUnits);
            y = dataSet.getDouble(index, yUnits);
            boolean bl = isValid = yUnits.isValid(y) && xUnits.isValid(x);
            if (!isValid) continue;
            this.firstIndex = index++;
            break;
        }
        int pointsPlotted = 0;
        for (index = this.firstIndex; index < ixmax && pointsPlotted < this.dataSetSizeLimit; ++index) {
            boolean isValid;
            y = dataSet.getDouble(index, yUnits);
            boolean bl = isValid = yUnits.isValid(y) && xUnits.isValid(x);
            if (!isValid) continue;
            ++pointsPlotted;
        }
        if (index < ixmax && pointsPlotted == this.dataSetSizeLimit) {
            this.dataSetClipped = true;
        }
        this.lastIndex = index;
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) {
        logger.fine("enter updatePlotImage");
        this.updating = true;
        ++this.updateImageCount;
        this.reportCount();
        try {
            super.updatePlotImage(xAxis, yAxis, monitor);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
        DataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            logger.fine("dataset was null");
            return;
        }
        if (dataSet.getXLength() == 0) {
            logger.fine("dataset was empty");
            return;
        }
        TableDataSet tds = null;
        VectorDataSet vds = null;
        boolean plottable = false;
        if (dataSet instanceof VectorDataSet) {
            vds = (VectorDataSet)dataSet;
            plottable = dataSet.getYUnits().isConvertableTo(yAxis.getUnits());
        } else if (dataSet instanceof TableDataSet) {
            tds = (TableDataSet)dataSet;
            plottable = tds.getZUnits().isConvertableTo(yAxis.getUnits());
        }
        boolean bl = plottable = plottable && dataSet.getXUnits().isConvertableTo(xAxis.getUnits());
        if (!plottable) {
            return;
        }
        logger.fine("entering updatePlotImage");
        long t0 = System.currentTimeMillis();
        this.dataSetClipped = false;
        if (vds != null) {
            this.updateFirstLast(xAxis, yAxis, vds);
            if (this.fillToReference) {
                this.fillElement.update(xAxis, yAxis, vds, monitor);
            }
            if (this.psymConnector != PsymConnector.NONE) {
                this.psymConnectorElement.update(xAxis, yAxis, vds, monitor);
            }
            this.errorElement.update(xAxis, yAxis, vds, monitor);
            this.psymsElement.update(xAxis, yAxis, vds, monitor);
        } else if (tds != null) {
            this.extraConnectorElements = new PsymConnectorRenderElement[tds.getYLength(0)];
            for (int i = 0; i < tds.getYLength(0); ++i) {
                this.extraConnectorElements[i] = new PsymConnectorRenderElement();
                float[] colorHSV = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
                if (colorHSV[2] < 0.7f) {
                    colorHSV[2] = 0.7f;
                }
                if (colorHSV[1] < 0.7f) {
                    colorHSV[1] = 0.7f;
                }
                this.extraConnectorElements[i].color = Color.getHSBColor((float)i / 6.0f, colorHSV[1], colorHSV[2]);
                vds = tds.getYSlice(i, 0);
                if (i == 0) {
                    this.updateFirstLast(xAxis, yAxis, vds);
                }
                this.extraConnectorElements[i].update(xAxis, yAxis, vds, monitor);
            }
        }
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        logger.fine("done updatePlotImage in " + (System.currentTimeMillis() - t0) + " ms");
        this.updating = false;
        long milli = System.currentTimeMillis();
        long renderTime = milli - t0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        this.setUpdatesPointsPerMillisecond(dppms);
    }

    protected void installRenderer() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            DasMouseInputAdapter mouseAdapter = this.parent.mouseAdapter;
            DasPlot p = this.parent;
            mouseAdapter.addMouseModule(new MouseModule(p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
        }
        this.updatePsym();
    }

    protected void uninstallRenderer() {
    }

    public Element getDOMElement(Document document) {
        return null;
    }

    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(15, 10, 2);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        g.setRenderingHints(DasProperties.getRenderingHints());
        if (this.parent != null) {
            g.setBackground(this.parent.getBackground());
        }
        if (this.color.equals(Color.white)) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(new Color(0, 0, 0, 0));
        }
        g.fillRect(0, 0, 15, 10);
        if (this.fillToReference) {
            g.setColor(this.fillColor);
            Polygon p = new Polygon(new int[]{2, 13, 13, 2}, new int[]{3, 7, 10, 10}, 4);
            g.fillPolygon(p);
        }
        g.setColor(this.color);
        Stroke stroke0 = g.getStroke();
        this.getPsymConnector().drawLine(g, 2.0, 3.0, 13.0, 7.0, 1.5f);
        g.setStroke(stroke0);
        this.psym.draw(g, 7.0, 5.0, 3.0f, this.fillStyle);
        return new ImageIcon(i);
    }

    public String getListLabel() {
        return String.valueOf(this.getDataSetDescriptor());
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        PsymConnector old = this.psymConnector;
        if (!p.equals(this.psymConnector)) {
            this.psymConnector = p;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("psymConnector", old, p);
        }
    }

    public PlotSymbol getPsym() {
        return this.psym;
    }

    public void setPsym(PlotSymbol psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        if (psym != this.psym) {
            DefaultPlotSymbol oldValue = this.psym;
            this.psym = (DefaultPlotSymbol)psym;
            this.updatePsym();
            this.update();
            this.propertyChangeSupport.firePropertyChange("psym", oldValue, psym);
        }
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double symSize) {
        double old = this.symSize;
        if (this.symSize != symSize) {
            this.symSize = symSize;
            this.setPsym(this.psym);
            this.updatePsym();
            this.update();
            this.propertyChangeSupport.firePropertyChange("symSize", new Double(old), new Double(symSize));
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("null color");
        }
        Color old = this.color;
        if (!this.color.equals(color)) {
            this.color = color;
            this.updatePsym();
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("color", old, color);
            this.updatePsym();
        }
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double f) {
        double old = this.lineWidth;
        if (this.lineWidth != f) {
            this.lineWidth = f;
            this.updatePsym();
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("lineWidth", new Double(old), new Double(f));
        }
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        this.updatePsym();
        this.refreshImage();
        this.propertyChangeSupport.firePropertyChange("antiAliased", old, antiAliased);
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean b) {
        boolean old = b;
        if (b != this.histogram) {
            this.histogram = b;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("histogram", old, this.antiAliased);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Color old = this.fillColor;
        if (!this.fillColor.equals(color)) {
            this.fillColor = color;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillColor", old, color);
        }
    }

    public String getColorByDataSetId() {
        return this.colorByDataSetId;
    }

    public void setColorByDataSetId(String colorByDataSetId) {
        String oldVal = this.colorByDataSetId;
        this.colorByDataSetId = colorByDataSetId;
        this.update();
        this.propertyChangeSupport.firePropertyChange("colorByDataSetId", oldVal, colorByDataSetId);
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar colorBar) {
        this.colorBar = colorBar;
        colorBar.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                    SeriesRenderer.this.update();
                }
            }
        });
        this.refreshImage();
        this.updatePsym();
    }

    public boolean isFillToReference() {
        return this.fillToReference;
    }

    public void setFillToReference(boolean fillToReference) {
        boolean old = this.fillToReference;
        if (this.fillToReference != fillToReference) {
            this.fillToReference = fillToReference;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillToReference", old, fillToReference);
        }
    }

    public Datum getReference() {
        return this.reference;
    }

    public void setReference(Datum reference) {
        Datum old = this.reference;
        if (!this.reference.equals(reference)) {
            this.reference = reference;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("reference", old, reference);
        }
    }

    public VectorDataSet getColorByDataSet() {
        return this.colorByDataSet;
    }

    public void setColorByDataSet(VectorDataSet colorByDataSet) {
        this.colorByDataSet = colorByDataSet;
        this.refreshImage();
    }

    public boolean isResetDebugCounters() {
        return this.resetDebugCounters;
    }

    public void setResetDebugCounters(boolean resetDebugCounters) {
        if (resetDebugCounters) {
            this.renderCount = 0;
            this.updateImageCount = 0;
            this.update();
        }
    }

    public boolean isSimplifyPaths() {
        return this.simplifyPaths;
    }

    public void setSimplifyPaths(boolean simplifyPaths) {
        this.simplifyPaths = simplifyPaths;
        this.refreshImage();
    }

    public boolean isStampPsyms() {
        return this.stampPsyms;
    }

    public void setStampPsyms(boolean newstampPsyms) {
        boolean oldstampPsyms = this.stampPsyms;
        this.stampPsyms = newstampPsyms;
        this.propertyChangeSupport.firePropertyChange(PROP_STAMPPSYMS, oldstampPsyms, newstampPsyms);
        this.refreshImage();
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillStyle fillStyle) {
        this.fillStyle = fillStyle;
        this.updatePsym();
        this.refreshImage();
    }

    public String getLegendLabel() {
        return this.legendLabel;
    }

    public void setLegendLabel(String legendLabel) {
        String oldLegendLabel = this.legendLabel;
        this.legendLabel = legendLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_LEGENDLABEL, oldLegendLabel, legendLabel);
    }

    public boolean acceptContext(int x, int y) {
        boolean accept = false;
        Point2D.Double dp = new Point2D.Double(x, y);
        if (this.fillToReference && this.fillElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.psymConnectorElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.extraConnectorElements != null) {
            for (int j = 0; j < this.extraConnectorElements.length; ++j) {
                if (accept || this.extraConnectorElements[j] == null || !this.extraConnectorElements[j].acceptContext(dp)) continue;
                accept = true;
            }
        }
        if (!accept && this.psymsElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.errorElement.acceptContext(dp)) {
            accept = true;
        }
        return accept;
    }

    public int getDataSetSizeLimit() {
        return this.dataSetSizeLimit;
    }

    public void setDataSetSizeLimit(int dataSetSizeLimit) {
        int oldDataSetSizeLimit = this.dataSetSizeLimit;
        this.dataSetSizeLimit = dataSetSizeLimit;
        this.refreshImage();
        this.propertyChangeSupport.firePropertyChange("dataSetSizeLimit", new Integer(oldDataSetSizeLimit), new Integer(dataSetSizeLimit));
    }

    public double getUpdatesPointsPerMillisecond() {
        return this.updatesPointsPerMillisecond;
    }

    public void setUpdatesPointsPerMillisecond(double newupdatesPointsPerMillisecond) {
        this.updatesPointsPerMillisecond = newupdatesPointsPerMillisecond;
    }

    public double getRenderPointsPerMillisecond() {
        return this.renderPointsPerMillisecond;
    }

    public void setRenderPointsPerMillisecond(double newrenderPointsPerMillisecond) {
        this.renderPointsPerMillisecond = newrenderPointsPerMillisecond;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public boolean isCadenceCheck() {
        return this.cadenceCheck;
    }

    public void setCadenceCheck(boolean cadenceCheck) {
        boolean oldCadenceCheck = this.cadenceCheck;
        this.cadenceCheck = cadenceCheck;
        this.refreshImage();
        this.propertyChangeSupport.firePropertyChange(PROP_CADENCECHECK, oldCadenceCheck, cadenceCheck);
    }

    class FillRenderElement
    implements RenderElement {
        private GeneralPath fillToRefPath1;

        FillRenderElement() {
        }

        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, VectorDataSet vds, ProgressMonitor mon) {
            if (this.fillToRefPath1 == null) {
                return 0;
            }
            g.setColor(SeriesRenderer.this.fillColor);
            g.fill(this.fillToRefPath1);
            return 0;
        }

        public void update(DasAxis xAxis, DasAxis yAxis, VectorDataSet dataSet, ProgressMonitor mon) {
            Units xUnits = xAxis.getUnits();
            Units yUnits = yAxis.getUnits();
            GeneralPath fillPath = new GeneralPath(1, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
            Datum sw = DataSetUtil.guessXTagWidth(dataSet);
            double xSampleWidth = UnitsUtil.isRatiometric(sw.getUnits()) ? sw.doubleValue(Units.logERatio) : sw.doubleValue(xUnits.getOffsetUnits());
            xSampleWidth *= 1.1;
            if (SeriesRenderer.this.reference != null && SeriesRenderer.this.reference.getUnits() != yAxis.getUnits()) {
                SeriesRenderer.this.reference = yAxis.getUnits().createDatum(SeriesRenderer.this.reference.doubleValue(SeriesRenderer.this.reference.getUnits()));
            }
            if (SeriesRenderer.this.reference == null) {
                SeriesRenderer.this.reference = yUnits.createDatum(yAxis.isLog() ? 1.0 : 0.0);
            }
            double yref = SeriesRenderer.this.reference.doubleValue(yUnits);
            double x = Double.NaN;
            double y = Double.NaN;
            double x0 = Double.NaN;
            double y0 = Double.NaN;
            float fyref = (float)yAxis.transform(yref, yUnits);
            float fx = Float.NaN;
            float fy = Float.NaN;
            float fx0 = Float.NaN;
            float fy0 = Float.NaN;
            int index = SeriesRenderer.this.firstIndex;
            x = dataSet.getXTagDouble(index, xUnits);
            y = dataSet.getDouble(index, yUnits);
            fx = (float)xAxis.transform(x, xUnits);
            fy = (float)yAxis.transform(y, yUnits);
            if (SeriesRenderer.this.histogram) {
                float fx1 = SeriesRenderer.this.midPoint(xAxis, x, xUnits, xSampleWidth, sw.getUnits(), -0.5);
                fillPath.moveTo(fx1, fyref);
                fillPath.lineTo(fx1, fy);
                fillPath.lineTo(fx, fy);
            } else {
                fillPath.moveTo(fx, fyref);
                fillPath.lineTo(fx, fy);
            }
            x0 = x;
            y0 = y;
            fx0 = fx;
            fy0 = fy;
            if (SeriesRenderer.this.psymConnector != PsymConnector.NONE || SeriesRenderer.this.fillToReference) {
                while (index < SeriesRenderer.this.lastIndex) {
                    x = dataSet.getXTagDouble(index, xUnits);
                    y = dataSet.getDouble(index, yUnits);
                    boolean isValid = yUnits.isValid(y) && xUnits.isValid(x);
                    fx = (float)xAxis.transform(x, xUnits);
                    fy = (float)yAxis.transform(y, yUnits);
                    if (isValid) {
                        float fx1;
                        if (x - x0 < xSampleWidth) {
                            if (SeriesRenderer.this.histogram) {
                                fx1 = (fx0 + fx) / 2.0f;
                                fillPath.lineTo(fx1, fy0);
                                fillPath.lineTo(fx1, fy);
                                fillPath.lineTo(fx, fy);
                            } else {
                                fillPath.lineTo(fx, fy);
                            }
                        } else if (SeriesRenderer.this.histogram) {
                            fx1 = SeriesRenderer.this.midPoint(xAxis, x0, xUnits, xSampleWidth, sw.getUnits(), 0.5);
                            fillPath.lineTo(fx1, fy0);
                            fillPath.lineTo(fx1, fyref);
                            fx1 = SeriesRenderer.this.midPoint(xAxis, x, xUnits, xSampleWidth, sw.getUnits(), -0.5);
                            fillPath.moveTo(fx1, fyref);
                            fillPath.lineTo(fx1, fy);
                            fillPath.lineTo(fx, fy);
                        } else {
                            fillPath.lineTo(fx0, fyref);
                            fillPath.moveTo(fx, fyref);
                            fillPath.lineTo(fx, fy);
                        }
                        x0 = x;
                        y0 = y;
                        fx0 = fx;
                        fy0 = fy;
                    }
                    ++index;
                }
            }
            fillPath.lineTo(fx0, fyref);
            this.fillToRefPath1 = fillPath;
            if (SeriesRenderer.this.simplifyPaths) {
                this.fillToRefPath1 = GraphUtil.reducePath(this.fillToRefPath1.getPathIterator(null), new GeneralPath(1, SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex));
            }
        }

        public boolean acceptContext(Point2D.Double dp) {
            return this.fillToRefPath1 != null && this.fillToRefPath1.contains(dp);
        }
    }

    class PsymConnectorRenderElement
    implements RenderElement {
        private GeneralPath path1;
        private Color color;

        PsymConnectorRenderElement() {
        }

        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, VectorDataSet vds, ProgressMonitor mon) {
            if (this.path1 == null) {
                return 0;
            }
            if (this.color != null) {
                g.setColor(this.color);
            }
            SeriesRenderer.this.psymConnector.draw(g, this.path1, (float)SeriesRenderer.this.lineWidth);
            return 0;
        }

        public synchronized void update(DasAxis xAxis, DasAxis yAxis, VectorDataSet dataSet, ProgressMonitor mon) {
            boolean ignoreCadence;
            boolean logStep;
            double xSampleWidth;
            Units xUnits = xAxis.getUnits();
            Units yUnits = yAxis.getUnits();
            if (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex == 0) {
                this.path1 = null;
                return;
            }
            GeneralPath newPath = new GeneralPath(1, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
            Datum sw = DataSetUtil.guessXTagWidth(dataSet);
            if (UnitsUtil.isRatiometric(sw.getUnits())) {
                xSampleWidth = sw.doubleValue(Units.logERatio);
                logStep = true;
            } else {
                xSampleWidth = sw.doubleValue(xUnits.getOffsetUnits());
                logStep = false;
            }
            xSampleWidth *= 1.1;
            double x = Double.NaN;
            double y = Double.NaN;
            double x0 = Double.NaN;
            double y0 = Double.NaN;
            float fx = Float.NaN;
            float fy = Float.NaN;
            float fx0 = Float.NaN;
            float fy0 = Float.NaN;
            int index = SeriesRenderer.this.firstIndex;
            x = dataSet.getXTagDouble(index, xUnits);
            y = dataSet.getDouble(index, yUnits);
            Renderer.logger.fine("firstPoint moveTo,LineTo= " + x + "," + y);
            fx = (float)xAxis.transform(x, xUnits);
            fy = (float)yAxis.transform(y, yUnits);
            if (SeriesRenderer.this.histogram) {
                float fx1 = SeriesRenderer.this.midPoint(xAxis, x, xUnits, xSampleWidth, sw.getUnits(), -0.5);
                newPath.moveTo(fx1, fy);
                newPath.lineTo(fx, fy);
            } else {
                newPath.moveTo(fx, fy);
                newPath.lineTo(fx, fy);
            }
            x0 = x;
            y0 = y;
            fx0 = fx;
            fy0 = fy;
            ++index;
            boolean bl = ignoreCadence = !SeriesRenderer.this.cadenceCheck;
            while (index < SeriesRenderer.this.lastIndex) {
                x = dataSet.getXTagDouble(index, xUnits);
                y = dataSet.getDouble(index, yUnits);
                boolean isValid = yUnits.isValid(y) && xUnits.isValid(x);
                fx = (float)xAxis.transform(x, xUnits);
                fy = (float)yAxis.transform(y, yUnits);
                if (isValid) {
                    float fx1;
                    double step;
                    double d = step = logStep ? Math.log(x / x0) : x - x0;
                    if (ignoreCadence && step < xSampleWidth * 20.0 || step < xSampleWidth) {
                        if (SeriesRenderer.this.histogram) {
                            fx1 = (fx0 + fx) / 2.0f;
                            newPath.lineTo(fx1, fy0);
                            newPath.lineTo(fx1, fy);
                            newPath.lineTo(fx, fy);
                        } else {
                            newPath.lineTo(fx, fy);
                        }
                    } else if (SeriesRenderer.this.histogram) {
                        fx1 = (float)xAxis.transform(x0 + xSampleWidth / 2.0, xUnits);
                        newPath.lineTo(fx1, fy0);
                        fx1 = (float)xAxis.transform(x - xSampleWidth / 2.0, xUnits);
                        newPath.moveTo(fx1, fy);
                        newPath.lineTo(fx, fy);
                    } else {
                        newPath.moveTo(fx, fy);
                        newPath.lineTo(fx, fy);
                    }
                    x0 = x;
                    y0 = y;
                    fx0 = fx;
                    fy0 = fy;
                } else {
                    newPath.moveTo(fx0, fy0);
                }
                ++index;
            }
            this.path1 = !SeriesRenderer.this.histogram && SeriesRenderer.this.simplifyPaths && SeriesRenderer.this.colorByDataSet == null ? GraphUtil.reducePath(newPath.getPathIterator(null), new GeneralPath(1, SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex)) : newPath;
        }

        public boolean acceptContext(Point2D.Double dp) {
            return this.path1 != null && this.path1.intersects(dp.x - 5.0, dp.y - 5.0, 10.0, 10.0);
        }
    }

    class ErrorBarRenderElement
    implements RenderElement {
        GeneralPath p;

        ErrorBarRenderElement() {
        }

        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, VectorDataSet vds, ProgressMonitor mon) {
            if (this.p == null) {
                return 0;
            }
            g.draw(this.p);
            return SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex;
        }

        public synchronized void update(DasAxis xAxis, DasAxis yAxis, VectorDataSet vds, ProgressMonitor mon) {
            VectorDataSet deltaPlusY = (VectorDataSet)vds.getPlanarView(SeriesRenderer.PROPERTY_Y_DELTA_PLUS);
            VectorDataSet deltaMinusY = (VectorDataSet)vds.getPlanarView(SeriesRenderer.PROPERTY_Y_DELTA_MINUS);
            this.p = null;
            if (deltaMinusY == null) {
                return;
            }
            if (deltaMinusY == null) {
                return;
            }
            Units xunits = vds.getXUnits();
            Units yunits = vds.getYUnits();
            Units yoffsetUnits = yunits.getOffsetUnits();
            this.p = new GeneralPath();
            for (int i = SeriesRenderer.this.firstIndex; i < SeriesRenderer.this.lastIndex; ++i) {
                float ix = (float)xAxis.transform(vds.getXTagDouble(i, xunits), xunits);
                double dp = deltaPlusY.getDouble(i, yoffsetUnits);
                double dm = deltaMinusY.getDouble(i, yoffsetUnits);
                if (!yoffsetUnits.isValid(dp) || !yoffsetUnits.isValid(dm)) continue;
                float iym = (float)yAxis.transform(vds.getDouble(i, yunits) - dm, yunits);
                float iyp = (float)yAxis.transform(vds.getDouble(i, yunits) + dp, yunits);
                this.p.moveTo(ix, iym);
                this.p.lineTo(ix, iyp);
            }
        }

        public boolean acceptContext(Point2D.Double dp) {
            return this.p != null && this.p.contains(dp.x - 2.0, dp.y - 2.0, 5.0, 5.0);
        }
    }

    class PsymRenderElement
    implements RenderElement {
        protected GeneralPath psymsPath;
        int[] colors;
        int[] ipsymsPath;
        int count;

        PsymRenderElement() {
        }

        private int renderStamp(Graphics2D g, DasAxis xAxis, DasAxis yAxis, VectorDataSet vds, ProgressMonitor mon) {
            VectorDataSet colorByDataSet = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                colorByDataSet = (VectorDataSet)vds.getPlanarView(SeriesRenderer.this.colorByDataSetId);
            }
            if (colorByDataSet != null) {
                for (int i = 0; i < this.count; ++i) {
                    int icolor = this.colors[i];
                    g.drawImage(SeriesRenderer.this.coloredPsyms[icolor], this.ipsymsPath[i * 2] - SeriesRenderer.this.cmx, this.ipsymsPath[i * 2 + 1] - SeriesRenderer.this.cmy, SeriesRenderer.this.parent);
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    g.drawImage(SeriesRenderer.this.psymImage, this.ipsymsPath[i * 2] - SeriesRenderer.this.cmx, this.ipsymsPath[i * 2 + 1] - SeriesRenderer.this.cmy, SeriesRenderer.this.parent);
                }
            }
            return this.count;
        }

        private int renderDraw(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, VectorDataSet dataSet, ProgressMonitor mon) {
            float fsymSize = (float)SeriesRenderer.this.symSize;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                SeriesRenderer.this.colorByDataSet = (VectorDataSet)dataSet.getPlanarView(SeriesRenderer.this.colorByDataSetId);
            }
            graphics.setStroke(new BasicStroke((float)SeriesRenderer.this.lineWidth));
            Color[] ccolors = null;
            if (SeriesRenderer.this.colorByDataSet != null) {
                IndexColorModel icm = SeriesRenderer.this.colorBar.getIndexColorModel();
                ccolors = new Color[icm.getMapSize()];
                for (int j = 0; j < icm.getMapSize(); ++j) {
                    ccolors[j] = new Color(icm.getRGB(j));
                }
            }
            if (SeriesRenderer.this.colorByDataSet != null) {
                for (int i = 0; i < this.count; ++i) {
                    graphics.setColor(ccolors[this.colors[i]]);
                    SeriesRenderer.this.psym.draw(graphics, this.ipsymsPath[i * 2], this.ipsymsPath[i * 2 + 1], fsymSize, SeriesRenderer.this.fillStyle);
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    SeriesRenderer.this.psym.draw(graphics, this.ipsymsPath[i * 2], this.ipsymsPath[i * 2 + 1], fsymSize, SeriesRenderer.this.fillStyle);
                }
            }
            return this.count;
        }

        public synchronized int render(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, VectorDataSet vds, ProgressMonitor mon) {
            if (SeriesRenderer.this.parent == null) {
                return 0;
            }
            int i = SeriesRenderer.this.stampPsyms && !SeriesRenderer.this.parent.getCanvas().isPrintingThread() ? this.renderStamp(graphics, xAxis, yAxis, vds, mon) : this.renderDraw(graphics, xAxis, yAxis, vds, mon);
            return i;
        }

        public synchronized void update(DasAxis xAxis, DasAxis yAxis, VectorDataSet dataSet, ProgressMonitor mon) {
            int index;
            VectorDataSet colorByDataSet = null;
            Units cunits = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("") && (colorByDataSet = (VectorDataSet)dataSet.getPlanarView(SeriesRenderer.this.colorByDataSetId)) != null) {
                cunits = colorByDataSet.getYUnits();
            }
            Units xUnits = xAxis.getUnits();
            Units yUnits = yAxis.getUnits();
            this.psymsPath = new GeneralPath(1, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
            this.ipsymsPath = new int[(SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) * 2];
            this.colors = new int[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex + 2];
            double x = dataSet.getXTagDouble(index, xUnits);
            double y = dataSet.getDouble(index, yUnits);
            int fx = (int)xAxis.transform(x, xUnits);
            int fy = (int)yAxis.transform(y, yUnits);
            int i = 0;
            for (index = SeriesRenderer.this.firstIndex; index < SeriesRenderer.this.lastIndex; ++index) {
                x = dataSet.getXTagDouble(index, xUnits);
                y = dataSet.getDouble(index, yUnits);
                boolean isValid = yUnits.isValid(y) && xUnits.isValid(x);
                fx = (int)xAxis.transform(x, xUnits);
                fy = (int)yAxis.transform(y, yUnits);
                if (!isValid) continue;
                this.ipsymsPath[i * 2] = fx;
                this.ipsymsPath[i * 2 + 1] = fy;
                if (colorByDataSet != null) {
                    this.colors[i] = SeriesRenderer.this.colorBar.indexColorTransform(colorByDataSet.getDouble(index, cunits), cunits);
                }
                ++i;
            }
            this.count = i;
        }

        public boolean acceptContext(Point2D.Double dp) {
            if (this.ipsymsPath == null) {
                return false;
            }
            double rad = Math.max(SeriesRenderer.this.symSize, 5.0);
            for (int index = SeriesRenderer.this.firstIndex; index < SeriesRenderer.this.lastIndex; ++index) {
                int i = index - SeriesRenderer.this.firstIndex;
                if (!(dp.distance(this.ipsymsPath[i * 2], this.ipsymsPath[i * 2 + 1]) < rad)) continue;
                return true;
            }
            return false;
        }
    }

    static interface RenderElement {
        public int render(Graphics2D var1, DasAxis var2, DasAxis var3, VectorDataSet var4, ProgressMonitor var5);

        public void update(DasAxis var1, DasAxis var2, VectorDataSet var3, ProgressMonitor var4);

        public boolean acceptContext(Point2D.Double var1);
    }
}

