/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.event.DasUpdateEvent;
import org.das2.graph.event.DasUpdateListener;
import org.das2.system.DasLogger;
import org.das2.util.DasMath;

public class DataRange
implements Cloneable {
    private DasAxis parent;
    private Units units;
    private double minimum;
    private double maximum;
    private Datum pendingMin = null;
    private Datum pendingMax = null;
    private DatumRange range;
    public static String PROPERTY_DATUMRANGE = "datumRange";
    private boolean log;
    private EventListenerList listenerList = new EventListenerList();
    private Stack history;
    private Stack forwardHistory;
    private List favorites;
    private PropertyChangeSupport propertyChangeDelegate;
    boolean valueIsAdjusting = false;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion failure");
        }
    }

    public DataRange(DasAxis parent, Datum min, Datum max, boolean log) {
        if (min.gt(max)) {
            throw new IllegalArgumentException("data min on axis is greater than data max (" + min + ">" + max + ")");
        }
        if (!min.isFinite()) {
            throw new IllegalArgumentException("data_minimum on axis is not finite");
        }
        if (!max.isFinite()) {
            throw new IllegalArgumentException("data_maximum on axis is not finite");
        }
        if (!min.getUnits().isConvertableTo(max.getUnits())) {
            throw new IllegalArgumentException("units are not conversion compatible");
        }
        this.parent = parent;
        this.units = min.getUnits();
        if (log) {
            this.minimum = DasMath.log10(min.doubleValue(this.units));
            this.maximum = DasMath.log10(max.doubleValue(this.units));
        } else {
            this.minimum = min.doubleValue(this.units);
            this.maximum = max.doubleValue(this.units);
        }
        this.range = new DatumRange(min, max);
        this.log = log;
        this.history = new Stack();
        this.forwardHistory = new Stack();
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
    }

    public boolean isLog() {
        return this.log;
    }

    public void resetRange(DatumRange range) {
        this.units = range.getUnits();
        this.range = range;
        this.minimum = range.min().doubleValue(this.units);
        this.maximum = range.max().doubleValue(this.units);
        if (this.isLog()) {
            this.minimum = DasMath.log10(this.minimum);
            this.maximum = DasMath.log10(this.maximum);
        }
        this.fireUpdate();
    }

    public void setLog(boolean log) {
        if (this.log == log) {
            return;
        }
        boolean oldLog = this.log;
        if (log) {
            if (this.minimum <= 0.0 || this.maximum <= 0.0) {
                if (this.maximum <= 0.0) {
                    double oldMax = this.maximum;
                    this.maximum = 100.0;
                    this.firePropertyChange("maximum", oldMax, this.maximum);
                }
                if (this.minimum <= 0.0) {
                    double oldMin = this.minimum;
                    this.minimum = this.maximum / 1000.0;
                    this.firePropertyChange("minimum", oldMin, this.minimum);
                }
                this.range = new DatumRange(this.minimum, this.maximum, this.range.getUnits());
                this.firePropertyChange("log", oldLog, log);
            }
            this.minimum = DasMath.log10(this.minimum);
            this.maximum = DasMath.log10(this.maximum);
        } else {
            this.minimum = DasMath.exp10(this.minimum);
            this.maximum = DasMath.exp10(this.maximum);
        }
        this.clearHistory();
        this.log = log;
        this.firePropertyChange("log", oldLog, log);
        this.fireUpdate();
    }

    public DasAxis getCreator() {
        return this.parent;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public final double findex(double value) {
        if (this.log) {
            value = DasMath.log10(value);
        }
        return (value - this.minimum) / (this.maximum - this.minimum);
    }

    public Units getUnits() {
        return this.units;
    }

    public DatumRange getDatumRange() {
        return this.range;
    }

    public void setUnits(Units newUnits) {
        if (this.units.equals(newUnits)) {
            return;
        }
        this.minimum = this.units.convertDoubleTo(newUnits, this.minimum);
        this.maximum = this.units.convertDoubleTo(newUnits, this.maximum);
        this.units = newUnits;
        this.clearHistory();
    }

    public void setMinimum(Datum min) {
        Datum max;
        Datum datum = max = this.pendingMax != null ? this.pendingMax : this.range.max();
        if (min.le(max)) {
            this.setRange(new DatumRange(min, max));
        } else {
            this.pendingMin = min;
        }
    }

    public void setMaximum(Datum max) {
        Datum min;
        Datum datum = min = this.pendingMin != null ? this.pendingMin : this.range.min();
        if (min.le(max)) {
            this.setRange(new DatumRange(min, max));
        } else {
            this.pendingMax = max;
        }
    }

    private void reportHistory() {
        Logger log = DasLogger.getLogger(DasLogger.GUI_LOG);
        log.finest("history: " + this.history.size());
        for (int i = 0; i < this.history.size(); ++i) {
            log.finest("   " + this.history.get(i));
        }
        log.finest("forwardHistory: " + this.forwardHistory.size());
        log.finest("-------------");
    }

    protected void clearHistory() {
        ArrayList oldHistory = new ArrayList(this.history);
        this.history.removeAllElements();
        this.forwardHistory.removeAllElements();
        this.firePropertyChange("history", oldHistory, this.history);
    }

    public void addToFavorites(DatumRange range) {
        if (this.favorites == null) {
            this.favorites = new ArrayList();
        }
        ArrayList oldFavorites = new ArrayList(this.favorites);
        this.favorites.add(range);
        this.firePropertyChange("favorites", oldFavorites, this.favorites);
    }

    public List getFavorites() {
        if (this.favorites == null) {
            return new ArrayList();
        }
        return new ArrayList(this.favorites);
    }

    public List getHistory() {
        if (this.history == null) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList(this.history);
        Collections.reverse(result);
        return result.subList(0, Math.min(result.size(), 10));
    }

    public void setRange(DatumRange range) {
        this.pendingMin = null;
        this.pendingMax = null;
        this.setRange(range, true);
    }

    public void setRange(double min, double max) {
        DatumRange newRange = this.log ? new DatumRange(DasMath.exp10(min), DasMath.exp10(max), this.units) : new DatumRange(min, max, this.units);
        this.setRange(newRange, true);
    }

    private void setRange(DatumRange range, boolean pushHistory) {
        if (!range.getUnits().isConvertableTo(this.units)) {
            throw new IllegalArgumentException("units may not be changed");
        }
        if (pushHistory && !this.valueIsAdjusting) {
            ArrayList oldHistory = new ArrayList(this.history);
            if (this.history.size() == 0 || !this.range.equals(this.history.peek())) {
                this.history.push(this.range);
            }
            DasLogger.getLogger(DasLogger.GUI_LOG).fine("push history: " + range);
            this.forwardHistory.removeAllElements();
            this.firePropertyChange("history", new ArrayList(), new ArrayList(this.history));
        }
        this.range = range;
        double oldMin = this.minimum;
        double oldMax = this.maximum;
        this.minimum = range.min().doubleValue(this.units);
        this.maximum = range.max().doubleValue(this.units);
        if (this.log) {
            this.minimum = DasMath.log10(this.minimum);
            this.maximum = DasMath.log10(this.maximum);
        }
        this.fireUpdate();
        if (this.minimum != oldMin) {
            this.firePropertyChange("minimum", oldMin, this.minimum);
        }
        if (this.maximum != oldMax) {
            this.firePropertyChange("maximum", oldMax, this.maximum);
        }
    }

    public void setRangePrev() {
        this.reportHistory();
        if (!this.history.isEmpty()) {
            this.forwardHistory.push(this.range);
            DatumRange newRange = (DatumRange)this.history.pop();
            this.setRange(newRange, false);
            this.firePropertyChange("history", null, new ArrayList(this.history));
        }
    }

    public void setRangeForward() {
        this.reportHistory();
        if (!this.forwardHistory.isEmpty()) {
            ArrayList oldHistory = new ArrayList(this.history);
            this.history.push(this.range);
            DatumRange h = (DatumRange)this.forwardHistory.pop();
            this.setRange(h, false);
            this.firePropertyChange("history", oldHistory, this.history);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeDelegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addUpdateListener(DasUpdateListener l) {
        this.listenerList.add(DasUpdateListener.class, l);
    }

    public void removeUpdateListener(DasUpdateListener l) {
        this.listenerList.remove(DasUpdateListener.class, l);
    }

    protected void fireUpdate() {
        Object[] listeners = this.listenerList.getListenerList();
        DasUpdateEvent e = new DasUpdateEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DasUpdateListener.class) continue;
            ((DasUpdateListener)listeners[i + 1]).update(e);
        }
    }

    protected void popHistory(int ipop) {
        for (int i = 0; i < ipop; ++i) {
            this.history.pop();
        }
    }

    public static DataRange getAnimationDataRange(DatumRange range, boolean log) {
        return new Animation(range, log);
    }

    protected DasAxis.Lock mutatorLock() {
        return new DasAxis.Lock(){
            DatumRange orig;
            {
                this.orig = DataRange.this.range;
            }

            public void lock() {
                if (DataRange.this.valueIsAdjusting) {
                    System.err.println("lock is already set!");
                }
                DataRange.this.valueIsAdjusting = true;
            }

            public void unlock() {
                DataRange.this.valueIsAdjusting = false;
                if (DataRange.this.history.size() == 0 || !this.orig.equals(DataRange.this.history.peek())) {
                    DataRange.this.history.push(this.orig);
                }
                if (!DataRange.this.range.equals(this.orig)) {
                    DataRange.this.firePropertyChange(PROPERTY_DATUMRANGE, this.orig, DataRange.this.range);
                }
            }
        };
    }

    public boolean valueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public static class Animation
    extends DataRange {
        private double minimum;
        private double maximum;

        public Animation(DatumRange range, boolean log) {
            super(null, range.min(), range.max(), log);
        }

        protected void fireUpdate() {
        }

        public void setRange(double min, double max) {
            this.minimum = min;
            this.maximum = max;
        }

        public double getMinimum() {
            return this.minimum;
        }

        public double getMaximum() {
            return this.maximum;
        }
    }
}

