/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.event.MouseInputAdapter;
import org.das2.CancelledOperationException;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasProperties;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dasml.FormBase;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.event.BoxZoomMouseModule;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DisplayDataMouseModule;
import org.das2.event.HorizontalRangeSelectorMouseModule;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.VerticalRangeSelectorMouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRendererUpdateEvent;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.das2.graph.dnd.TransferableRenderer;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.monitor.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasPlot
extends DasCanvasComponent
implements DataSetConsumer {
    public static String PROP_TITLE = "title";
    protected DataSetDescriptor dataSetDescriptor;
    protected DataSet Data;
    private DasAxis xAxis;
    private DasAxis yAxis;
    DasAxis.Memento xmemento;
    DasAxis.Memento ymemento;
    protected String offsetTime = "";
    protected String plotTitle = "";
    protected double[] psym_x;
    protected double[] psym_y;
    protected RebinListener rebinListener = new RebinListener();
    protected PropertyChangeListener ticksListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (DasPlot.this.drawGrid || DasPlot.this.drawMinorGrid) {
                // empty if block
            }
        }
    };
    DnDSupport dndSupport;
    static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private JMenuItem editRendererMenuItem;
    boolean cacheImageValid = false;
    BufferedImage cacheImage;
    Rectangle cacheImageBounds;
    boolean preview = false;
    private int repaintCount = 0;
    private int paintComponentCount = 0;
    protected Renderer focusRenderer = null;
    public static final String PROP_FOCUSRENDERER = "focusRenderer";
    public Action DUMP_TO_FILE_ACTION = new AbstractAction("Dump Data Set to File"){

        public void actionPerformed(ActionEvent e) {
            if (DasPlot.this.renderers.isEmpty()) {
                return;
            }
            Renderer renderer = (Renderer)DasPlot.this.renderers.get(0);
            JFileChooser chooser = new JFileChooser();
            int result = chooser.showSaveDialog(DasPlot.this);
            if (result == 0) {
                File selected = chooser.getSelectedFile();
                try {
                    FileChannel out = new FileOutputStream(selected).getChannel();
                    DataSet ds = renderer.getDataSet();
                    if (ds instanceof TableDataSet) {
                        TableUtil.dumpToAsciiStream((TableDataSet)ds, out);
                    } else if (ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)ds, out);
                    }
                }
                catch (IOException ioe) {
                    DasExceptionHandler.handle(ioe);
                }
            }
        }
    };
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    List messages;
    List<LegendElement> legendElements;
    private List renderers = null;
    private boolean drawGrid = false;
    public static final String PROP_DRAWGRID = "drawGrid";
    private boolean drawMinorGrid;
    public static final String PROP_DRAWMINORGRID = "drawMinorGrid";
    protected boolean gridOver = true;
    public static final String PROP_GRIDOVER = "gridOver";
    protected boolean overSize = false;
    public static final String PROP_OVERSIZE = "overSize";

    public DasPlot(DasAxis xAxis, DasAxis yAxis) {
        this.addMouseListener(new MouseInputAdapter(){

            public void mousePressed(MouseEvent e) {
                if (DasPlot.this.editRendererMenuItem != null) {
                    int ir = DasPlot.this.findRendererAt(DasPlot.this.getX() + e.getX(), DasPlot.this.getY() + e.getY());
                    DasPlot.this.editRendererMenuItem.setText("Renderer Properties");
                    if (ir > -1) {
                        DasPlot.this.editRendererMenuItem.setEnabled(true);
                        Renderer r = (Renderer)DasPlot.this.renderers.get(ir);
                        if (r instanceof Displayable) {
                            Displayable d = (Displayable)((Object)r);
                            DasPlot.this.editRendererMenuItem.setIcon(d.getListIcon());
                        } else {
                            DasPlot.this.editRendererMenuItem.setIcon(null);
                        }
                        DasPlot.this.setFocusRenderer(r);
                    } else {
                        DasPlot.this.editRendererMenuItem.setEnabled(false);
                        DasPlot.this.editRendererMenuItem.setIcon(null);
                        DasPlot.this.setFocusRenderer(null);
                    }
                }
            }
        });
        this.setOpaque(false);
        this.renderers = new ArrayList();
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            xAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.addPropertyChangeListener(DasAxis.PROPERTY_DATUMRANGE, this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
            xAxis.addPropertyChangeListener(DasAxis.PROPERTY_TICKS, this.ticksListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            yAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            yAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            yAxis.addPropertyChangeListener(DasAxis.PROPERTY_DATUMRANGE, this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
            xAxis.addPropertyChangeListener(DasAxis.PROPERTY_TICKS, this.ticksListener);
        }
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            this.addDefaultMouseModules();
        }
    }

    public Renderer getFocusRenderer() {
        return this.focusRenderer;
    }

    public void setFocusRenderer(Renderer focusRenderer) {
        Renderer oldFocusRenderer = this.focusRenderer;
        this.focusRenderer = focusRenderer;
        this.firePropertyChange(PROP_FOCUSRENDERER, oldFocusRenderer, focusRenderer);
    }

    private void drawLegend(Graphics2D graphics) {
        Rectangle mrect;
        int em = (int)this.getEmSize();
        Color backColor = GraphUtil.getRicePaperColor();
        Rectangle boundRect = null;
        em = (int)this.getEmSize();
        int msgx = this.xAxis.getColumn().getDMiddle() + em;
        int msgy = this.yAxis.getRow().getDMinimum() + em;
        int maxIconWidth = 0;
        for (int i = 0; i < this.legendElements.size(); ++i) {
            LegendElement le = this.legendElements.get(i);
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(graphics, String.valueOf(le.label));
            mrect = gtr.getBounds();
            mrect.translate(msgx, msgy);
            maxIconWidth = Math.max(maxIconWidth, le.icon.getIconWidth());
            mrect.height = Math.max(mrect.height, le.icon.getIconHeight());
            if (boundRect == null) {
                boundRect = mrect;
            } else {
                boundRect.add(mrect);
            }
            msgy = (int)((double)msgy + mrect.getHeight());
        }
        mrect = new Rectangle(boundRect);
        int iconColumnWidth = maxIconWidth + em / 4;
        mrect.width += iconColumnWidth;
        boundRect.x = mrect.x = this.xAxis.getColumn().getDMaximum() - em - mrect.width;
        graphics.setColor(backColor);
        graphics.fillRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
        graphics.setColor(this.getForeground());
        graphics.drawRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
        msgx = this.xAxis.getColumn().getDMaximum() - boundRect.width - em;
        msgy = this.yAxis.getRow().getDMinimum() + em;
        for (int i = 0; i < this.legendElements.size(); ++i) {
            LegendElement le = this.legendElements.get(i);
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(graphics, String.valueOf(le.label));
            mrect = gtr.getBounds();
            mrect.translate(msgx, msgy);
            gtr.draw(graphics, msgx, msgy);
            Rectangle imgBounds = new Rectangle(msgx - (le.icon.getIconWidth() + em / 4), msgy - (int)(mrect.getHeight() / 2.0 + (double)(le.icon.getIconHeight() / 2)), le.icon.getIconWidth(), le.icon.getIconHeight());
            graphics.drawImage(le.icon.getImage(), imgBounds.x, imgBounds.y, null);
            msgy = (int)((double)msgy + mrect.getHeight());
            mrect.add(imgBounds);
            le.bounds = mrect;
        }
    }

    private void drawMessages(Graphics2D graphics) {
        Font font0 = graphics.getFont();
        int msgem = (int)Math.max(8.0f, font0.getSize2D() / 2.0f);
        graphics.setFont(font0.deriveFont((float)msgem));
        int em = (int)this.getEmSize();
        int msgx = this.xAxis.getColumn().getDMinimum() + em;
        int msgy = this.yAxis.getRow().getDMinimum() + em;
        Color warnColor = new Color(255, 255, 100, 200);
        Color errorColor = new Color(255, 140, 140, 200);
        for (int i = 0; i < this.messages.size(); ++i) {
            MessageDescriptor message = (MessageDescriptor)this.messages.get(i);
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(graphics, String.valueOf(message.text));
            Rectangle mrect = gtr.getBounds();
            mrect.translate(msgx, msgy);
            Color backColor = GraphUtil.getRicePaperColor();
            if (message.messageType == 1) {
                backColor = warnColor;
            } else if (message.messageType == 2) {
                backColor = errorColor;
            }
            graphics.setColor(backColor);
            graphics.fillRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
            graphics.setColor(this.getForeground());
            graphics.drawRoundRect(mrect.x - em / 4, mrect.y, mrect.width + em / 2, mrect.height, 5, 5);
            gtr.draw(graphics, msgx, msgy);
            message.bounds = mrect;
            msgy = (int)((double)msgy + (gtr.getHeight() + (double)(msgem / 2)));
        }
    }

    private void maybeDrawGrid(Graphics2D plotGraphics) {
        DatumVector yticks;
        DatumVector xticks;
        Color gridColor = new Color(128, 128, 128, 70);
        Color minorGridColor = new Color(128, 128, 128, 40);
        if (this.drawMinorGrid) {
            xticks = null;
            yticks = null;
            if (this.getXAxis().isVisible()) {
                xticks = this.getXAxis().getTickV().getMinorTicks();
            }
            if (this.getYAxis().isVisible()) {
                yticks = this.getYAxis().getTickV().getMinorTicks();
            }
            plotGraphics.setColor(minorGridColor);
            this.drawGrid(plotGraphics, xticks, yticks);
        }
        if (this.drawGrid) {
            xticks = null;
            yticks = null;
            if (this.getXAxis().isVisible()) {
                xticks = this.getXAxis().getTickV().getMajorTicks();
            }
            if (this.getYAxis().isVisible()) {
                yticks = this.getYAxis().getTickV().getMajorTicks();
            }
            plotGraphics.setColor(gridColor);
            this.drawGrid(plotGraphics, xticks, yticks);
        }
    }

    private void drawCacheImage(Graphics2D plotGraphics) {
        this.messages = new ArrayList();
        this.legendElements = new ArrayList<LegendElement>();
        if (!this.gridOver) {
            this.maybeDrawGrid(plotGraphics);
        }
        this.drawContent(plotGraphics);
        boolean noneActive = true;
        for (int i = 0; i < this.renderers.size(); ++i) {
            Renderer rend = (Renderer)this.renderers.get(i);
            if (!rend.isActive()) continue;
            logger.finest("rendering #" + i + ": " + rend);
            rend.render(plotGraphics, this.xAxis, this.yAxis, new NullProgressMonitor());
            noneActive = false;
        }
        if (this.gridOver) {
            this.maybeDrawGrid(plotGraphics);
        }
        if (this.renderers.size() == 0) {
            this.postMessage(null, "(no renderers)", 0, null, null);
            logger.fine("dasPlot has no renderers");
        } else if (noneActive) {
            this.postMessage(null, "(no active renderers)", 0, null, null);
        }
    }

    public int findRendererAt(int x, int y) {
        int result;
        int i;
        for (i = 0; this.messages != null && i < this.messages.size(); ++i) {
            MessageDescriptor message = (MessageDescriptor)this.messages.get(i);
            if (!message.bounds.contains(x, y) || message.renderer == null || (result = this.renderers.indexOf(message.renderer)) == -1) continue;
            return result;
        }
        for (i = 0; this.legendElements != null && i < this.legendElements.size(); ++i) {
            LegendElement legendElement = this.legendElements.get(i);
            if (!legendElement.bounds.contains(x, y) || legendElement.renderer == null || (result = this.renderers.indexOf(legendElement.renderer)) == -1) continue;
            return result;
        }
        for (i = this.renderers.size() - 1; i >= 0; --i) {
            Renderer rend = (Renderer)this.renderers.get(i);
            if (!rend.isActive() || !rend.acceptContext(x, y)) continue;
            return i;
        }
        return -1;
    }

    private Action getEditAction() {
        return new AbstractAction("Renderer Properties"){

            public void actionPerformed(ActionEvent e) {
                Point p = DasPlot.this.getDasMouseInputAdapter().getMousePressPosition();
                int i = DasPlot.this.findRendererAt(p.x + DasPlot.this.getX(), p.y + DasPlot.this.getY());
                if (i > -1) {
                    Renderer rend = DasPlot.this.getRenderer(i);
                    PropertyEditor editor = new PropertyEditor(rend);
                    editor.showDialog(DasPlot.this);
                }
            }
        };
    }

    private void addDefaultMouseModules() {
        HorizontalRangeSelectorMouseModule hrs = new HorizontalRangeSelectorMouseModule(this, this.xAxis);
        this.mouseAdapter.addMouseModule(hrs);
        hrs.addDataRangeSelectionListener(this.xAxis);
        VerticalRangeSelectorMouseModule vrs = new VerticalRangeSelectorMouseModule(this, this.yAxis);
        this.mouseAdapter.addMouseModule(vrs);
        vrs.addDataRangeSelectionListener(this.yAxis);
        MouseModule x = CrossHairMouseModule.create(this);
        this.mouseAdapter.addMouseModule(x);
        this.mouseAdapter.setSecondaryModule(new ZoomPanMouseModule((DasCanvasComponent)this, this.getXAxis(), this.getYAxis()));
        this.mouseAdapter.setPrimaryModule(x);
        this.mouseAdapter.addMouseModule(new BoxZoomMouseModule(this, null, this.getXAxis(), this.getYAxis()));
        x = new MouseModule(this, new LengthDragRenderer(this, null, null), "Length");
        this.mouseAdapter.addMouseModule(x);
        x = new DisplayDataMouseModule(this);
        this.mouseAdapter.addMouseModule(x);
        this.editRendererMenuItem = new JMenuItem(this.getEditAction());
        this.getDasMouseInputAdapter().addMenuItem(this.editRendererMenuItem);
        if (DasApplication.hasAllPermission()) {
            JMenuItem dumpMenuItem = new JMenuItem(this.DUMP_TO_FILE_ACTION);
            this.mouseAdapter.addMenuItem(dumpMenuItem);
        }
    }

    public DataSet getDataSet() {
        return this.Data;
    }

    public DataSet getConsumedDataSet() {
        return this.Data;
    }

    public DataSet getData() {
        return this.Data;
    }

    public void setXAxis(DasAxis xAxis) {
        DasAxis oldValue = this.xAxis;
        Container parent = this.getParent();
        if (this.xAxis != null) {
            DasProperties.getLogger().fine("setXAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.xAxis);
            }
            xAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.removePropertyChangeListener(DasAxis.PROPERTY_DATUMRANGE, this.rebinListener);
            xAxis.removePropertyChangeListener("log", this.rebinListener);
            xAxis.removePropertyChangeListener(DasAxis.PROPERTY_TICKS, this.ticksListener);
        }
        this.xAxis = xAxis;
        if (xAxis != null) {
            if (!xAxis.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            if (parent != null) {
                parent.add(this.xAxis);
                parent.validate();
            }
            xAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            xAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            xAxis.addPropertyChangeListener(DasAxis.PROPERTY_DATUMRANGE, this.rebinListener);
            xAxis.addPropertyChangeListener("log", this.rebinListener);
            xAxis.addPropertyChangeListener(DasAxis.PROPERTY_TICKS, this.ticksListener);
        }
        if (xAxis != oldValue) {
            this.firePropertyChange("xAxis", oldValue, xAxis);
        }
    }

    public void setYAxis(DasAxis yAxis) {
        DasAxis oldValue = this.yAxis;
        logger.fine("setYAxis(" + yAxis.getName() + "), removes " + this.yAxis);
        Container parent = this.getParent();
        if (this.yAxis != null) {
            DasProperties.getLogger().fine("setYAxis upsets the dmia");
            if (parent != null) {
                parent.remove(this.yAxis);
            }
            this.yAxis.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.yAxis.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.yAxis.removePropertyChangeListener(DasAxis.PROPERTY_DATUMRANGE, this.rebinListener);
            this.yAxis.removePropertyChangeListener("log", this.rebinListener);
            this.yAxis.removePropertyChangeListener(DasAxis.PROPERTY_TICKS, this.ticksListener);
        }
        this.yAxis = yAxis;
        if (yAxis != null) {
            if (yAxis.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            yAxis.setRow(this.getRow());
            yAxis.setColumn(this.getColumn());
            if (parent != null) {
                parent.add(this.yAxis);
                parent.validate();
            }
            yAxis.addPropertyChangeListener("dataMinimum", this.rebinListener);
            yAxis.addPropertyChangeListener("dataMaximum", this.rebinListener);
            yAxis.addPropertyChangeListener(DasAxis.PROPERTY_DATUMRANGE, this.rebinListener);
            yAxis.addPropertyChangeListener("log", this.rebinListener);
            yAxis.addPropertyChangeListener(DasAxis.PROPERTY_TICKS, this.ticksListener);
        }
        if (yAxis != oldValue) {
            this.firePropertyChange("yAxis", oldValue, yAxis);
        }
    }

    protected void updateImmediately() {
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        logger.finer("DasPlot.updateImmediately");
        for (int i = 0; i < this.renderers.size(); ++i) {
            Renderer rend = (Renderer)this.renderers.get(i);
            rend.update();
        }
    }

    protected AffineTransform getAffineTransform(DasAxis xAxis, DasAxis yAxis) {
        if (this.xmemento == null) {
            logger.fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform at = new AffineTransform();
        at = xAxis.getAffineTransform(this.xmemento, at);
        at = yAxis.getAffineTransform(this.ymemento, at);
        return at;
    }

    private boolean isIdentity(AffineTransform at) {
        return at.isIdentity() || Math.abs(at.getScaleX() - 1.0) < 0.001 && Math.abs(at.getScaleY() - 1.0) < 0.001 && Math.abs(at.getTranslateX()) < 0.001 && Math.abs(at.getTranslateY()) < 0.001;
    }

    private void paintInvalidScreen(Graphics atGraphics, AffineTransform at) {
        Color c = GraphUtil.getRicePaperColor();
        atGraphics.setColor(c);
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        atGraphics.fillRect(x - 1, y - 1, this.getWidth(), this.getHeight());
        boolean debug = false;
        logger.finest(" using cacheImage with ricepaper to invalidate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics1) {
        Object atGraphics;
        Shape saveClip;
        if (!this.getCanvas().isPrintingThread() && !EventQueue.isDispatchThread()) {
            throw new RuntimeException("not event thread: " + Thread.currentThread().getName());
        }
        logger.finer("entering DasPlot.paintComponent");
        if (this.getCanvas().isPrintingThread()) {
            logger.fine("* printing thread *");
        }
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        int xSize = this.getColumn().getDMaximum() - x;
        int ySize = this.getRow().getDMaximum() - y;
        if (this.getCanvas().isPrintingThread()) {
            saveClip = graphics1.getClip();
            graphics1.setClip(null);
        } else {
            saveClip = null;
        }
        logger.fine("DasPlot clip=" + graphics1.getClip() + " @ " + this.getX() + "," + this.getY());
        Rectangle clip = graphics1.getClipBounds();
        if (clip != null && clip.y + this.getY() >= y + ySize) {
            logger.finer("returning because clip indicates nothing to be done.");
            return;
        }
        boolean disableImageCache = false;
        Graphics2D graphics = (Graphics2D)graphics1;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.translate(-this.getX(), -this.getY());
        if (this.cacheImageValid && !this.getCanvas().isPrintingThread() && !disableImageCache) {
            atGraphics = (Graphics2D)graphics.create();
            AffineTransform at = this.getAffineTransform(this.xAxis, this.yAxis);
            if (at == null || !this.preview && !this.isIdentity(at)) {
                ((Graphics)atGraphics).drawImage(this.cacheImage, this.cacheImageBounds.x, this.cacheImageBounds.y, this.cacheImageBounds.width, this.cacheImageBounds.height, this);
                this.paintInvalidScreen((Graphics)atGraphics, at);
            } else {
                DecimalFormat nf = new DecimalFormat("0.00");
                String atDesc = GraphUtil.getATScaleTranslateString(at);
                if (!at.isIdentity()) {
                    logger.finest(" using cacheImage w/AT " + atDesc);
                    ((Graphics2D)atGraphics).transform(at);
                } else {
                    logger.finest(" using cacheImage " + this.cacheImageBounds + " " + this.xmemento + " " + this.ymemento);
                }
                ((Graphics)atGraphics).drawImage(this.cacheImage, this.cacheImageBounds.x, this.cacheImageBounds.y, this.cacheImageBounds.width, this.cacheImageBounds.height, this);
            }
            ((Graphics)atGraphics).dispose();
        } else {
            atGraphics = this;
            synchronized (atGraphics) {
                Graphics2D plotGraphics;
                if (this.getCanvas().isPrintingThread() || disableImageCache) {
                    plotGraphics = (Graphics2D)graphics.create(x - 1, y - 1, xSize + 2, ySize + 2);
                    this.cacheImageBounds = new Rectangle();
                    this.cacheImageBounds.width = this.getWidth();
                    this.cacheImageBounds.height = this.getHeight();
                    this.cacheImageBounds.x = x - 1;
                    this.cacheImageBounds.y = y - 1;
                    logger.finest(" printing thread, drawing");
                } else {
                    if (this.overSize) {
                        this.cacheImageBounds = new Rectangle();
                        this.cacheImageBounds.width = 16 * this.getWidth() / 10;
                        this.cacheImageBounds.height = this.getHeight();
                        this.cacheImage = new BufferedImage(this.cacheImageBounds.width, this.cacheImageBounds.height, 6);
                        this.cacheImageBounds.x = x - 3 * this.getWidth() / 10;
                        this.cacheImageBounds.y = y - 1;
                    } else {
                        this.cacheImageBounds = new Rectangle();
                        this.cacheImageBounds.width = this.getWidth();
                        this.cacheImageBounds.height = this.getHeight();
                        this.cacheImage = new BufferedImage(this.cacheImageBounds.width, this.cacheImageBounds.height, 6);
                        this.cacheImageBounds.x = x - 1;
                        this.cacheImageBounds.y = y - 1;
                    }
                    plotGraphics = (Graphics2D)this.cacheImage.getGraphics();
                    plotGraphics.setBackground(this.getBackground());
                    plotGraphics.setColor(this.getForeground());
                    plotGraphics.setRenderingHints(DasProperties.getRenderingHints());
                    if (this.overSize) {
                        plotGraphics.translate(x - this.cacheImageBounds.x - 1, y - this.cacheImageBounds.y - 1);
                    }
                    logger.finest(" rebuilding cacheImage");
                }
                plotGraphics.translate(-x + 1, -y + 1);
                this.drawCacheImage(plotGraphics);
            }
            if (!disableImageCache && !this.getCanvas().isPrintingThread()) {
                this.cacheImageValid = true;
                graphics.drawImage(this.cacheImage, this.cacheImageBounds.x, this.cacheImageBounds.y, this.cacheImageBounds.width, this.cacheImageBounds.height, this);
                this.xmemento = this.xAxis.getMemento();
                this.ymemento = this.yAxis.getMemento();
                logger.finest("recalc cacheImage, xmemento=" + this.xmemento + " ymemento=" + this.ymemento);
            }
        }
        graphics.setColor(this.getForeground());
        graphics.drawRect(x - 1, y - 1, xSize + 1, ySize + 1);
        if (this.plotTitle != null && this.plotTitle.length() != 0) {
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setAlignment(1);
            gtr.setString(graphics, this.plotTitle);
            int titleWidth = (int)gtr.getWidth();
            int titleX = x + (xSize - titleWidth) / 2;
            int titleY = y - (int)gtr.getDescent() - (int)gtr.getAscent() / 2;
            gtr.draw(graphics, titleX, titleY);
        }
        Font font0 = graphics.getFont();
        if (this.messages.size() > 0) {
            this.drawMessages(graphics);
        }
        if (this.legendElements.size() > 0) {
            this.drawLegend(graphics);
        }
        graphics.setFont(font0);
        graphics.translate(this.getX(), this.getY());
        this.getDasMouseInputAdapter().paint(graphics);
        if (saveClip != null) {
            graphics1.setClip(saveClip);
        }
    }

    public void postMessage(Renderer renderer, String message, int messageType, Datum x, Datum y) {
        this.messages.add(new MessageDescriptor(renderer, message, messageType, x, y));
    }

    public void postException(Renderer renderer, Exception exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = String.valueOf(exception);
        }
        int errorLevel = 2;
        if (exception instanceof CancelledOperationException) {
            errorLevel = 0;
            if (exception.getMessage() == null) {
                message = "Operation Cancelled";
            }
        }
        this.postMessage(renderer, message, errorLevel, null, null);
    }

    public void addToLegend(Renderer renderer, ImageIcon icon, int pos, String message) {
        this.legendElements.add(new LegendElement(icon, renderer, message));
    }

    private void drawGrid(Graphics2D g, DatumVector xticks, DatumVector yticks) {
        int i;
        int xmin = this.cacheImageBounds.x;
        int xmax = this.cacheImageBounds.x + this.cacheImageBounds.width;
        int ymin = this.cacheImageBounds.y;
        int ymax = this.cacheImageBounds.y + this.cacheImageBounds.height;
        if (yticks != null && yticks.getUnits().isConvertableTo(this.yAxis.getUnits())) {
            for (i = 0; i < yticks.getLength(); ++i) {
                int y = (int)this.yAxis.transform(yticks.get(i));
                g.drawLine(xmin, y, xmax, y);
            }
        }
        if (xticks != null && xticks.getUnits().isConvertableTo(this.xAxis.getUnits())) {
            for (i = 0; i < xticks.getLength(); ++i) {
                int x = (int)this.xAxis.transform(xticks.get(i));
                g.drawLine(x, ymin, x, ymax);
            }
        }
    }

    protected void drawContent(Graphics2D g) {
    }

    public void resize() {
        logger.fine("resize DasPlot");
        if (this.isDisplayable()) {
            Rectangle oldBounds = this.getBounds();
            Rectangle bounds = new Rectangle();
            bounds.x = this.getColumn().getDMinimum() - 1;
            bounds.y = this.getRow().getDMinimum() - 1;
            bounds.width = this.getColumn().getDMaximum() - bounds.x + 1;
            bounds.height = this.getRow().getDMaximum() - bounds.y + 1;
            if (!this.getTitle().equals("")) {
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                gtr.setString(this.getFont(), this.getTitle());
                int titleHeight = (int)gtr.getHeight() + (int)gtr.getAscent() / 2;
                bounds.y -= titleHeight;
                bounds.height += titleHeight;
            }
            logger.fine("DasPlot setBounds " + bounds);
            if (!oldBounds.equals(bounds)) {
                this.invalidateCacheImage();
            }
            this.setBounds(bounds);
        }
    }

    public void setTitle(String t) {
        String oldValue = this.plotTitle;
        this.plotTitle = t;
        if (this.getCanvas() != null) {
            FontMetrics fm = this.getFontMetrics(this.getCanvas().getFont());
            int titleHeight = fm.getHeight() + fm.getHeight() / 2;
            this.resize();
            this.invalidateCacheImage();
        }
        if (t != oldValue) {
            this.firePropertyChange(PROP_TITLE, oldValue, t);
        }
    }

    public String getTitle() {
        return this.plotTitle;
    }

    public DasAxis getXAxis() {
        return this.xAxis;
    }

    public DasAxis getYAxis() {
        return this.yAxis;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dataSetDescriptor;
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dataSetDescriptor = dataSetDescriptor;
        this.markDirty();
    }

    public void setData(DataSet ds) {
        this.Data = ds;
        this.markDirty();
    }

    protected void installComponent() {
        super.installComponent();
        if (this.xAxis != null) {
            this.getCanvas().add(this.xAxis, this.getRow(), this.getColumn());
        }
        if (this.yAxis != null) {
            this.getCanvas().add(this.yAxis, this.getRow(), this.getColumn());
        }
        Renderer[] r = this.getRenderers();
        for (int index = 0; index < r.length; ++index) {
            r[index].installRenderer();
        }
        if (!"true".equals(DasApplication.getProperty("java.awt.headless", "false"))) {
            this.dndSupport = new PlotDnDSupport(this.getCanvas().dndSupport);
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
        if (this.xAxis != null && this.xAxis.getCanvas() != null) {
            this.xAxis.getCanvas().remove(this.xAxis);
        }
        if (this.yAxis != null && this.yAxis.getCanvas() != null) {
            this.yAxis.getCanvas().remove(this.yAxis);
        }
        Renderer[] r = this.getRenderers();
        for (int index = 0; index < r.length; ++index) {
            r[index].uninstallRenderer();
        }
    }

    public void addRenderer(Renderer rend) {
        logger.fine("addRenderer(" + rend + ")");
        if (rend.parent != null) {
            rend.parent.removeRenderer(rend);
        }
        this.renderers.add(rend);
        rend.parent = this;
        if (this.getCanvas() != null) {
            rend.installRenderer();
        }
        rend.update();
        this.invalidateCacheImage();
    }

    public void removeRenderer(Renderer rend) {
        if (this.getCanvas() != null) {
            rend.uninstallRenderer();
        }
        this.renderers.remove(rend);
        rend.parent = null;
        this.invalidateCacheImage();
    }

    public static DasPlot createDummyPlot() {
        DasAxis xAxis = new DasAxis(Datum.create(-10), Datum.create(10), 2);
        DasAxis yAxis = new DasAxis(Datum.create(-10), Datum.create(10), 3);
        DasPlot result = new DasPlot(xAxis, yAxis);
        return result;
    }

    public static DasPlot createPlot(DatumRange xrange, DatumRange yrange) {
        DasAxis xAxis = new DasAxis(xrange, 2);
        DasAxis yAxis = new DasAxis(yrange, 3);
        DasPlot result = new DasPlot(xAxis, yAxis);
        return result;
    }

    public Renderer getRenderer(int index) {
        return (Renderer)this.renderers.get(index);
    }

    public Renderer[] getRenderers() {
        return this.renderers.toArray(new Renderer[0]);
    }

    public static DasPlot processPlotElement(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        String name = element.getAttribute("name");
        DasRow row = (DasRow)form.checkValue(element.getAttribute("row"), DasRow.class, "<row>");
        DasColumn column = (DasColumn)form.checkValue(element.getAttribute("column"), DasColumn.class, "<column>");
        DasAxis xAxis = null;
        DasAxis yAxis = null;
        DasColorBar colorbar = null;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("xAxis")) {
                xAxis = DasPlot.processXAxisElement((Element)node, row, column, form);
                continue;
            }
            if (node.getNodeName().equals("yAxis")) {
                yAxis = DasPlot.processYAxisElement((Element)node, row, column, form);
                continue;
            }
            if (!node.getNodeName().equals("zAxis")) continue;
            colorbar = DasPlot.processZAxisElement((Element)node, row, column, form);
        }
        if (xAxis == null) {
            xAxis = (DasAxis)form.checkValue(element.getAttribute("xAxis"), DasAxis.class, "<axis> or <timeaxis>");
        }
        if (yAxis == null) {
            yAxis = (DasAxis)form.checkValue(element.getAttribute("yAxis"), DasAxis.class, "<axis> or <timeaxis>");
        }
        DasPlot plot = new DasPlot(xAxis, yAxis);
        if (element.getNodeName().equals("spectrogram")) {
            SpectrogramRenderer rend = new SpectrogramRenderer(null, colorbar);
            plot.addRenderer(rend);
        }
        plot.setTitle(element.getAttribute("title"));
        plot.setDasName(name);
        plot.setRow(row);
        plot.setColumn(column);
        DasApplication app = form.getDasApplication();
        NameContext nc = app.getNameContext();
        nc.put(name, plot);
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("renderers")) continue;
            DasPlot.processRenderersElement((Element)node, plot, form);
        }
        return plot;
    }

    private static DasAxis processXAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis axis = DasAxis.processAxisElement(e, form);
                if (!axis.isHorizontal()) {
                    axis.setOrientation(2);
                }
                return axis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis axis = DasAxis.processTimeaxisElement(e, form);
                if (!axis.isHorizontal()) {
                    axis.setOrientation(2);
                }
                return axis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis axis = DasAxis.processAttachedaxisElement(e, form);
            if (!axis.isHorizontal()) {
                axis.setOrientation(2);
            }
            return axis;
        }
        return null;
    }

    private static DasAxis processYAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (node.getNodeName().equals("axis")) {
                DasAxis axis = DasAxis.processAxisElement(e, form);
                if (axis.isHorizontal()) {
                    axis.setOrientation(3);
                }
                return axis;
            }
            if (node.getNodeName().equals("timeaxis")) {
                DasAxis axis = DasAxis.processTimeaxisElement(e, form);
                if (axis.isHorizontal()) {
                    axis.setOrientation(3);
                }
                return axis;
            }
            if (!node.getNodeName().equals("attachedaxis")) continue;
            DasAxis axis = DasAxis.processAttachedaxisElement(e, form);
            if (axis.isHorizontal()) {
                axis.setOrientation(3);
            }
            return axis;
        }
        return null;
    }

    private static DasColorBar processZAxisElement(Element element, DasRow row, DasColumn column, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element) || !node.getNodeName().equals("colorbar")) continue;
            return DasColorBar.processColorbarElement((Element)node, form);
        }
        return null;
    }

    private static void processRenderersElement(Element element, DasPlot parent, FormBase form) throws DasPropertyException, DasNameException, DasException, ParseException {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals("spectrogram")) {
                parent.addRenderer(SpectrogramRenderer.processSpectrogramElement((Element)node, parent, form));
                continue;
            }
            if (!node.getNodeName().equals("lineplot")) continue;
            parent.addRenderer(SymbolLineRenderer.processLinePlotElement((Element)node, parent, form));
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("plot");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("title", this.getTitle());
        Element xAxisChild = document.createElement("xAxis");
        Element xAxisElement = this.getXAxis().getDOMElement(document);
        xAxisElement.removeAttribute("orientation");
        if (xAxisElement.getAttribute("row").equals(this.getRow().getDasName())) {
            xAxisElement.removeAttribute("row");
        }
        if (xAxisElement.getAttribute("column").equals(this.getColumn().getDasName())) {
            xAxisElement.removeAttribute("column");
        }
        xAxisChild.appendChild(xAxisElement);
        element.appendChild(xAxisChild);
        Element yAxisChild = document.createElement("yAxis");
        Element yAxisElement = this.getYAxis().getDOMElement(document);
        yAxisElement.removeAttribute("orientation");
        if (yAxisElement.getAttribute("row").equals(this.getRow().getDasName())) {
            yAxisElement.removeAttribute("row");
        }
        if (yAxisElement.getAttribute("column").equals(this.getColumn().getDasName())) {
            yAxisElement.removeAttribute("column");
        }
        yAxisChild.appendChild(yAxisElement);
        element.appendChild(yAxisChild);
        Renderer[] renderers = this.getRenderers();
        if (renderers.length > 0) {
            Element renderersChild = document.createElement("renderers");
            for (int index = 0; index < renderers.length; ++index) {
                renderersChild.appendChild(renderers[index].getDOMElement(document));
            }
            element.appendChild(renderersChild);
        }
        return element;
    }

    public static DasPlot createNamedPlot(String name) {
        DasAxis xAxis = DasAxis.createNamedAxis(null);
        xAxis.setOrientation(2);
        DasAxis yAxis = DasAxis.createNamedAxis(null);
        yAxis.setOrientation(3);
        DasPlot plot = new DasPlot(xAxis, yAxis);
        if (name == null) {
            name = "plot_" + Integer.toHexString(System.identityHashCode(plot));
        }
        try {
            plot.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle(dne);
        }
        return plot;
    }

    public Shape getActiveRegion() {
        return this.getBounds();
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        if (existingEvent instanceof DasRendererUpdateEvent && newEvent instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent e1 = (DasRendererUpdateEvent)existingEvent;
            DasRendererUpdateEvent e2 = (DasRendererUpdateEvent)newEvent;
            if (e1.getRenderer() == e2.getRenderer()) {
                return existingEvent;
            }
            return null;
        }
        return super.coalesceEvents(existingEvent, newEvent);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof DasRendererUpdateEvent) {
            DasRendererUpdateEvent drue = (DasRendererUpdateEvent)e;
            drue.getRenderer().updateImmediately();
            this.cacheImageValid = false;
            this.repaint();
        } else {
            super.processEvent(e);
        }
    }

    public void repaint() {
        super.repaint();
        ++this.repaintCount;
    }

    public synchronized void invalidateCacheImage() {
        this.cacheImageValid = false;
        this.repaint();
    }

    void markDirty() {
        logger.finer("DasPlot.markDirty");
        super.markDirty();
        this.repaint();
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean drawGrid) {
        boolean bOld = this.drawGrid;
        this.drawGrid = drawGrid;
        this.invalidateCacheImage();
        this.repaint();
        if (bOld != drawGrid) {
            this.firePropertyChange(PROP_DRAWGRID, bOld, drawGrid);
        }
    }

    public boolean isDrawMinorGrid() {
        return this.drawMinorGrid;
    }

    public void setDrawMinorGrid(boolean newdrawMinorGrid) {
        boolean olddrawMinorGrid = this.drawMinorGrid;
        this.drawMinorGrid = newdrawMinorGrid;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_DRAWMINORGRID, olddrawMinorGrid, newdrawMinorGrid);
    }

    public boolean isGridOver() {
        return this.gridOver;
    }

    public void setGridOver(boolean gridOver) {
        boolean oldGridOver = this.gridOver;
        this.gridOver = gridOver;
        this.invalidateCacheImage();
        this.repaint();
        this.firePropertyChange(PROP_GRIDOVER, oldGridOver, gridOver);
    }

    public void setPreviewEnabled(boolean preview) {
        this.preview = preview;
    }

    public boolean isPreviewEnabled() {
        return this.preview;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.xAxis.setVisible(visible);
        this.yAxis.setVisible(visible);
    }

    public boolean isOverSize() {
        return this.overSize;
    }

    public void setOverSize(boolean overSize) {
        boolean oldOverSize = this.overSize;
        this.overSize = overSize;
        this.invalidateCacheImage();
        this.firePropertyChange(PROP_OVERSIZE, oldOverSize, overSize);
    }

    protected Rectangle getUpdateImageBounds() {
        int x = this.getColumn().getDMinimum();
        int y = this.getRow().getDMinimum();
        this.cacheImageBounds = new Rectangle();
        this.cacheImageBounds.width = 16 * this.getWidth() / 10;
        this.cacheImageBounds.height = this.getHeight();
        this.cacheImageBounds.x = x - 3 * this.getWidth() / 10;
        this.cacheImageBounds.y = y - 1;
        return this.cacheImageBounds;
    }

    protected Rectangle getCacheImageBounds() {
        return this.cacheImageBounds;
    }

    private class PlotDnDSupport
    extends DnDSupport {
        PlotDnDSupport(DnDSupport parent) {
            super(DasPlot.this, 3, parent);
        }

        public void drop(DropTargetDropEvent dtde) {
        }

        protected int canAccept(DataFlavor[] flavors, int x, int y, int action) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(TransferableRenderer.RENDERER_FLAVOR)) continue;
                return action;
            }
            return -1;
        }

        protected void done() {
        }

        protected boolean importData(Transferable t, int x, int y, int action) {
            boolean success = false;
            try {
                Renderer r = (Renderer)t.getTransferData(TransferableRenderer.RENDERER_FLAVOR);
                DasPlot.this.addRenderer(r);
                DasPlot.this.revalidate();
                success = true;
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return success;
        }

        protected Transferable getTransferable(int x, int y, int action) {
            return null;
        }

        protected void exportDone(Transferable t, int action) {
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            DasPlot.this.markDirty();
            DasPlot.this.update();
        }
    }

    private class LegendElement {
        ImageIcon icon;
        Renderer renderer;
        String label;
        Rectangle bounds;

        LegendElement(ImageIcon icon, Renderer rend, String label) {
            this.icon = icon;
            this.renderer = rend;
            this.label = label;
        }
    }

    private class MessageDescriptor {
        Renderer renderer;
        String text;
        int messageType;
        Datum x;
        Datum y;
        Rectangle bounds;

        MessageDescriptor(Renderer renderer, String text, int messageType, Datum x, Datum y) {
            this.renderer = renderer;
            this.text = text;
            this.messageType = messageType;
            this.x = x;
            this.y = y;
        }
    }
}

