/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.das2.graph.DataRange;
import org.das2.graph.TickVDescriptor;
import org.das2.graph.event.DasUpdateEvent;
import org.das2.graph.event.DasUpdateListener;
import org.das2.util.GrannyTextRenderer;

public class DasLabelAxis
extends DasAxis
implements DasUpdateListener {
    DecimalFormat nfy = null;
    DatumVector labels = null;
    double[] labelValues = null;
    Units labelUnits = null;
    int[] labelPositions = null;
    DatumFormatter df = null;
    int indexMinimum;
    int indexMaximum;
    private int outsidePadding = 5;
    private boolean floppyItemSpacing = false;

    private void setLabels(DatumVector labels) {
        if (labels.getLength() == 0) {
            throw new IllegalArgumentException("labels can not be a zero-length array!");
        }
        this.labels = labels;
        this.labelPositions = new int[labels.getLength()];
        this.indexMinimum = 0;
        this.indexMaximum = labels.getLength() - 1;
        this.labelUnits = labels.getUnits();
        this.labelValues = labels.toDoubleArray(this.labelUnits);
        this.df = DatumUtil.bestFormatter(labels);
    }

    public void setLabelFormatter(DatumFormatter df) {
        this.df = df;
    }

    protected DasLabelAxis(DatumVector labels, DataRange dataRange, int orientation) {
        super(dataRange, orientation);
        this.setLabels(labels);
        this.getDataRange().addUpdateListener(this);
    }

    public DasLabelAxis(DatumVector labels, int orientation) {
        super(labels.get(0), labels.get(labels.getLength() - 1), orientation, false);
        this.setLabels(labels);
        this.getDataRange().addUpdateListener(this);
    }

    public int[] getLabelPositions() {
        return this.labelPositions;
    }

    private void updateTickPositions() {
        if (this.isDisplayable()) {
            int min;
            double interItemSpacing;
            int size;
            int nlabel = this.indexMaximum - this.indexMinimum + 1;
            if (this.getOrientation() == 2) {
                size = this.getColumn().getWidth() - this.outsidePadding * 2;
                interItemSpacing = (float)size / (float)nlabel;
                if (!this.floppyItemSpacing) {
                    interItemSpacing = (int)interItemSpacing;
                }
                min = this.getColumn().getDMinimum() + this.outsidePadding + (int)(interItemSpacing / 2.0);
            } else {
                size = this.getRow().getHeight() - this.outsidePadding * 2;
                interItemSpacing = -1.0f * (float)size / (float)nlabel;
                if (!this.floppyItemSpacing) {
                    interItemSpacing = (int)interItemSpacing;
                }
                min = this.getRow().getDMaximum() - this.outsidePadding + (int)(interItemSpacing / 2.0);
            }
            for (int i = 0; i < this.labelPositions.length; ++i) {
                this.labelPositions[i] = min + (int)(interItemSpacing * (double)(i - this.indexMinimum + 0));
            }
            this.firePropertyChange("labelPositions", null, this.labelPositions);
        }
    }

    public Datum findTick(Datum xDatum, double direction, boolean minor) {
        return xDatum;
    }

    public void updateTickV() {
        this.updateTickPositions();
    }

    public TickVDescriptor getTickV() {
        TickVDescriptor result = new TickVDescriptor();
        result.units = this.getUnits();
        result.tickV = this.labels.getSubVector(this.indexMinimum, this.indexMaximum + 1);
        result.minorTickV = DatumVector.newDatumVector(new double[0], result.units);
        return result;
    }

    public double transform(double value, Units units) {
        if (units != this.labelUnits) {
            throw new IllegalArgumentException("units don't match");
        }
        int iclose = this.findClosestIndex(this.labelValues, value);
        return this.labelPositions[iclose];
    }

    private int findClosestIndex(int[] data, int searchFor) {
        int iclose = 0;
        double closest = Math.abs(data[iclose] - searchFor);
        for (int i = 0; i < this.labelPositions.length; ++i) {
            double c1 = Math.abs(data[i] - searchFor);
            if (!(c1 < closest)) continue;
            iclose = i;
            closest = c1;
        }
        return iclose;
    }

    private int findClosestIndex(double[] data, double searchFor) {
        int iclose = 0;
        double closest = Math.abs(data[iclose] - searchFor);
        for (int i = 0; i < this.labelPositions.length; ++i) {
            double c1 = Math.abs(data[i] - searchFor);
            if (!(c1 < closest)) continue;
            iclose = i;
            closest = c1;
        }
        return iclose;
    }

    public Datum invTransform(double d) {
        int iclose = this.findClosestIndex(this.labelPositions, (int)d);
        return this.labels.get(iclose);
    }

    protected boolean rangeIsAcceptable(DatumRange dr) {
        return true;
    }

    protected String tickFormatter(Datum t) {
        return this.df.format(t);
    }

    protected String[] tickFormatter(DatumVector tickV, DatumRange datumRange) {
        return this.df.axisFormat(tickV, datumRange);
    }

    public int getInterItemSpace() {
        return (int)Math.abs(this.transform(this.labels.get(1)) - this.transform(this.labels.get(0)));
    }

    public int getItemMin(Datum d) {
        Units units = d.getUnits();
        double value = d.doubleValue(units);
        int iclose = this.findClosestIndex(this.labelValues, units.convertDoubleTo(this.getUnits(), value));
        int tickPosition = this.labelPositions[iclose];
        int w = this.getInterItemSpace();
        return tickPosition - w / 2;
    }

    public int getItemMax(Datum d) {
        int w = this.getInterItemSpace();
        return this.getItemMin(d) + w;
    }

    public DasAxis createAttachedAxis(DasRow row, DasColumn column) {
        DasLabelAxis result = new DasLabelAxis(this.labels, this.getDataRange(), this.getOrientation());
        return result;
    }

    public DasAxis createAttachedAxis(int orientation) {
        return new DasLabelAxis(this.labels, this.getDataRange(), orientation);
    }

    public void update(DasUpdateEvent e) {
        double minimum = this.getDataRange().getMinimum();
        double maximum = this.getDataRange().getMaximum();
        if (this.getDataRange().getUnits() != this.labelUnits) {
            throw new IllegalArgumentException("units don't match");
        }
        this.indexMinimum = this.findClosestIndex(this.labelValues, minimum);
        this.indexMaximum = this.findClosestIndex(this.labelValues, maximum);
        if (this.indexMinimum > this.indexMaximum) {
            int t = this.indexMinimum;
            this.indexMaximum = this.indexMinimum;
            this.indexMinimum = t;
        }
    }

    protected void paintHorizontalAxis(Graphics2D g) {
        boolean bottomTicks = this.getOrientation() == 2 || this.isOppositeAxisVisible();
        boolean bottomTickLabels = this.getOrientation() == 2 && this.isTickLabelsVisible();
        boolean bottomLabel = this.getOrientation() == 2 && !this.axisLabel.equals("");
        boolean topTicks = this.getOrientation() == 1 || this.isOppositeAxisVisible();
        boolean topTickLabels = this.getOrientation() == 1 && this.isTickLabelsVisible();
        boolean topLabel = this.getOrientation() == 1 && !this.axisLabel.equals("");
        int topPosition = this.getRow().getDMinimum() - 1;
        int bottomPosition = this.getRow().getDMaximum();
        int DMax = this.getColumn().getDMaximum();
        int DMin = this.getColumn().getDMinimum();
        Font labelFont = this.getTickLabelFont();
        double dataMax = this.dataRange.getMaximum();
        double dataMin = this.dataRange.getMinimum();
        TickVDescriptor ticks = this.getTickV();
        if (bottomTicks) {
            g.drawLine(DMin, bottomPosition, DMax, bottomPosition);
        }
        if (topTicks) {
            g.drawLine(DMin, topPosition, DMax, topPosition);
        }
        int tickLengthMajor = labelFont.getSize() * 2 / 3;
        int tickLengthMinor = tickLengthMajor / 2;
        String[] llabels = this.tickFormatter(ticks.tickV, this.getDatumRange());
        for (int i = 0; i < ticks.tickV.getLength(); ++i) {
            Datum d = ticks.tickV.get(i);
            int w = this.getInterItemSpace();
            int tickPosition = (int)Math.floor(this.transform(d) + 0.5) - w / 2;
            int tickLength = tickLengthMajor;
            if (bottomTicks) {
                g.drawLine(this.getItemMin(d), bottomPosition, this.getItemMin(d), bottomPosition + tickLength);
                if (i == ticks.tickV.getLength() - 1) {
                    g.drawLine(this.getItemMax(d), bottomPosition, this.getItemMax(d), bottomPosition + tickLength);
                }
                if (bottomTickLabels) {
                    this.drawLabel(g, d, llabels[i], i, tickPosition + w / 2, bottomPosition + tickLength);
                }
            }
            if (!topTicks) continue;
            g.drawLine(this.getItemMin(d), topPosition, this.getItemMin(d), topPosition - tickLength);
            if (i == ticks.tickV.getLength() - 1) {
                g.drawLine(this.getItemMax(d), topPosition, this.getItemMax(d), topPosition - tickLength);
            }
            if (!topTickLabels) continue;
            this.drawLabel(g, d, llabels[i], i, tickPosition + w / 2, topPosition - tickLength);
        }
        if (!this.axisLabel.equals("")) {
            int baseline;
            int leftEdge;
            Graphics2D g2 = (Graphics2D)g.create();
            int titlePositionOffset = this.getTitlePositionOffset();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(g2, this.axisLabel);
            int titleWidth = (int)gtr.getWidth();
            g2.setFont(this.getLabelFont());
            if (bottomLabel) {
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = bottomPosition + titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            if (topLabel) {
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = topPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            g2.dispose();
        }
    }

    protected void paintVerticalAxis(Graphics2D g) {
        boolean leftTicks = this.getOrientation() == 3 || this.isOppositeAxisVisible();
        boolean leftTickLabels = this.getOrientation() == 3 && this.isTickLabelsVisible();
        boolean leftLabel = this.getOrientation() == 3 && !this.axisLabel.equals("");
        boolean rightTicks = this.getOrientation() == 4 || this.isOppositeAxisVisible();
        boolean rightTickLabels = this.getOrientation() == 4 && this.isTickLabelsVisible();
        boolean rightLabel = this.getOrientation() == 4 && !this.axisLabel.equals("");
        int leftPosition = this.getColumn().getDMinimum() - 1;
        int rightPosition = this.getColumn().getDMaximum();
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        Font labelFont = this.getTickLabelFont();
        double dataMax = this.dataRange.getMaximum();
        double dataMin = this.dataRange.getMinimum();
        TickVDescriptor ticks = this.getTickV();
        if (leftTicks) {
            g.drawLine(leftPosition, DMin, leftPosition, DMax);
        }
        if (rightTicks) {
            g.drawLine(rightPosition, DMin, rightPosition, DMax);
        }
        int tickLengthMajor = labelFont.getSize() * 2 / 3;
        int tickLengthMinor = tickLengthMajor / 2;
        String[] llabels = this.tickFormatter(ticks.tickV, this.getDatumRange());
        for (int i = 0; i < ticks.tickV.getLength(); ++i) {
            Datum datum = ticks.tickV.get(i);
            int w = this.getInterItemSpace();
            int tickPosition = (this.getItemMax(datum) + this.getItemMin(datum)) / 2 - g.getFontMetrics().getAscent() / 5;
            if (!this.getRow().contains(tickPosition)) continue;
            int tickLength = tickLengthMajor;
            if (leftTicks) {
                if (i == ticks.tickV.getLength() - 1) {
                    g.drawLine(leftPosition, this.getItemMin(datum), leftPosition - tickLength, this.getItemMin(datum));
                }
                g.drawLine(leftPosition, this.getItemMax(datum), leftPosition - tickLength, this.getItemMax(datum));
                if (leftTickLabels) {
                    this.drawLabel(g, datum, llabels[i], i, leftPosition - tickLength, tickPosition);
                }
            }
            if (!rightTicks) continue;
            if (i == ticks.tickV.getLength() - 1) {
                g.drawLine(rightPosition, this.getItemMin(datum), rightPosition + tickLength, this.getItemMin(datum));
            }
            g.drawLine(rightPosition, this.getItemMax(datum), rightPosition + tickLength, this.getItemMax(datum));
            if (!rightTickLabels) continue;
            this.drawLabel(g, datum, llabels[i], i, rightPosition + tickLength, tickPosition);
        }
        if (!this.axisLabel.equals("")) {
            int baseline;
            int leftEdge;
            Graphics2D g2 = (Graphics2D)g.create();
            int titlePositionOffset = this.getTitlePositionOffset();
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(g2, this.axisLabel);
            int titleWidth = (int)gtr.getWidth();
            g2.setFont(this.getLabelFont());
            if (leftLabel) {
                g2.rotate(-1.5707963267948966);
                leftEdge = -DMax + (DMax - DMin - titleWidth) / 2;
                baseline = leftPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            if (rightLabel) {
                g2.rotate(1.5707963267948966);
                leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                baseline = -rightPosition - titlePositionOffset;
                gtr.draw(g2, leftEdge, baseline);
            }
            g2.dispose();
        }
    }

    public int getOutsidePadding() {
        return this.outsidePadding;
    }

    public void setOutsidePadding(int outsidePadding) {
        int oldValue = outsidePadding;
        this.outsidePadding = outsidePadding;
        this.firePropertyChange("setOutsidePadding", oldValue, outsidePadding);
        this.updateTickPositions();
        this.update();
    }

    public boolean isFloppyItemSpacing() {
        return this.floppyItemSpacing;
    }

    public void setFloppyItemSpacing(boolean floppyItemSpacing) {
        boolean oldValue = this.floppyItemSpacing;
        this.floppyItemSpacing = floppyItemSpacing;
        this.firePropertyChange("floppyItemSpacing", oldValue, floppyItemSpacing);
        this.updateTickPositions();
        this.update();
    }

    public AffineTransform getAffineTransform(DasAxis.Memento memento, AffineTransform at) {
        return at;
    }
}

