/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasNameException;
import org.das2.components.propertyeditor.Editable;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasRow;
import org.das2.graph.event.DasUpdateEvent;
import org.das2.graph.event.DasUpdateListener;
import org.das2.system.MutatorLock;

public abstract class DasDevicePosition
implements Editable,
Serializable {
    protected transient DasCanvas canvas;
    protected transient DasDevicePosition parent;
    private double minimum;
    private double maximum;
    private boolean isWidth;
    private String dasName;
    private transient PropertyChangeSupport propertyChangeDelegate;
    protected EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener canvasListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent ev) {
            if (DasDevicePosition.this.emMinimum != 0.0 || DasDevicePosition.this.emMaximum != 0.0) {
                DasDevicePosition.this.revalidate();
            }
        }
    };
    private int dMinimum;
    private int dMaximum;
    private boolean valueIsAdjusting = false;
    private double emMinimum;
    private double emMaximum;
    private int ptMinimum;
    private int ptMaximum = 0;

    protected DasDevicePosition(DasCanvas canvas, boolean isWidth, DasDevicePosition parent, double minimum, double maximum, double emMinimum, double emMaximum, int ptMinimum, int ptMaximum) {
        boolean isNull;
        if (minimum > maximum) {
            throw new IllegalArgumentException("minimum>maximum");
        }
        boolean bl = isNull = canvas == null && parent == null;
        if (parent != null) {
            canvas = parent.getCanvas();
            isWidth = parent.isWidth;
        }
        if (canvas == null & !isNull) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        this.canvas = canvas;
        this.parent = parent;
        this.minimum = minimum;
        this.maximum = maximum;
        this.emMinimum = emMinimum;
        this.emMaximum = emMaximum;
        this.ptMinimum = ptMinimum;
        this.ptMaximum = ptMaximum;
        this.isWidth = isWidth;
        this.dasName = DasApplication.getDefaultApplication().suggestNameFor(this);
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
        if (parent != null) {
            parent.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    DasDevicePosition.this.revalidate();
                }
            });
        } else if (canvas != null) {
            canvas.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    DasDevicePosition.this.revalidate();
                }
            });
            canvas.addPropertyChangeListener("font", this.canvasListener);
            canvas.addDevicePosition(this);
        }
        if (!isNull) {
            this.revalidate();
        }
    }

    public static double[] parseFormatStr(String s) throws ParseException {
        double[] result = new double[]{0.0, 0.0, 0.0};
        StringTokenizer tok = new StringTokenizer(s, "%emptx", true);
        int pos = 0;
        while (tok.hasMoreTokens()) {
            String s2;
            String ds = tok.nextToken();
            pos += ds.length();
            double d = Double.parseDouble(ds);
            String u = tok.nextToken();
            pos += u.length();
            u.trim();
            if (u.charAt(0) == '%') {
                result[0] = d / 100.0;
                continue;
            }
            if (u.equals("e")) {
                s2 = tok.nextToken();
                if (!s2.equals("m")) {
                    throw new ParseException("expected m following e", pos);
                }
                pos += s2.length();
                result[1] = d;
                continue;
            }
            if (!u.equals("p")) continue;
            s2 = tok.nextToken();
            if (!s2.equals("t") && !s2.equals("x")) {
                throw new ParseException("expected t following p", pos);
            }
            pos += s2.length();
            result[2] = d;
        }
        result[0] = (double)Math.round(result[0] * 1000.0) / 1000.0;
        result[1] = (double)Math.round(result[1] * 10.0) / 10.0;
        return result;
    }

    public static void parseLayoutStr(DasDevicePosition pos, String spec) throws ParseException {
        String[] ss = spec.split(",");
        double[] pmin = DasDevicePosition.parseFormatStr(ss[0]);
        double[] pmax = DasDevicePosition.parseFormatStr(ss[1]);
        MutatorLock lock = pos.mutatorLock();
        lock.lock();
        pos.setMinimum(pmin[0]);
        pos.setEmMinimum(pmin[1]);
        pos.setPtMinimum((int)pmin[2]);
        pos.setMaximum(pmax[0]);
        pos.setEmMaximum(pmax[1]);
        pos.setPtMaximum((int)pmax[2]);
        lock.unlock();
    }

    public static String formatLayoutStr(DasDevicePosition pos, boolean min) {
        StringBuffer buf = new StringBuffer();
        DecimalFormat nf2 = new DecimalFormat("0.00");
        DecimalFormat nf1 = new DecimalFormat("0.0");
        DecimalFormat nf0 = new DecimalFormat("0");
        if (min) {
            if (pos.getMinimum() != 0.0) {
                buf.append(nf2.format(pos.getMinimum() * 100.0) + "%");
            }
            if (pos.getEmMinimum() != 0.0) {
                buf.append(nf1.format(pos.getEmMinimum()) + "em");
            }
            if (pos.getPtMinimum() != 0) {
                buf.append(nf0.format(pos.getPtMinimum()) + "pt");
            }
        } else {
            if (pos.getMaximum() != 0.0) {
                buf.append(nf2.format(pos.getMaximum() * 100.0) + "%");
            }
            if (pos.getEmMaximum() != 0.0) {
                buf.append(nf1.format(pos.getEmMaximum()) + "em");
            }
            if (pos.getPtMaximum() != 0) {
                buf.append(nf0.format(pos.getPtMaximum()) + "pt");
            }
        }
        if (buf.length() == 0) {
            return "0%";
        }
        return buf.toString();
    }

    public DasDevicePosition(DasCanvas parent, double minimum, double maximum, boolean width) {
        this(parent, width, null, minimum, maximum, 0.0, 0.0, 0, 0);
    }

    protected DasCanvas getCanvas() {
        return this.canvas;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.canvas.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public String getDasName() {
        return this.dasName;
    }

    public int getEmSize() {
        return this.canvas.getFont().getSize();
    }

    private int getParentMin() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDMinimum();
    }

    private int getParentMax() {
        if (this.parent == null) {
            return this.isWidth ? this.canvas.getWidth() : this.canvas.getHeight();
        }
        return this.parent.getDMaximum();
    }

    private void revalidate() {
        int oldmin = this.dMinimum;
        int oldmax = this.dMaximum;
        this.dMinimum = (int)((double)this.getParentMin() + this.minimum * (double)this.getDeviceSize() + (double)this.getEmSize() * this.emMinimum + (double)this.ptMinimum);
        this.dMaximum = (int)((double)this.getParentMin() + this.maximum * (double)this.getDeviceSize() + (double)this.getEmSize() * this.emMaximum + (double)this.ptMaximum);
        if (this.dMaximum <= this.dMinimum) {
            this.dMaximum = this.dMinimum + 1;
        }
        if (this.dMinimum != oldmin) {
            this.firePropertyChange("dMinimum", oldmin, this.dMinimum);
        }
        if (this.dMaximum != oldmax) {
            this.firePropertyChange("dMaximum", oldmax, this.dMaximum);
        }
        if (this.dMinimum != oldmin || this.dMaximum != oldmax) {
            this.fireUpdate();
        }
        this.canvas.repaint();
    }

    public int getDMinimum() {
        if (this.canvas == null && this.parent == null) {
            String type = this.isWidth ? "column" : "row";
            throw new RuntimeException("null " + type + ", " + type + " was not set before layout");
        }
        return this.dMinimum;
    }

    public int getDMaximum() {
        if (this.canvas == null && this.parent == null) {
            String type = this.isWidth ? "column" : "row";
            throw new RuntimeException("null " + type + ", " + type + " was not set before layout");
        }
        return this.dMaximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    private void setPosition(double minimum, double maximum) {
        double oldMin = this.minimum;
        double oldMax = this.maximum;
        double doldMin = this.minimum;
        double doldMax = this.maximum;
        this.minimum = Math.min(minimum, maximum);
        this.maximum = Math.max(maximum, maximum);
        this.revalidate();
        if (oldMin != this.minimum) {
            this.firePropertyChange("minimum", oldMin, this.minimum);
        }
        if (oldMax != this.maximum) {
            this.firePropertyChange("maximum", oldMax, this.maximum);
        }
    }

    public void setDPosition(int minimum, int maximum) {
        int pmin = this.getParentMin();
        int pmax = this.getParentMax();
        int em = this.getEmSize();
        int length = pmax - pmin;
        double nmin = ((double)minimum - this.emMinimum * (double)em - (double)this.ptMinimum - (double)pmin) / (double)length;
        double nmax = ((double)maximum - this.emMaximum * (double)em - (double)this.ptMaximum - (double)pmin) / (double)length;
        this.setPosition(nmin, nmax);
    }

    public void setMaximum(double maximum) {
        if (maximum == this.maximum) {
            return;
        }
        if (maximum < this.minimum) {
            this.setPosition(maximum, this.minimum);
        } else {
            double oldValue = this.maximum;
            this.maximum = maximum;
            this.firePropertyChange("maximum", oldValue, maximum);
            this.revalidate();
        }
    }

    public void setDMaximum(int maximum) {
        int pmin = this.getParentMin();
        int pmax = this.getParentMax();
        int em = this.getEmSize();
        int length = pmax - pmin;
        double n = ((double)maximum - this.emMaximum * (double)em - (double)this.ptMaximum) / (double)length;
        this.setMaximum(n);
    }

    public void setMinimum(double minimum) {
        if (minimum == this.minimum) {
            return;
        }
        if (minimum > this.maximum) {
            this.setPosition(this.maximum, minimum);
        } else {
            double oldValue = this.minimum;
            this.minimum = minimum;
            this.firePropertyChange("minimum", oldValue, minimum);
            this.revalidate();
        }
    }

    public void setDMinimum(int minimum) {
        int pmin = this.getParentMin();
        int pmax = this.getParentMax();
        int em = this.getEmSize();
        int length = pmax - pmin;
        double n = ((double)minimum - this.emMinimum * (double)em - (double)this.ptMinimum) / (double)length;
        this.setMinimum(n);
    }

    public DasCanvas getParent() {
        return this.canvas;
    }

    public void setParent(DasCanvas parent) {
        this.canvas = parent;
        this.fireUpdate();
    }

    protected synchronized MutatorLock mutatorLock() {
        return new MutatorLock(){

            public void lock() {
                if (DasDevicePosition.this.isValueIsAdjusting()) {
                    System.err.println("lock is already set!");
                }
                DasDevicePosition.this.valueIsAdjusting = true;
            }

            public void unlock() {
                DasDevicePosition.this.valueIsAdjusting = false;
                DasDevicePosition.this.propertyChangeDelegate.firePropertyChange("mutatorLock", "locked", "unlocked");
            }
        };
    }

    public void addpwUpdateListener(DasUpdateListener l) {
        this.listenerList.add(DasUpdateListener.class, l);
    }

    public void removepwUpdateListener(DasUpdateListener l) {
        this.listenerList.remove(DasUpdateListener.class, l);
    }

    protected void fireUpdate() {
        DasUpdateEvent e = new DasUpdateEvent(this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DasUpdateListener.class) continue;
            ((DasUpdateListener)listeners[i + 1]).update(e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeDelegate.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    protected void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    protected void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    protected void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeDelegate.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected int getDeviceSize() {
        return this.getParentMax() - this.getParentMin();
    }

    public static Rectangle toRectangle(DasRow row, DasColumn column) {
        int xmin = column.getDMinimum();
        int ymin = row.getDMinimum();
        return new Rectangle(xmin, ymin, column.getDMaximum() - xmin, row.getDMaximum() - ymin);
    }

    public String toString() {
        return this.getClass().getName() + " " + DasDevicePosition.formatLayoutStr(this, true) + "," + DasDevicePosition.formatLayoutStr(this, false) + " [dpos=" + this.getDMinimum() + "," + this.getDMaximum() + "]";
    }

    public boolean contains(int x) {
        return this.getDMinimum() <= x && x <= this.getDMaximum();
    }

    public int getDMiddle() {
        return (this.getDMinimum() + this.getDMaximum()) / 2;
    }

    public double getEmMinimum() {
        return this.emMinimum;
    }

    public void setEmMinimum(double emMinimum) {
        double oldValue = this.emMinimum;
        this.emMinimum = emMinimum;
        this.firePropertyChange("emMinimum", oldValue, emMinimum);
        this.revalidate();
    }

    public double getEmMaximum() {
        return this.emMaximum;
    }

    public void setEmMaximum(double emMaximum) {
        double oldValue = this.emMaximum;
        this.emMaximum = emMaximum;
        this.firePropertyChange("emMaximum", oldValue, emMaximum);
        this.revalidate();
    }

    public int getPtMinimum() {
        return this.ptMinimum;
    }

    public void setPtMinimum(int ptMinimum) {
        int oldValue = this.ptMinimum;
        this.ptMinimum = ptMinimum;
        this.firePropertyChange("ptMinimum", oldValue, ptMinimum);
        this.revalidate();
    }

    public int getPtMaximum() {
        return this.ptMaximum;
    }

    public void setPtMaximum(int ptMaximum) {
        int oldValue = this.ptMaximum;
        this.ptMaximum = ptMaximum;
        this.firePropertyChange("ptMaximum", oldValue, ptMaximum);
        this.revalidate();
    }

    public DasDevicePosition getParentDevicePosition() {
        return this.parent;
    }

    public boolean isValueIsAdjusting() {
        return this.valueIsAdjusting;
    }
}

