/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;

public class ColumnColumnConnector
extends DasCanvasComponent
implements PropertyChangeListener {
    private DasCanvas parent;
    private DasRow topRow;
    private DasRow bottomRow;
    private DasPlot topPlot;
    private DasPlot bottomPlot;
    private Color fillColor = new Color(240, 240, 240, 255);
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean fill = false;
    private boolean bottomCurtain;
    private int curtainOpacityPercent = 40;

    public ColumnColumnConnector(DasCanvas parent, DasPlot topPlot, DasRow topRow, DasPlot bottomPlot) {
        this.putClientProperty("layeredContainerLayer", DasCanvas.AXIS_LAYER);
        this.setForeground(Color.LIGHT_GRAY);
        this.setRow(topRow);
        this.setColumn(topPlot.getColumn());
        this.topPlot = topPlot;
        this.topRow = topRow;
        if (topRow == null) {
            topRow = topPlot.getRow();
        }
        this.bottomPlot = bottomPlot;
        this.parent = parent;
        topPlot.addPropertyChangeListener(this);
        topPlot.getXAxis().addPropertyChangeListener(this);
        topPlot.getYAxis().addPropertyChangeListener(this);
        bottomPlot.addPropertyChangeListener(this);
        bottomPlot.getXAxis().addPropertyChangeListener(this);
    }

    private Rectangle getMyBounds() {
        int ytop = this.topRow.getDMaximum();
        int ybottom = this.bottomCurtain ? this.bottomPlot.getRow().getDMaximum() : this.bottomPlot.getRow().getDMinimum();
        int xhigh = Math.max(this.topPlot.getColumn().getDMaximum(), this.bottomPlot.getColumn().getDMaximum());
        int xlow = Math.min(this.topPlot.getColumn().getDMinimum(), this.bottomPlot.getColumn().getDMinimum());
        Rectangle result = new Rectangle(xlow, ytop, xhigh - xlow + 1, ybottom - ytop);
        return result;
    }

    public Shape getActiveRegion() {
        return this.getMyBounds();
    }

    public void resize() {
        this.setBounds(this.getMyBounds());
    }

    private Datum min(Datum d1, Datum d2) {
        return d1.lt(d2) ? d1 : d2;
    }

    private Datum max(Datum d1, Datum d2) {
        return d1.gt(d2) ? d1 : d2;
    }

    protected void paintComponent(Graphics g1) {
        if (!this.topPlot.getXAxis().getUnits().isConvertableTo(this.bottomPlot.getXAxis().getUnits())) {
            return;
        }
        this.bottomPlot.addPropertyChangeListener(this);
        Graphics2D g = (Graphics2D)g1.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(-this.getX(), -this.getY());
        int hlen = 3;
        int y1 = this.topRow.getDMaximum() + hlen;
        int y2 = this.bottomPlot.getRow().getDMinimum() - 1 - hlen;
        int y3 = this.bottomPlot.getRow().getDMinimum() - 1;
        int y4 = this.bottomPlot.getRow().getDMaximum();
        Datum dlow = this.max(this.topPlot.getXAxis().getDataMinimum(), this.bottomPlot.getXAxis().getDataMinimum());
        Datum dhigh = this.min(this.topPlot.getXAxis().getDataMaximum(), this.bottomPlot.getXAxis().getDataMaximum());
        int xhigh1 = (int)this.topPlot.getXAxis().transform(dhigh);
        int xhigh2 = (int)this.bottomPlot.getXAxis().transform(dhigh);
        int xlow1 = (int)this.topPlot.getXAxis().transform(dlow);
        int xlow2 = (int)this.bottomPlot.getXAxis().transform(dlow);
        GeneralPath gp = new GeneralPath();
        GeneralPath fillPath = new GeneralPath();
        gp.moveTo(xlow1, y1 - hlen);
        fillPath.moveTo(xlow1, y1 - hlen);
        gp.lineTo(xlow1, y1);
        fillPath.lineTo(xlow1, y1);
        gp.lineTo(xlow2, y2);
        fillPath.lineTo(xlow2, y2);
        gp.lineTo(xlow2, y3);
        fillPath.lineTo(xlow2, y3);
        gp.moveTo(xhigh2, y3);
        fillPath.lineTo(xhigh2, y3);
        gp.lineTo(xhigh2, y2);
        fillPath.lineTo(xhigh2, y2);
        gp.lineTo(xhigh1, y1);
        fillPath.lineTo(xhigh1, y1);
        gp.lineTo(xhigh1, y1 - hlen);
        fillPath.lineTo(xhigh1, y1 - hlen);
        if (this.fill) {
            g.setColor(this.fillColor);
            g.fill(fillPath);
        }
        g.setColor(this.getForeground());
        g.draw(gp);
        if (this.bottomCurtain && this.topPlot.getYAxis().getUnits().isConvertableTo(this.bottomPlot.getYAxis().getUnits())) {
            DatumRange drtop = this.topPlot.getYAxis().getDatumRange();
            DatumRange yaxisRange = this.bottomPlot.getYAxis().getDatumRange();
            drtop = DatumRangeUtil.sloppyIntersection(yaxisRange, drtop);
            int y5 = (int)this.bottomPlot.getYAxis().transform(drtop.max());
            int y6 = (int)this.bottomPlot.getYAxis().transform(drtop.min());
            if (this.curtainOpacityPercent > 0) {
                int xLeft = this.topPlot.getXAxis().getColumn().getDMinimum();
                int xRight = this.bottomPlot.getXAxis().getColumn().getDMaximum();
                Color canvasColor = this.getCanvas().getBackground();
                Color curtainColor = new Color(canvasColor.getRed(), canvasColor.getGreen(), canvasColor.getBlue(), this.curtainOpacityPercent * 255 / 100);
                GeneralPath gpfill = new GeneralPath(DasRow.toRectangle(this.bottomPlot.getRow(), this.bottomPlot.getColumn()));
                gpfill.append(new Rectangle(xlow2, y5, xhigh2 - xlow2, y6 - y5), false);
                gpfill.setWindingRule(0);
                g.setColor(curtainColor);
                g.fill(gpfill);
                g.setColor(this.getForeground());
            }
            if (yaxisRange.contains(drtop.max())) {
                g.drawLine(xlow2, y5, xhigh2, y5);
            }
            if (yaxisRange.contains(drtop.min()) && drtop.min().gt(yaxisRange.min())) {
                g.drawLine(xlow2, y6, xhigh2, y6);
            }
            g.drawLine(xlow2, y3, xlow2, y4);
            g.drawLine(xhigh2, y3, xhigh2, y4);
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(g1);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.markDirty();
        this.update();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        Color oldFillColor = this.fillColor;
        this.fillColor = fillColor;
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("fillColor", oldFillColor, fillColor);
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        boolean oldFill = this.fill;
        this.fill = fill;
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("fill", new Boolean(oldFill), new Boolean(fill));
    }

    public boolean isBottomCurtain() {
        return this.bottomCurtain;
    }

    public void setBottomCurtain(boolean bottomCurtain) {
        boolean oldBottomCurtain = this.bottomCurtain;
        this.bottomCurtain = bottomCurtain;
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("bottomCurtain", new Boolean(oldBottomCurtain), new Boolean(bottomCurtain));
    }

    public int getCurtainOpacityPercent() {
        return this.curtainOpacityPercent;
    }

    public void setCurtainOpacityPercent(int curtainOpacityPercent) {
        int oldCurtainOpacityPercent = this.curtainOpacityPercent;
        this.curtainOpacityPercent = Math.max(0, Math.min(100, curtainOpacityPercent));
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("curtainOpacityPercent", new Integer(oldCurtainOpacityPercent), new Integer(curtainOpacityPercent));
    }
}

