/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Units;
import org.das2.system.DasLogger;

public class Auralizor {
    private static final int EXTERNAL_BUFFER_SIZE = 1000;
    byte[] buffer;
    SourceDataLine line = null;
    int bufferInputIndex;
    double min = -1.0;
    double max = 1.0;
    Units yUnits = Units.dimensionless;
    VectorDataSet ds;

    void setDataSet(VectorDataSet ds) {
        this.ds = ds;
    }

    public void playSound() {
        float sampleRate = (float)(1.0 / this.ds.getXTagDatum(1).subtract(this.ds.getXTagDatum(0)).doubleValue(Units.seconds));
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("sampleRate= " + sampleRate);
        AudioFormat audioFormat = new AudioFormat(sampleRate, 8, 1, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            this.line.addLineListener(this.getLineListener());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.buffer = new byte[1000];
        this.bufferInputIndex = 0;
        this.line.start();
        int i = 0;
        int ibuf = 0;
        while (i < this.ds.getXLength()) {
            double d = this.ds.getDouble(i++, this.yUnits);
            int b = (int)(256.0 * (d - this.min) / (this.max - this.min));
            this.buffer[ibuf++] = (byte)b;
            if (ibuf != 1000) continue;
            this.line.write(this.buffer, 0, ibuf);
            ibuf = 0;
        }
        this.line.write(this.buffer, 0, ibuf);
        ibuf = 0;
        this.line.drain();
        this.line.close();
    }

    LineListener getLineListener() {
        return new LineListener(){

            public void update(LineEvent e) {
                if (e.getType().equals(LineEvent.Type.CLOSE)) {
                    // empty if block
                }
            }
        };
    }

    public Auralizor(VectorDataSet ds) {
        this.ds = ds;
    }
}

