/*
 * Decompiled with CFR 0.152.
 */
package org.das2.fsm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.DasExceptionHandler;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class FileStorageModel {
    private Pattern pattern;
    private Pattern absPattern;
    private String regex;
    private FieldHandler[] fieldHandlers;
    private int timeWidth;
    private int timeWidthMultiplier;
    private Datum timePhase = null;
    private boolean[] copyToEndTime;
    private boolean useEndTime;
    FileStorageModel parent;
    FileSystem root;
    public static final int StartYear4 = 100;
    public static final int StartYear2 = 101;
    public static final int StartMonth = 102;
    public static final int StartMonthName = 108;
    public static final int StartDay = 103;
    public static final int StartDoy = 104;
    public static final int StartHour = 105;
    public static final int StartMinute = 106;
    public static final int StartSecond = 107;
    public static final int EndYear4 = 200;
    public static final int EndYear2 = 201;
    public static final int EndMonth = 202;
    public static final int EndMonthName = 208;
    public static final int EndDay = 203;
    public static final int EndDoy = 204;
    public static final int EndHour = 205;
    public static final int EndMinute = 206;
    public static final int EndSecond = 207;
    public static final int Ignore = 300;
    HashMap fileNameMap = null;
    static final NumberFormat nf4 = new DecimalFormat("0000");
    static final NumberFormat nf3 = new DecimalFormat("000");
    static final NumberFormat nf2 = new DecimalFormat("00");
    private static final String[] mons = new String[]{"", "jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final FieldHandler StartMonthNameHandler = new FieldHandler(){

        public void handle(String s, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            try {
                ts1.month = TimeUtil.monthNumber(s);
            }
            catch (ParseException e) {
                DasExceptionHandler.handle(e);
            }
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return mons[ts1.month];
        }
    };
    private static final FieldHandler EndMonthNameHandler = new FieldHandler(){

        public void handle(String s, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            try {
                ts2.month = TimeUtil.monthNumber(s);
            }
            catch (ParseException e) {
                DasExceptionHandler.handle(e);
            }
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return mons[ts2.month];
        }
    };
    private static final FieldHandler StartYear4Handler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.year = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf4.format(ts1.year);
        }
    };
    private static final FieldHandler StartYear2Handler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.year = i < 58 ? i + 2000 : i + 1900;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts1.year % 100);
        }
    };
    private static final FieldHandler StartMonthHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.month = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts1.month);
        }
    };
    private static final FieldHandler StartDayHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.day = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts1.day);
        }
    };
    private static final FieldHandler StartDoyHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.doy = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf3.format(ts1.doy);
        }
    };
    private static final FieldHandler StartHourHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.hour = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts1.hour);
        }
    };
    private static final FieldHandler StartMinuteHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.minute = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts1.minute);
        }
    };
    private static final FieldHandler StartSecondHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts1.seconds = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts1.seconds);
        }
    };
    private static final FieldHandler EndYear4Handler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.year = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf4.format(ts2.year);
        }
    };
    private static final FieldHandler EndYear2Handler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.year = i < 58 ? i + 2000 : i + 1900;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts2.year);
        }
    };
    private static final FieldHandler EndMonthHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.month = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts2.month);
        }
    };
    private static final FieldHandler EndDayHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.day = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts2.day);
        }
    };
    private static final FieldHandler EndDoyHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.doy = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf3.format(ts2.doy);
        }
    };
    private static final FieldHandler EndHourHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.hour = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts2.hour);
        }
    };
    private static final FieldHandler EndMinuteHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.minute = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts2.minute);
        }
    };
    private static final FieldHandler EndSecondHandler = new IntegerFieldHandler(){

        public void handleInt(int i, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            ts2.seconds = i;
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return nf2.format(ts2.seconds);
        }
    };
    private static final FieldHandler IgnoreHandler = new FieldHandler(){

        public void handle(String s, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
        }

        public String format(TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            return "*";
        }
    };

    private int toTimeUtilEnum(int i) {
        if (i < 100 || i > 300) {
            throw new IllegalArgumentException("enumeration is not of the correct type");
        }
        if ((i %= 100) == 0) {
            i = 1;
        }
        return i;
    }

    private void checkArgs(String regex, int[] digitList) {
        int i;
        int i2;
        int startLsd = 0;
        int endLsd = 0;
        int[] startDigits = new int[7];
        int[] endDigits = new int[7];
        this.copyToEndTime = new boolean[8];
        int startBase = 100;
        int endBase = 200;
        int ignoreBase = 300;
        for (i2 = 0; i2 < digitList.length; ++i2) {
            if (digitList[i2] == 108) {
                digitList[i2] = 102;
            }
            if (digitList[i2] != 208) continue;
            digitList[i2] = 202;
        }
        for (i2 = 0; i2 < digitList.length; ++i2) {
            if (digitList[i2] == 104) {
                startDigits[1] = 1;
                startDigits[2] = 1;
                if (103 <= startLsd) continue;
                startLsd = 103;
                continue;
            }
            if (digitList[i2] == 204) {
                endDigits[1] = 1;
                endDigits[2] = 1;
                if (203 <= endLsd) continue;
                endLsd = 203;
                continue;
            }
            if (digitList[i2] >= startBase && digitList[i2] < endBase) {
                startDigits[digitList[i2] - startBase] = 1;
                if (digitList[i2] <= startLsd) continue;
                startLsd = digitList[i2];
                continue;
            }
            if (digitList[i2] < endBase || digitList[i2] >= ignoreBase) continue;
            endDigits[digitList[i2] - endBase] = 1;
            if (digitList[i2] <= endLsd) continue;
            endLsd = digitList[i2];
        }
        if (startDigits[101 - startBase] == 1) {
            startDigits[100 - startBase] = 1;
        }
        if (startDigits[100 - startBase] == 1) {
            startDigits[101 - startBase] = 1;
        }
        if (startDigits[104 - startBase] == 1) {
            startDigits[102 - startBase] = 1;
            startDigits[103 - startBase] = 1;
        }
        if (endDigits[201 - endBase] == 1) {
            endDigits[200 - endBase] = 1;
        }
        if (startDigits[200 - endBase] == 1) {
            startDigits[201 - endBase] = 1;
        }
        if (endDigits[204 - endBase] == 1) {
            endDigits[202 - endBase] = 1;
            endDigits[203 - endBase] = 1;
        }
        for (i2 = 0; i2 < startDigits.length; ++i2) {
            if (i2 > 0 && startDigits[i2] == 1 && startDigits[i2 - 1] != 1) {
                throw new IllegalArgumentException("more significant digits missing in startTime");
            }
            if (i2 <= 0 || startDigits[i2] != 0 || startDigits[i2 - 1] != 1) continue;
            this.timeWidth = this.toTimeUtilEnum(startLsd);
            this.timeWidthMultiplier = 1;
        }
        boolean canUse = true;
        for (i = startLsd - startBase; i >= 0; --i) {
            if (endDigits[i] == 0) {
                canUse = false;
            }
            if (canUse) continue;
            endDigits[i] = 0;
        }
        for (i = 0; i < endDigits.length; ++i) {
            this.copyToEndTime[this.toTimeUtilEnum((int)(i + endBase))] = endDigits[i] == 0;
        }
        if (FileStorageModel.countGroups(regex) != digitList.length) {
            throw new IllegalArgumentException("number of groups in regular expression (" + FileStorageModel.countGroups(regex) + ") doesn't equal the length of digitList (" + digitList.length + ").");
        }
    }

    private static FieldHandler[] getHandlers(int[] digitList) {
        FieldHandler[] startHandlers = new FieldHandler[]{StartYear4Handler, StartYear2Handler, StartMonthHandler, StartDayHandler, StartDoyHandler, StartHourHandler, StartMinuteHandler, StartSecondHandler, StartMonthNameHandler};
        FieldHandler[] endHandlers = new FieldHandler[]{EndYear4Handler, EndYear2Handler, EndMonthHandler, EndDayHandler, EndDoyHandler, EndHourHandler, EndMinuteHandler, EndSecondHandler, EndMonthNameHandler};
        ArrayList<FieldHandler> fieldHandlerList = new ArrayList<FieldHandler>();
        for (int i = 0; i < digitList.length; ++i) {
            if (digitList[i] >= 100 && digitList[i] < 200) {
                fieldHandlerList.add(i, startHandlers[digitList[i] - 100]);
                continue;
            }
            if (digitList[i] >= 200 && digitList[i] < 300) {
                fieldHandlerList.add(i, endHandlers[digitList[i] - 200]);
                continue;
            }
            if (digitList[i] == 300) {
                fieldHandlerList.add(i, IgnoreHandler);
                continue;
            }
            throw new IllegalArgumentException("unknown field handler: " + digitList[i]);
        }
        return fieldHandlerList.toArray(new FieldHandler[fieldHandlerList.size()]);
    }

    private DatumRange getDatumRangeFor(String filename) {
        Matcher m;
        if (this.fieldHandlers.length == 0) {
            return DatumRange.newDatumRange(-1.0E30, 1.0E30, Units.mj1958);
        }
        TimeUtil.TimeStruct ts1 = new TimeUtil.TimeStruct();
        ts1.year = 0;
        ts1.day = 0;
        ts1.month = 1;
        ts1.doy = 0;
        ts1.hour = 0;
        ts1.minute = 0;
        ts1.seconds = 0.0;
        TimeUtil.TimeStruct ts2 = new TimeUtil.TimeStruct();
        if (File.separatorChar == '\\') {
            filename = filename.replaceAll("\\\\", "/");
        }
        if ((m = this.pattern.matcher(filename)).matches()) {
            for (int i = 0; i < this.fieldHandlers.length; ++i) {
                String s = m.group(i + 1);
                this.fieldHandlers[i].handle(s, ts1, ts2);
            }
            if (ts1.doy == 0 && ts1.day == 0) {
                ts1.day = 1;
            }
            TimeUtil.normalize(ts1);
            if (this.copyToEndTime[1]) {
                ts2.year = ts1.year;
            }
            if (this.copyToEndTime[2]) {
                ts2.month = ts1.month;
            }
            if (this.copyToEndTime[3]) {
                ts2.day = ts1.day;
            }
            if (this.copyToEndTime[4]) {
                ts2.doy = ts1.doy;
            }
            if (this.copyToEndTime[5]) {
                ts2.hour = ts1.hour;
            }
            if (this.copyToEndTime[6]) {
                ts2.minute = ts1.minute;
            }
            if (this.copyToEndTime[7]) {
                ts2.seconds = ts1.seconds;
            }
            Datum s1 = TimeUtil.toDatum(ts1);
            Datum s2 = TimeUtil.next(this.timeWidth, TimeUtil.toDatum(ts2));
            for (int ii = 1; ii < this.timeWidthMultiplier; ++ii) {
                s2 = TimeUtil.next(this.timeWidth, s2);
            }
            DatumRange dr = new DatumRange(s1, s2);
            return dr;
        }
        throw new IllegalArgumentException("file name (" + filename + ") doesn't match model specification (" + this.regex + ")");
    }

    public String getFilenameFor(Datum start, Datum end) {
        TimeUtil.TimeStruct ts1 = TimeUtil.toTimeStruct(start);
        TimeUtil.TimeStruct ts2 = TimeUtil.toTimeStruct(end);
        StringBuffer result = new StringBuffer(30);
        result.append(this.root);
        for (int i = 0; i < this.fieldHandlers.length; ++i) {
        }
        return null;
    }

    public String[] getNamesFor(DatumRange targetRange) throws IOException {
        return this.getNamesFor(targetRange, new NullProgressMonitor());
    }

    private DatumRange calculateRangeFor(Datum t) {
        Datum start = TimeUtil.prev(this.timeWidth, t);
        if (TimeUtil.next(this.timeWidth, start).equals(t)) {
            start = t;
        }
        if (this.timePhase != null && 3 == this.timeWidth) {
            Datum widthDatum = Units.days.createDatum(this.timeWidthMultiplier);
            Datum dd = start.subtract(this.timePhase).divide(widthDatum);
            double d = dd.doubleValue(Units.days);
            d = Math.floor(d);
            start = this.timePhase.add(Units.days.createDatum(d));
        }
        Datum end = start;
        for (int i = 0; i < this.timeWidthMultiplier; ++i) {
            TimeUtil.next(this.timeWidth, end);
        }
        return new DatumRange(start, end);
    }

    public String calculateNameFor(Datum start) {
        if (this.parent != null) {
            String name = this.parent.calculateNameFor(start);
        } else {
            String name = "";
        }
        DatumRange dr = this.calculateRangeFor(start);
        return null;
    }

    public String[] getNamesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        String listRegex;
        FileSystem[] fileSystems;
        String[] names;
        if (this.parent != null) {
            names = this.parent.getNamesFor(targetRange);
            fileSystems = new FileSystem[names.length];
            for (int i = 0; i < names.length; ++i) {
                try {
                    fileSystems[i] = this.root.createFileSystem(names[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String parentRegex = FileStorageModel.getParentRegex(this.regex);
            listRegex = this.regex.substring(parentRegex.length() + 1);
        } else {
            fileSystems = new FileSystem[]{this.root};
            names = new String[]{""};
            listRegex = this.regex;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < fileSystems.length; ++i) {
            String[] files1 = fileSystems[i].listDirectory("/", listRegex);
            for (int j = 0; j < files1.length; ++j) {
                String ff;
                String string = ff = names[i].equals("") ? files1[j] : names[i] + "/" + files1[j];
                if (ff.endsWith("/")) {
                    ff = ff.substring(0, ff.length() - 1);
                }
                try {
                    DatumRange dr = this.getRangeFor(ff);
                    if (targetRange != null && !dr.intersects(targetRange)) continue;
                    list.add(ff);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
            }
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                DatumRange dr1 = FileStorageModel.this.getRangeFor((String)o1);
                DatumRange dr2 = FileStorageModel.this.getRangeFor((String)o2);
                return dr1.compareTo(dr2);
            }
        });
        return list.toArray(new String[list.size()]);
    }

    public String getRepresentativeFile(ProgressMonitor monitor) throws IOException {
        String listRegex;
        FileSystem[] fileSystems;
        String[] names;
        if (this.parent != null) {
            names = this.parent.getNamesFor(null);
            fileSystems = new FileSystem[names.length];
            for (int i = 0; i < names.length; ++i) {
                try {
                    fileSystems[i] = this.root.createFileSystem(names[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String parentRegex = FileStorageModel.getParentRegex(this.regex);
            listRegex = this.regex.substring(parentRegex.length() + 1);
        } else {
            fileSystems = new FileSystem[]{this.root};
            names = new String[]{""};
            listRegex = this.regex;
        }
        ArrayList list = new ArrayList();
        String result = null;
        for (int i = 0; result == null && i < fileSystems.length; ++i) {
            String ff;
            String[] files1 = fileSystems[i].listDirectory("/", listRegex);
            if (files1.length <= 0) continue;
            String string = ff = names[i].equals("") ? files1[0] : names[i] + "/" + files1[0];
            if (ff.endsWith("/")) {
                ff = ff.substring(0, ff.length() - 1);
            }
            result = ff;
        }
        return result;
    }

    public File[] getFilesFor(DatumRange targetRange) throws IOException {
        return this.getFilesFor(targetRange, new NullProgressMonitor());
    }

    public DatumRange getRangeFor(String name) {
        return this.getDatumRangeFor(name);
    }

    public boolean containsFile(File file) {
        this.maybeCreateFileNameMap();
        if (!this.fileNameMap.containsKey(file)) {
            return false;
        }
        String result = (String)this.fileNameMap.get(file);
        String name = this.getNameFor(file);
        Matcher m = this.pattern.matcher(name);
        return m.matches();
    }

    public String getNameFor(File file) {
        String result = (String)this.fileNameMap.get(file);
        if (result == null) {
            throw new IllegalArgumentException("File didn't come from this FileStorageModel");
        }
        return result;
    }

    private synchronized void maybeCreateFileNameMap() {
        if (this.fileNameMap == null) {
            this.fileNameMap = new HashMap();
        }
    }

    public File getFileFor(String name, ProgressMonitor monitor) throws FileNotFoundException, IOException {
        FileObject o = this.root.getFileObject(name);
        File file = o.getFile(monitor);
        this.maybeCreateFileNameMap();
        this.fileNameMap.put(file, name);
        return file;
    }

    public File[] getFilesFor(DatumRange targetRange, ProgressMonitor monitor) throws IOException {
        String[] names = this.getNamesFor(targetRange);
        File[] files = new File[names.length];
        this.maybeCreateFileNameMap();
        if (names.length > 0) {
            monitor.setTaskSize(names.length * 10);
        }
        for (int i = 0; i < names.length; ++i) {
            try {
                files[i] = this.getFileFor(names[i], SubTaskMonitor.create(monitor, i * 10, (i + 1) * 10));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return files;
    }

    private static int countGroups(String regex) {
        boolean result = false;
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher("");
        return m.groupCount();
    }

    public static String getParentRegex(String regex) {
        String dirRegex;
        String[] s = regex.split("/");
        if (s.length > 1) {
            dirRegex = s[0];
            for (int i = 1; i < s.length - 2; ++i) {
                dirRegex = dirRegex + "/" + s[i];
            }
        } else {
            dirRegex = null;
        }
        String fileRegex = s[s.length - 1];
        return dirRegex;
    }

    public static FileStorageModel create(FileSystem root, String regex, int[] digitList) {
        FileStorageModel parentModel;
        String parentRegex = FileStorageModel.getParentRegex(regex);
        if (parentRegex != null) {
            int parentGroupsCount = FileStorageModel.countGroups(parentRegex);
            int[] parentDigitList = new int[parentGroupsCount];
            for (int i = 0; i < parentGroupsCount; ++i) {
                parentDigitList[i] = digitList[i];
            }
            parentModel = FileStorageModel.create(root, parentRegex, parentDigitList);
        } else {
            parentModel = null;
        }
        return FileStorageModel.create(parentModel, root, regex, digitList);
    }

    public static FileStorageModel create(FileSystem root, String template) {
        if (template.startsWith("/")) {
            template = template.substring(1);
        }
        String[] s = template.split("%");
        char[] valid_formatCodes = new char[]{'Y', 'y', 'j', 'm', 'd', 'H', 'M', 'S', 'v', 'V', 'x', 'b'};
        String[] formatName = new String[]{"Year", "2-digit-year", "day-of-year", "month", "day", "Hour", "Minute", "Second", "version", "Version", "date", "month-name"};
        int[] formatCode_lengths = new int[]{4, 2, 3, 2, 2, 2, 2, 2, -1, -1, -1, -1};
        int[] formatDigit = new int[]{100, 101, 104, 102, 103, 105, 106, 107, 300, 300, 300, 108};
        int n = s.length;
        StringBuffer regex = new StringBuffer(100);
        regex.append(s[0]);
        int[] positions = new int[20];
        positions[0] = 0;
        int[] dateFormat = new int[n - 1];
        int[] p = new int[20];
        p[0] = 0;
        p[1] = s[0].length();
        boolean versioning = false;
        for (int i = 1; i < n; ++i) {
            char firstChar = s[i].charAt(0);
            int len = -1;
            char fc = s[i].charAt(0);
            int index = -1;
            for (int j = 0; j < valid_formatCodes.length; ++j) {
                if (valid_formatCodes[j] != fc) continue;
                index = j;
            }
            String cc = s[i].substring(1);
            if (index == -1) {
                throw new IllegalArgumentException("invalid format code: " + fc);
            }
            String fieldName = formatName[index];
            if (len == -1) {
                len = formatCode_lengths[index];
            }
            if (len == -1 && cc.equals("") && i < n - 1) {
                throw new IllegalArgumentException("invalid variable specification, need non-null constant string to delineate");
            }
            if (fc == 'v' || fc == 'V') {
                versioning = true;
            }
            String dots = ".........";
            regex.append("(" + dots.substring(0, len) + ")");
            regex.append(cc);
            dateFormat[i - 1] = formatDigit[index];
            p[i + 1] = p[i] + s[i].length() + 1;
            positions[i] = p[i + 1] - cc.length();
        }
        return FileStorageModel.create(root, regex.toString(), dateFormat);
    }

    public FileStorageModel(FileStorageModel parent, FileSystem root, String regex, FieldHandler[] handlers) {
        this.root = root;
        this.parent = parent;
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
        this.fieldHandlers = handlers;
    }

    private static FileStorageModel create(FileStorageModel parent, FileSystem root, String regex, int[] digitList) {
        FieldHandler[] handlers = FileStorageModel.getHandlers(digitList);
        FileStorageModel result = new FileStorageModel(parent, root, regex, handlers);
        result.checkArgs(regex, digitList);
        return result;
    }

    public String toString() {
        return String.valueOf(this.root) + this.regex;
    }

    public FileSystem getFileSystem() {
        return this.root;
    }

    public void setFileWidth(int multiplier, char digitCode) {
        int widthCode = -1;
        switch (digitCode) {
            case 'Y': {
                widthCode = 1;
                break;
            }
            case 'm': {
                widthCode = 2;
                break;
            }
            case 'd': {
                widthCode = 3;
                break;
            }
            case 'H': {
                widthCode = 4;
                break;
            }
            case 'M': {
                widthCode = 5;
                break;
            }
            case 'S': {
                widthCode = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad digit code: " + digitCode + ", must be Y,m,d,H,M,or S");
            }
        }
        this.timeWidthMultiplier = multiplier;
        this.timeWidth = widthCode;
    }

    public static abstract class IntegerFieldHandler
    implements FieldHandler {
        public void handle(String s, TimeUtil.TimeStruct ts1, TimeUtil.TimeStruct ts2) {
            this.handleInt(Integer.parseInt(s), ts1, ts2);
        }

        abstract void handleInt(int var1, TimeUtil.TimeStruct var2, TimeUtil.TimeStruct var3);

        public abstract String format(TimeUtil.TimeStruct var1, TimeUtil.TimeStruct var2);
    }

    public static interface FieldHandler {
        public void handle(String var1, TimeUtil.TimeStruct var2, TimeUtil.TimeStruct var3);

        public String format(TimeUtil.TimeStruct var1, TimeUtil.TimeStruct var2);
    }
}

