/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.UnitsUtil;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.TickVDescriptor;

public class ZoomPanMouseModule
extends MouseModule {
    DasAxis xAxis;
    DasAxis yAxis;
    DasAxis.Lock xAxisLock;
    DasAxis.Lock yAxisLock;
    Point p0;
    DatumRange xAxisRange0;
    DatumRange yAxisRange0;
    long t0;
    long tbirth;

    public ZoomPanMouseModule(DasCanvasComponent parent, DasAxis horizontalAxis, DasAxis verticalAxis) {
        super(parent);
        this.setLabel("Zoom Pan");
        this.xAxis = horizontalAxis;
        this.yAxis = verticalAxis;
        this.t0 = System.nanoTime();
        this.tbirth = System.nanoTime();
    }

    private boolean axisIsAdjustable(DasAxis axis) {
        return axis != null && (UnitsUtil.isIntervalMeasurement(axis.getUnits()) || UnitsUtil.isRatioMeasurement(axis.getUnits()));
    }

    private Pos position(DasDevicePosition ddp, int pos, int threshold) {
        int min;
        int max = ddp.getDMaximum();
        if ((max - (min = ddp.getDMinimum())) / threshold < 3) {
            threshold = (max - min) / 3;
        }
        if (pos < min) {
            return Pos.beyondMin;
        }
        if (pos < min + threshold) {
            return Pos.min;
        }
        if (pos <= max - threshold) {
            return Pos.middle;
        }
        if (pos <= max) {
            return Pos.max;
        }
        return Pos.beyondMax;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int i;
        DatumRange dr;
        double nmax;
        double nmin;
        double xshift = 0.0;
        double yshift = 0.0;
        if (e.isControlDown() || e.isShiftDown()) {
            if (this.xAxis != null && this.yAxis != null) {
                return;
            }
            if (e.getWheelRotation() < 0) {
                nmin = -0.2;
                nmax = 0.8;
            } else {
                nmin = 0.2;
                nmax = 1.2;
            }
        } else {
            Pos ypos;
            Point ep = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            Pos xpos = this.xAxis == null ? Pos._null : this.position(this.xAxis.getColumn(), ep.x, 20);
            Pos pos = ypos = this.yAxis == null ? Pos._null : this.position(this.yAxis.getRow(), ep.y, 20);
            if (e.getWheelRotation() < 0) {
                nmin = 0.2;
                nmax = 0.8;
            } else {
                nmin = -0.25;
                nmax = 1.25;
            }
            switch (xpos) {
                case min: {
                    xshift = -nmin;
                    break;
                }
                case max: {
                    xshift = nmin;
                }
            }
            switch (ypos) {
                case min: {
                    yshift = nmin;
                    break;
                }
                case max: {
                    yshift = -nmin;
                }
            }
        }
        int clickMag = 1;
        long t1 = System.nanoTime();
        long limitNanos = 20000000L;
        if ((t1 - this.t0) / (long)clickMag < limitNanos) {
            clickMag = (int)Math.floor((t1 - this.t0) / limitNanos);
        }
        if (clickMag == 0) {
            return;
        }
        this.t0 = System.nanoTime();
        if (this.axisIsAdjustable(this.xAxis)) {
            dr = this.xAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.xAxis.isLog() ? DatumRangeUtil.rescaleLog(dr, nmin + xshift, nmax + xshift) : DatumRangeUtil.rescale(dr, nmin + xshift, nmax + xshift);
            }
            this.xAxis.setDatumRange(dr);
        }
        if (this.axisIsAdjustable(this.yAxis)) {
            dr = this.yAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.yAxis.isLog() ? DatumRangeUtil.rescaleLog(dr, nmin + yshift, nmax + yshift) : DatumRangeUtil.rescale(dr, nmin + yshift, nmax + yshift);
            }
            this.yAxis.setDatumRange(dr);
        }
        super.mouseWheelMoved(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.xAxis != null) {
            this.xAxisLock.unlock();
            this.xAxisLock = null;
        }
        if (this.yAxis != null) {
            this.yAxisLock.unlock();
            this.yAxisLock = null;
        }
        this.doPan(e, false);
        this.parent.getCanvas().getGlassPane().setCursor(null);
    }

    private static DatumRange doRound(DatumRange dr, DasAxis axis) {
        TickVDescriptor ticks = dr.getUnits() instanceof TimeLocationUnits ? TickVDescriptor.bestTickVTime(dr.min(), dr.max(), axis.getDLength() / 2, axis.getDLength(), true) : (axis.isLog() ? TickVDescriptor.bestTickVLogNew(dr.min(), dr.max(), axis.getDLength() / 2, axis.getDLength(), true) : TickVDescriptor.bestTickVLinear(dr.min(), dr.max(), axis.getDLength() / 2, axis.getDLength(), true));
        return ticks.enclosingRange(dr, true);
    }

    private void doPan(MouseEvent e, boolean round) {
        DatumRange dr;
        Point p2 = e.getPoint();
        if (this.axisIsAdjustable(this.xAxis)) {
            Datum delta;
            if (this.xAxis.isLog()) {
                delta = this.xAxis.invTransform(this.p0.getX()).divide(this.xAxis.invTransform(p2.getX()));
                dr = new DatumRange(this.xAxisRange0.min().multiply(delta), this.xAxisRange0.max().multiply(delta));
            } else {
                delta = this.xAxis.invTransform(this.p0.getX()).subtract(this.xAxis.invTransform(p2.getX()));
                dr = new DatumRange(this.xAxisRange0.min().add(delta), this.xAxisRange0.max().add(delta));
            }
            if (round) {
                dr = ZoomPanMouseModule.doRound(dr, this.xAxis);
            }
            this.xAxis.setDatumRange(dr);
        }
        if (this.axisIsAdjustable(this.yAxis)) {
            Datum ydelta;
            if (this.yAxis.isLog()) {
                ydelta = this.yAxis.invTransform(this.p0.getY()).divide(this.yAxis.invTransform(p2.getY()));
                dr = new DatumRange(this.yAxisRange0.min().multiply(ydelta), this.yAxisRange0.max().multiply(ydelta));
            } else {
                ydelta = this.yAxis.invTransform(this.p0.getY()).subtract(this.yAxis.invTransform(p2.getY()));
                dr = new DatumRange(this.yAxisRange0.min().add(ydelta), this.yAxisRange0.max().add(ydelta));
            }
            if (round) {
                dr = ZoomPanMouseModule.doRound(dr, this.yAxis);
            }
            this.yAxis.setDatumRange(dr);
        }
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.doPan(e, false);
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.p0 = e.getPoint();
        if (this.xAxis != null) {
            this.xAxisRange0 = this.xAxis.getDatumRange();
            this.xAxisLock = this.xAxis.mutatorLock();
            this.xAxisLock.lock();
        }
        if (this.yAxis != null) {
            this.yAxisRange0 = this.yAxis.getDatumRange();
            this.yAxisLock = this.yAxis.mutatorLock();
            this.yAxisLock.lock();
        }
        this.parent.getCanvas().getGlassPane().setCursor(new Cursor(12));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Pos {
        _null,
        beyondMin,
        min,
        middle,
        max,
        beyondMax;

    }
}

