/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.MouseModule;
import org.das2.event.MousePointSelectionEvent;
import org.das2.event.VerticalSliceSelectionRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;

public class VerticalSlicerMouseModule
extends MouseModule {
    private DataSet ds;
    double offset;
    private DasAxis xaxis;
    private DasAxis yaxis;
    private DataSetConsumer dataSetConsumer;
    private DataPointSelectionEvent de;
    private EventListenerList listenerList = null;

    public VerticalSlicerMouseModule(DasCanvasComponent parent, DataSetConsumer dataSetConsumer, DasAxis xaxis, DasAxis yaxis) {
        super(parent, new VerticalSliceSelectionRenderer(parent), "Vertical Slice");
        this.dataSetConsumer = dataSetConsumer;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static VerticalSlicerMouseModule create(DasPlot parent) {
        DasAxis xaxis = parent.getXAxis();
        DasAxis yaxis = parent.getYAxis();
        return new VerticalSlicerMouseModule(parent, parent, xaxis, yaxis);
    }

    public static VerticalSlicerMouseModule create(Renderer renderer) {
        DasPlot parent = renderer.getParent();
        return new VerticalSlicerMouseModule(parent, renderer, parent.getXAxis(), parent.getYAxis());
    }

    public void mousePointSelected(MousePointSelectionEvent e) {
        this.de.birthMilli = System.currentTimeMillis();
        this.ds = this.dataSetConsumer.getConsumedDataSet();
        this.de.set(this.xaxis.invTransform(e.getX()), this.yaxis.invTransform(e.getY()));
        this.de.setDataSet(this.ds);
        this.fireDataPointSelectionListenerDataPointSelected(this.de);
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(DataPointSelectionListener.class, listener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList.remove(DataPointSelectionListener.class, listener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }
}

