/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import javax.swing.event.EventListenerList;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.event.Gesture;
import org.das2.event.HorizontalRangeGesturesRenderer;
import org.das2.event.MouseModule;
import org.das2.event.MouseRangeSelectionEvent;
import org.das2.event.TimeRangeSelectionEvent;
import org.das2.event.TimeRangeSelectionListener;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasPlot;
import org.das2.system.DasLogger;

public class TimeRangeSelectorMouseModule
extends MouseModule {
    DasAxis timeAxis;
    private EventListenerList listenerList = null;

    public String getLabel() {
        return "X Time Zoom";
    }

    public TimeRangeSelectorMouseModule(DasCanvasComponent parent, DasAxis timeAxis) {
        this.parent = parent;
        this.dragRenderer = new HorizontalRangeGesturesRenderer(parent);
        this.timeAxis = timeAxis;
    }

    public static TimeRangeSelectorMouseModule create(DasPlot parent) {
        DasAxis axis = parent.getXAxis();
        TimeRangeSelectorMouseModule result = null;
        result = new TimeRangeSelectorMouseModule(parent, parent.getXAxis());
        return result;
    }

    public void mouseRangeSelected(MouseRangeSelectionEvent e0) {
        if (!e0.isGesture()) {
            Datum nnMax;
            MouseRangeSelectionEvent e = e0;
            Datum min = this.timeAxis.invTransform(e.getMinimum());
            Datum max = this.timeAxis.invTransform(e.getMaximum());
            Datum nnMin = this.timeAxis.findTick(min, 0.0, true);
            if (nnMin.equals(nnMax = this.timeAxis.findTick(max, 0.0, true))) {
                min = this.timeAxis.findTick(min, -1.0, true);
                max = this.timeAxis.findTick(max, 1.0, true);
            } else {
                min = nnMin;
                max = nnMax;
            }
            TimeRangeSelectionEvent te = new TimeRangeSelectionEvent(this.parent, new DatumRange(min, max));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(te);
        } else if (e0.getGesture() == Gesture.BACK) {
            this.timeAxis.setDataRangePrev();
        } else if (e0.getGesture() == Gesture.ZOOMOUT) {
            this.timeAxis.setDataRangeZoomOut();
        } else if (e0.getGesture() == Gesture.FORWARD) {
            this.timeAxis.setDataRangeForward();
        } else if (e0.getGesture() == Gesture.SCANPREV) {
            DatumRange range0 = this.timeAxis.getDatumRange();
            TimeRangeSelectionEvent te = new TimeRangeSelectionEvent(this.parent, range0.previous());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(te);
        } else if (e0.getGesture() == Gesture.SCANNEXT) {
            DatumRange range0 = this.timeAxis.getDatumRange();
            TimeRangeSelectionEvent te = new TimeRangeSelectionEvent(this.parent, range0.next());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(te);
        } else {
            throw new RuntimeException("unrecognized gesture: " + e0.getGesture());
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(TimeRangeSelectionListener.class, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.listenerList.remove(TimeRangeSelectionListener.class, listener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TimeRangeSelectionListener.class) continue;
            String logmsg = "fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event;
            DasLogger.getLogger(DasLogger.GUI_LOG).fine(logmsg);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }
}

