/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.das2.event.DragRenderer;
import org.das2.event.MouseDragEvent;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.DasLogger;
import org.das2.util.GrannyTextRenderer;

public class LabelDragRenderer
implements DragRenderer {
    String label = "Label not set";
    GrannyTextRenderer gtr;
    DasCanvasComponent parent;
    InfoLabel infoLabel;
    int labelPositionX = 1;
    int labelPositionY = -1;
    Rectangle dirtyBounds;
    Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    int maxLabelWidth;
    ArrayList newDirtyBounds;
    boolean tooltip = false;

    public void clear(Graphics g) {
        if (this.dirtyBounds != null) {
            this.parent.paintImmediately(this.dirtyBounds);
        }
        this.dirtyBounds = null;
    }

    public LabelDragRenderer(DasCanvasComponent parent) {
        this.parent = parent;
        this.dirtyBounds = new Rectangle();
        this.gtr = new GrannyTextRenderer();
    }

    public MouseDragEvent getMouseDragEvent(Object source, Point p1, Point p2, boolean isModified) {
        this.maxLabelWidth = 0;
        if (this.tooltip && this.infoLabel != null) {
            this.infoLabel.hide();
        }
        return null;
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    private Rectangle paintLabel(Graphics g1, Point p2) {
        if (this.label == null) {
            return null;
        }
        Graphics2D g = (Graphics2D)g1;
        g.setClip(null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension d = this.parent.getCanvas().getSize();
        this.gtr.setString(g1, this.label);
        int dx = (int)this.gtr.getWidth() + 6;
        int dy = (int)this.gtr.getHeight();
        if (this.maxLabelWidth < dx) {
            this.maxLabelWidth = dx;
        }
        this.labelPositionX = p2.x + this.maxLabelWidth > d.width && p2.x - 3 - dx > 0 ? -1 : 1;
        int xp = this.labelPositionX == 1 ? p2.x + 3 : p2.x - 3 - dx;
        this.labelPositionY = p2.y - 3 - dy < 13 ? -1 : 1;
        int yp = this.labelPositionY == 1 ? p2.y - 3 - dy : p2.y + 3;
        this.dirtyBounds = new Rectangle();
        Color color0 = g.getColor();
        g.setColor(new Color(255, 255, 255, 200));
        this.dirtyBounds.setRect(xp, yp, dx, dy);
        g.fill(this.dirtyBounds);
        g.setColor(new Color(20, 20, 20));
        this.gtr.draw(g, xp + 3, (float)((double)yp + this.gtr.getAscent()));
        g.setColor(color0);
        return this.dirtyBounds;
    }

    public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
        Rectangle[] result;
        this.logger.finest("renderDrag " + p2);
        if (this.tooltip) {
            if (this.infoLabel == null) {
                this.infoLabel = new InfoLabel();
            }
            Point p = (Point)p2.clone();
            SwingUtilities.convertPointToScreen(p, this.parent.getCanvas());
            this.infoLabel.setText(this.label, p);
            result = new Rectangle[]{};
        } else if (this.label == null) {
            result = new Rectangle[]{};
        } else {
            Rectangle r = this.paintLabel(g, p2);
            result = new Rectangle[]{r};
        }
        return result;
    }

    protected void resetDirtyBounds() {
        this.newDirtyBounds = new ArrayList();
    }

    protected void addDirtyBounds(Rectangle[] dirty) {
        if (dirty != null && dirty.length > 0) {
            this.newDirtyBounds.addAll(Arrays.asList(dirty));
        }
    }

    protected void addDirtyBounds(Rectangle dirty) {
        if (dirty != null) {
            this.newDirtyBounds.add(dirty);
        }
    }

    protected Rectangle[] getDirtyBounds() {
        return this.newDirtyBounds.toArray(new Rectangle[this.newDirtyBounds.size()]);
    }

    public boolean isTooltip() {
        return this.tooltip;
    }

    public void setTooltip(boolean tooltip) {
        this.tooltip = tooltip;
        if (tooltip) {
            this.labelPositionX = 1;
            this.labelPositionY = -1;
        }
    }

    private class InfoLabel {
        JWindow window;
        JPanel label;
        GrannyTextRenderer gtr;
        JPanel containedPanel;
        JComponent glassPane;
        boolean contained = true;

        private InfoLabel() {
        }

        void init() {
            Window root = (Window)SwingUtilities.getRoot(LabelDragRenderer.this.parent);
            this.window = new JWindow(root);
            this.label = new JPanel(){

                public void paintComponent(Graphics g) {
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    InfoLabel.this.gtr.draw(g, 0.0f, (int)InfoLabel.this.gtr.getAscent());
                }
            };
            this.label.setOpaque(true);
            this.label.setPreferredSize(new Dimension(300, 20));
            this.window.getContentPane().add(this.label);
            this.window.pack();
            this.gtr = new GrannyTextRenderer();
            this.glassPane = (JComponent)LabelDragRenderer.this.parent.getCanvas().getGlassPane();
            this.containedPanel = new JPanel(){

                public void paintComponent(Graphics g) {
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    InfoLabel.this.gtr.draw(g, 0.0f, (int)InfoLabel.this.gtr.getAscent());
                }
            };
            this.containedPanel.setVisible(false);
            this.glassPane.add(this.containedPanel);
            this.contained = true;
        }

        void setText(String text, Point p) {
            if (this.window == null) {
                this.init();
            }
            if (text != null) {
                this.gtr.setString(this.containedPanel.getFont(), text);
                Rectangle rect = this.gtr.getBounds();
                int posx = p.x + LabelDragRenderer.this.labelPositionX * 3 + Math.min(LabelDragRenderer.this.labelPositionX, 0) * rect.width;
                int posy = p.y + LabelDragRenderer.this.labelPositionY * 3 + Math.min(LabelDragRenderer.this.labelPositionY, 0) * rect.height;
                Rectangle bounds = this.gtr.getBounds();
                Point p2 = new Point(posx, posy);
                SwingUtilities.convertPointFromScreen(p2, this.glassPane);
                bounds.translate(p2.x, p2.y);
                this.contained = this.glassPane.getBounds().contains(bounds);
                if (this.contained) {
                    this.containedPanel.setSize(new Dimension(rect.width, rect.height));
                    this.containedPanel.setLocation(p2.x, p2.y);
                    this.window.setVisible(false);
                    this.containedPanel.setVisible(true);
                    this.containedPanel.repaint();
                } else {
                    this.gtr.setString(this.label.getFont(), text);
                    rect = this.gtr.getBounds();
                    this.window.setSize(new Dimension(rect.width, rect.height));
                    posx = p.x + LabelDragRenderer.this.labelPositionX * 3 + Math.min(LabelDragRenderer.this.labelPositionX, 0) * rect.width;
                    posy = p.y + LabelDragRenderer.this.labelPositionY * 3 + Math.min(LabelDragRenderer.this.labelPositionY, 0) * rect.height;
                    this.containedPanel.setVisible(false);
                    this.window.setLocation(posx, posy);
                    this.window.setVisible(true);
                    this.window.repaint();
                }
            } else {
                this.hide();
            }
        }

        void hide() {
            if (this.window == null) {
                this.init();
            }
            if (this.contained) {
                this.containedPanel.setVisible(false);
            } else {
                this.window.setVisible(false);
            }
        }
    }
}

