/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.das2.dataset.ClippedTableDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.event.BoxGesturesRenderer;
import org.das2.event.MouseBoxEvent;
import org.das2.event.MouseDragEvent;
import org.das2.event.MouseModule;
import org.das2.graph.DasPlot;
import org.das2.graph.Renderer;
import org.das2.util.DasExceptionHandler;

public class DisplayDataMouseModule
extends MouseModule {
    static final String LABEL = "Display Data";
    DasPlot plot;
    static JFrame myFrame;
    static JPanel myPanel;
    static JEditorPane myEdit;
    private boolean yclip = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DisplayDataMouseModule(DasPlot parent) {
        super(parent, new BoxGesturesRenderer(parent), LABEL);
        this.plot = parent;
    }

    private void maybeCreateFrame() {
        if (myFrame == null) {
            myFrame = new JFrame(LABEL);
            myPanel = new JPanel();
            myPanel.setPreferredSize(new Dimension(300, 300));
            myPanel.setLayout(new BorderLayout());
            myEdit = new JEditorPane();
            myEdit.setFont(Font.decode("fixed-10"));
            JScrollPane scrollPane = new JScrollPane(myEdit, 20, 30);
            myPanel.add((Component)scrollPane, "Center");
            myFrame.getContentPane().add(myPanel);
            myFrame.pack();
        }
    }

    private String unitsStr(Units u) {
        return u == Units.dimensionless ? "" : "(" + u.toString() + ")";
    }

    public void mouseRangeSelected(MouseDragEvent e0) {
        if (e0.isGesture()) {
            return;
        }
        this.maybeCreateFrame();
        myFrame.setVisible(true);
        MouseBoxEvent e = (MouseBoxEvent)e0;
        DatumRange xrange = this.plot.getXAxis().isFlipped() ? new DatumRange(this.plot.getXAxis().invTransform(e.getXMaximum()), this.plot.getXAxis().invTransform(e.getXMinimum())) : new DatumRange(this.plot.getXAxis().invTransform(e.getXMinimum()), this.plot.getXAxis().invTransform(e.getXMaximum()));
        DatumRange yrange = this.plot.getYAxis().isFlipped() ? new DatumRange(this.plot.getYAxis().invTransform(e.getYMinimum()), this.plot.getYAxis().invTransform(e.getYMaximum())) : new DatumRange(this.plot.getYAxis().invTransform(e.getYMaximum()), this.plot.getYAxis().invTransform(e.getYMinimum()));
        Renderer[] rends = this.plot.getRenderers();
        Document doc = myEdit.getDocument();
        try {
            AttributeSet attrSet = null;
            doc.remove(0, doc.getLength());
            for (int irend = 0; irend < rends.length; ++irend) {
                int j;
                DatumFormatter df;
                doc.insertString(doc.getLength(), "Renderer #" + irend + "\n", attrSet);
                DataSet ds = rends[irend].getDataSet();
                if (ds == null) {
                    doc.insertString(doc.getLength(), "(no dataset)\n", attrSet);
                }
                DatumRange rx1 = xrange;
                DatumRange ry1 = yrange;
                if (ds != null) {
                    if (!rx1.getUnits().isConvertableTo(ds.getXUnits())) {
                        rx1 = DataSetUtil.xRange(ds);
                    }
                    if (!ry1.getUnits().isConvertableTo(ds.getYUnits())) {
                        ry1 = DataSetUtil.yRange(ds);
                    }
                }
                if (ds instanceof TableDataSet) {
                    TableDataSet tds = (TableDataSet)ds;
                    ClippedTableDataSet toutds = new ClippedTableDataSet(tds, rx1, ry1);
                    StringBuffer buf = new StringBuffer();
                    Units zunits = tds.getZUnits();
                    df = (DatumFormatter)tds.getProperty("formatter");
                    if (df == null) {
                        df = tds.getDatum(0, 0).getFormatter();
                    }
                    buf.append("TableDataSet " + toutds.getXLength() + "x" + toutds.getYLength(0) + " " + this.unitsStr(zunits) + "\n");
                    for (int i = 0; i < toutds.getXLength(); ++i) {
                        for (int j2 = 0; j2 < toutds.getYLength(0); ++j2) {
                            try {
                                buf.append(df.format(toutds.getDatum(i, j2), zunits));
                                buf.append(" ");
                                continue;
                            }
                            catch (IndexOutOfBoundsException ex) {
                                System.err.println("here");
                            }
                        }
                        buf.append("\n");
                    }
                    doc.insertString(doc.getLength(), buf.toString(), attrSet);
                    continue;
                }
                if (!(ds instanceof VectorDataSet)) continue;
                VectorDataSet vds = (VectorDataSet)ds;
                Units units = vds.getYUnits();
                Units xunits = vds.getXUnits();
                StringBuffer buf = new StringBuffer();
                df = vds.getDatum(0).getFormatter();
                DatumFormatter xdf = vds.getXTagDatum(0).getFormatter();
                String[] planes = vds.getPlaneIds();
                VectorDataSet[] vdss = new VectorDataSet[planes.length];
                for (j = 0; j < planes.length; ++j) {
                    vdss[j] = (VectorDataSet)vds.getPlanarView(planes[j]);
                }
                if (planes.length > 1) {
                    buf.append("X" + this.unitsStr(xunits) + "\t");
                    buf.append("Y" + this.unitsStr(units) + "\t");
                    for (j = 0; j < vdss.length; ++j) {
                        if (planes[j].equals("")) continue;
                        buf.append("" + planes[j] + "" + this.unitsStr(vdss[j].getYUnits()) + "\t");
                    }
                    buf.append("\n");
                }
                VectorDataSetBuilder builder = new VectorDataSetBuilder(vds.getXUnits(), vds.getYUnits());
                for (int i = 0; i < vds.getXLength(); ++i) {
                    if (!xrange.contains(vds.getXTagDatum(i)) || this.yclip && !yrange.contains(vds.getDatum(i))) continue;
                    buf.append(xdf.format(vds.getXTagDatum(i), xunits) + "\t" + df.format(vds.getDatum(i), units));
                    for (int j3 = 0; j3 < planes.length; ++j3) {
                        if (planes[j3].equals("")) continue;
                        Units u = vdss[j3].getYUnits();
                        if (UnitsUtil.isIntervalMeasurement(u) || UnitsUtil.isRatioMeasurement(u)) {
                            buf.append("\t" + df.format(vdss[j3].getDatum(i), vdss[j3].getYUnits()));
                            continue;
                        }
                        buf.append("\t" + vdss[j3].getDatum(i));
                    }
                    buf.append("\n");
                }
                doc.insertString(doc.getLength(), buf.toString(), attrSet);
            }
        }
        catch (BadLocationException ex) {
            DasExceptionHandler.handle(ex);
        }
    }

    public String getListLabel() {
        return this.getLabel();
    }

    public Icon getListIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/icons/showDataMouseModule.png"));
        return icon;
    }

    public String getLabel() {
        return LABEL;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isYclip() {
        return this.yclip;
    }

    public void setYclip(boolean yclip) {
        boolean oldYclip = this.yclip;
        this.yclip = yclip;
        this.propertyChangeSupport.firePropertyChange("yclip", new Boolean(oldYclip), new Boolean(yclip));
    }
}

