/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Color;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.dataset.AverageTableRebinner;
import org.das2.dataset.ClippedTableDataSet;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.DataSetUtil;
import org.das2.dataset.DefaultVectorDataSet;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.SingleVectorDataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.DataPointSelectorMouseModule;
import org.das2.event.HorizontalSliceSelectionRenderer;
import org.das2.event.VerticalSliceSelectionRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.SymbolLineRenderer;
import org.das2.util.monitor.ProgressMonitor;

public class CutoffMouseModule
extends BoxSelectorMouseModule {
    DasAxis xaxis;
    DasAxis yaxis;
    DataSetConsumer dataSetConsumer;
    DatumRange xrange;
    DatumRange yrange;
    String lastComment;
    CutoffSlicer cutoffSlicer;
    DasApplication application;
    public static final String CONFIG_VOYAGER_HR_LOWER = "Ondrej: min=-4. slopeMin=0.26 nave=3 cutoff=lower xres=1s";
    public static final String CONFIG_GALILEO_LOWER = "Ondrej: min=1.78 slopeMin=0.072 nave=3 cutoff=lower xres=120s";
    public static final String CONFIG_GALILEO_LOWER_60 = "Ondrej: min=1.78 slopeMin=0.072 nave=3 cutoff=lower xres=60s";
    public static final String CONFIG_GALILEO_LOWER_30 = "Ondrej: min=1.78 slopeMin=0.072 nave=3 cutoff=lower xres=30s";
    private transient ArrayList dataSetUpdateListenerList;
    private Datum slopeMin = Units.dimensionless.createDatum(0.26);
    private Datum levelMin = Units.dimensionless.createDatum(-4.0);
    private int nave = 3;
    private Datum xResolution = Units.milliseconds.createDatum(1000);
    private boolean lowCutoff;
    private EventListenerList listenerList = null;

    public CutoffMouseModule(DasPlot parent, DataSetConsumer consumer) {
        super(parent, parent.getXAxis(), parent.getYAxis(), consumer, new BoxRenderer(parent, true), "Cutoff");
        this.application = parent.getCanvas().getApplication();
        this.dataSetConsumer = consumer;
    }

    public void setConfig(String config) throws ParseException {
        if (!config.startsWith("Ondrej:")) {
            throw new IllegalArgumentException("config must start with Ondrej");
        }
        Pattern p = Pattern.compile("(\\S+)=(\\S+)");
        Matcher m = p.matcher(config.substring(7));
        while (m.find()) {
            String name = m.group(1);
            String sval = m.group(2);
            if (name.equals("min")) {
                this.setLevelMin(Units.dimensionless.parse(sval));
                continue;
            }
            if (name.equals("slopeMin")) {
                this.setSlopeMin(Units.dimensionless.parse(sval));
                continue;
            }
            if (name.equals("nave")) {
                this.setNave(Integer.parseInt(sval));
                continue;
            }
            if (name.equals("cutoff")) {
                this.setLowCutoff("lower".equals(sval));
                continue;
            }
            if (!name.equals("xres")) continue;
            this.setXResolution(Units.seconds.parse(sval));
        }
    }

    protected void fireBoxSelectionListenerBoxSelected(BoxSelectionEvent event) {
        DatumRange xrange0 = this.xrange;
        DatumRange yrange0 = this.yrange;
        this.xrange = event.getXRange();
        this.yrange = event.getYRange();
        this.lastComment = event.getPlane("keyChar") != null ? (String)event.getPlane("keyChar") : null;
        try {
            this.recalculateSoon();
        }
        catch (RuntimeException ex) {
            this.xrange = xrange0;
            this.yrange = yrange0;
            throw ex;
        }
    }

    private RebinDescriptor getRebinDescriptor(DatumRange range) {
        double res = this.xResolution.doubleValue(Units.microseconds);
        double min = range.min().doubleValue(Units.us2000);
        min = Math.floor(min / res);
        double max = range.max().doubleValue(Units.us2000);
        max = Math.ceil(max / res);
        int nbin = (int)(max - min);
        RebinDescriptor ddx = new RebinDescriptor(min * res, max * res, Units.us2000, nbin, false);
        return ddx;
    }

    private void recalculateSoon() {
        Runnable run = new Runnable(){

            public void run() {
                ProgressMonitor mon = CutoffMouseModule.this.application.getMonitorFactory().getMonitor(CutoffMouseModule.this.parent, "calculating cutoffs", "calculating cutoffs");
                CutoffMouseModule.this.recalculate(mon);
            }
        };
        new Thread(run, "digitizer recalculate").start();
    }

    private synchronized void recalculate(ProgressMonitor mon) {
        TableDataSet tds = (TableDataSet)this.dataSetConsumer.getConsumedDataSet();
        if (tds == null) {
            return;
        }
        if (this.xrange == null) {
            return;
        }
        tds = new ClippedTableDataSet(tds, this.xrange, this.yrange);
        AverageTableRebinner rebinner = new AverageTableRebinner();
        DatumRange range = DataSetUtil.xRange(tds);
        RebinDescriptor ddx = this.getRebinDescriptor(range);
        try {
            tds = (TableDataSet)rebinner.rebin(tds, ddx, null);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
        VectorDataSetBuilder builder = new VectorDataSetBuilder(tds.getXUnits(), tds.getYUnits());
        mon.setTaskSize(tds.getXLength());
        mon.started();
        for (int i = 0; i < tds.getXLength(); ++i) {
            mon.setTaskProgress(i);
            if (mon.isCancelled()) break;
            VectorDataSet spec = DataSetUtil.log10(tds.getXSlice(i));
            int icutoff = this.cutoff(spec, this.slopeMin, this.nave, this.isLowCutoff() ? 1 : -1, this.levelMin);
            if (icutoff > -1) {
                builder.insertY(tds.getXTagDatum(i), tds.getYTagDatum(tds.tableOfIndex(i), icutoff));
                continue;
            }
            Units yunits = tds.getYUnits();
            builder.insertY(tds.getXTagDatum(i), yunits.createDatum(yunits.getFillDouble()));
        }
        mon.finished();
        if (mon.isCancelled()) {
            return;
        }
        String comment = "Ondrej:" + this.levelMin + ":" + this.slopeMin + ":" + this.nave;
        if (this.lastComment != null) {
            comment = this.lastComment + " " + comment;
        }
        builder.setProperty("comment", comment);
        builder.setProperty("xTagWidth", this.xResolution);
        VectorDataSet vds = builder.toVectorDataSet();
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent((Object)this, (DataSet)vds));
    }

    public int cutoff(VectorDataSet ds, Datum slopeMin, int nave, int mult, Datum levelMin) {
        int j;
        int nfr = ds.getXLength();
        if (nfr < nave + 1) {
            throw new IllegalArgumentException("DataSet doesn't contain enough elements");
        }
        double[] cumul = new double[nfr];
        Units units = ds.getYUnits();
        double level = levelMin.doubleValue(units);
        double slope = slopeMin.doubleValue(units);
        cumul[0] = ds.getDouble(0, units);
        for (int i = 1; i < nfr; ++i) {
            cumul[i] = cumul[i - 1] + ds.getDouble(i, units);
        }
        boolean[] icof = new boolean[nfr];
        VectorDataSetBuilder levelBuilder = new VectorDataSetBuilder(ds.getXUnits(), units);
        VectorDataSetBuilder slopeBuilder = new VectorDataSetBuilder(ds.getXUnits(), units);
        VectorDataSetBuilder icofBuilder = new VectorDataSetBuilder(ds.getXUnits(), Units.dimensionless);
        for (int i = 1; i < nfr; ++i) {
            icof[i] = true;
        }
        icof[0] = false;
        icof[nfr - 1] = false;
        for (int k = 1; k <= nave; ++k) {
            int j2;
            double[] ave = new double[nfr];
            ave[0] = cumul[k - 1] / (double)k;
            for (j2 = 0; j2 < nfr - k; ++j2) {
                ave[j2 + 1] = (cumul[j2 + k] - cumul[j2]) / (double)k;
                levelBuilder.insertY(ds.getXTagDatum(j2 + 1), units.createDatum(ave[j2 + 1]));
            }
            for (j2 = k; j2 < nfr - k; ++j2) {
                double uave;
                double slopeTest = (ave[j2 + 1] - ave[j2 - k]) / (double)k;
                slopeBuilder.insertY(ds.getXTagDatum(j2 + 1), units.createDatum(slopeTest));
                if (slopeTest * (double)mult <= slope * (double)mult) {
                    icof[j2] = false;
                }
                double d = uave = mult > 0 ? ave[j2 + k] : ave[j2];
                if (uave <= level) {
                    icof[j2] = false;
                }
                icofBuilder.insertY(ds.getXTagDatum(j2), icof[j2] ? Units.dimensionless.createDatum(1) : Units.dimensionless.createDatum(0));
            }
        }
        if (this.cutoffSlicer != null) {
            this.cutoffSlicer.slopeRenderer.setDataSet(slopeBuilder.toVectorDataSet());
            this.cutoffSlicer.levelRenderer.setDataSet(levelBuilder.toVectorDataSet());
            this.cutoffSlicer.icofRenderer.setDataSet(icofBuilder.toVectorDataSet());
        }
        int icutOff = -1;
        int n = j = mult < 0 ? nfr - 1 : 0;
        while (j >= 0 && j < nfr) {
            if (icof[j]) {
                icutOff = j;
                break;
            }
            j += mult;
        }
        return icutOff;
    }

    public DataPointSelectionListener getSlicer(DasPlot plot, TableDataSetConsumer consumer) {
        DasAxis sourceYAxis = plot.getYAxis();
        DasAxis sourceZAxis = consumer.getZAxis();
        DatumRange range = sourceYAxis.getDatumRange();
        DasAxis xAxis = sourceYAxis.createAttachedAxis(2);
        this.cutoffSlicer = new CutoffSlicer(plot, xAxis);
        return this.cutoffSlicer;
    }

    private void testCutoff() {
        double[] spec = new double[]{-12.7093, -12.8479, -13.0042, -13.1509, -13.3007, -13.4671, -13.5536, -13.6603, -13.8, -13.8873, -13.9908, -14.1162, -14.2016, -14.2694, -14.2844, -14.3126, -14.3507, -14.3841, -14.4252, -14.4779, -14.4972, -14.5226, -14.6059, -14.6517, -14.6545, -14.2863, -13.9616, -13.6898, -13.7407, -13.8821, -14.1541, -14.4287, -14.6663, -14.8647, -15.054, -15.0863, -15.119, -15.1464, -15.1479, -15.1399, -15.1284, -15.2001, -15.278, -15.3611, -15.3976, -15.423, -15.4467, -15.4879, -15.5437, -15.6058, -15.6501, -15.6606, -15.6737, -15.6867, -15.6955, -15.7425, -15.8222, -15.9376, -16.0174, -16.0091};
        double[] tags = new double[spec.length];
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = i + 1;
        }
        double slope = 0.266692;
        int nave = 3;
        int mult = this.isLowCutoff() ? 1 : -1;
        double level = -14.0;
        int icut = this.cutoff(new DefaultVectorDataSet(spec, Units.hertz, spec, Units.v2pm2Hz, new HashMap()), Units.v2pm2Hz.createDatum(slope), nave, mult, Units.v2pm2Hz.createDatum(level));
        System.out.println("icut=" + icut + "  should be 25");
    }

    public synchronized void addDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.dataSetUpdateListenerList == null) {
            this.dataSetUpdateListenerList = new ArrayList();
        }
        this.dataSetUpdateListenerList.add(listener);
    }

    public synchronized void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        if (this.dataSetUpdateListenerList != null) {
            this.dataSetUpdateListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        ArrayList list;
        CutoffMouseModule cutoffMouseModule = this;
        synchronized (cutoffMouseModule) {
            if (this.dataSetUpdateListenerList == null) {
                return;
            }
            list = (ArrayList)this.dataSetUpdateListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((DataSetUpdateListener)list.get(i)).dataSetUpdated(event);
        }
    }

    public Datum getSlopeMin() {
        return this.slopeMin;
    }

    public void setSlopeMin(Datum slopeMin) {
        Datum oldVal = this.slopeMin;
        if (!this.slopeMin.equals(slopeMin)) {
            this.slopeMin = slopeMin;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "slope", oldVal, slopeMin);
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
        }
    }

    public Datum getLevelMin() {
        return this.levelMin;
    }

    public void setLevelMin(Datum levelMin) {
        Datum oldVal = this.levelMin;
        if (!this.levelMin.equals(levelMin)) {
            this.levelMin = levelMin;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "level", oldVal, levelMin);
            this.firePropertyChangeListenerPropertyChange(e);
            levelMin.getFormatter().format(levelMin);
            this.recalculateSoon();
        }
    }

    public int getNave() {
        return this.nave;
    }

    public void setNave(int nave) {
        int oldVal = this.nave;
        if (this.nave != nave) {
            this.nave = nave;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "nave", new Integer(oldVal), new Integer(nave));
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
        }
    }

    public Datum getXResolution() {
        return this.xResolution;
    }

    public void setXResolution(Datum xResolution) {
        Datum oldVal = this.xResolution;
        if (!this.xResolution.equals(xResolution)) {
            this.xResolution = xResolution;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "timeResolution", oldVal, this.xResolution);
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
        }
    }

    public boolean isLowCutoff() {
        return this.lowCutoff;
    }

    public void setLowCutoff(boolean lowCutoff) {
        Boolean oldVal = this.lowCutoff;
        if (this.lowCutoff != lowCutoff) {
            this.lowCutoff = lowCutoff;
            PropertyChangeEvent e = new PropertyChangeEvent(this, "lowCutoff", oldVal, lowCutoff);
            this.firePropertyChangeListenerPropertyChange(e);
            this.recalculateSoon();
            if (this.cutoffSlicer != null) {
                this.cutoffSlicer.slopePlot.repaint();
            }
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PropertyChangeListener.class, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.remove(PropertyChangeListener.class, listener);
    }

    private void firePropertyChangeListenerPropertyChange(PropertyChangeEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }

    private class CutoffSlicer
    implements DataPointSelectionListener {
        DataPointSelectionEvent lastSelectedPoint;
        Datum cutoff;
        Datum yValue;
        Datum xValue;
        SymbolLineRenderer levelRenderer;
        SymbolLineRenderer contextLevelRenderer;
        SymbolLineRenderer slopeRenderer;
        SymbolLineRenderer contextSlopeRenderer;
        SymbolLineRenderer icofRenderer;
        DasPlot topPlot;
        DasPlot slopePlot;
        JFrame frame = new JFrame("Cutoff Slice");

        CutoffSlicer(DasPlot parent, DasAxis xaxis) {
            DasCanvas canvas = new DasCanvas(300, 600);
            this.frame.getContentPane().add(canvas);
            this.frame.pack();
            this.frame.setVisible(false);
            this.frame.setDefaultCloseOperation(1);
            DasColumn col = new DasColumn(canvas, null, 0.0, 1.0, 5.0, -1.5, 0, 0);
            DasRow row1 = new DasRow(canvas, null, 0.0, 0.3333333333333333, 2.0, -1.0, 0, 0);
            DasRow row2 = new DasRow(canvas, null, 0.3333333333333333, 0.6666666666666666, 1.5, -1.5, 0, 0);
            DasRow row3 = new DasRow(canvas, null, 0.6666666666666666, 1.0, 1.0, -2.0, 0, 0);
            DasPlot plot = new DasPlot(xaxis, new DasAxis(new DatumRange(-18.0, -10.0, Units.dimensionless), 3)){

                protected void drawContent(Graphics2D g) {
                    super.drawContent(g);
                    int ix = this.getColumn().getDMinimum();
                    g.setColor(Color.GRAY);
                    int iy = (int)this.getYAxis().transform(CutoffMouseModule.this.levelMin);
                    g.drawLine(ix, iy, ix + this.getWidth(), iy);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.cutoff);
                    g.drawLine(ix, 0, ix, this.getHeight());
                    g.setColor(Color.pink);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.yValue);
                    g.drawLine(ix, 0, ix, this.getHeight());
                }
            };
            plot.getYAxis().setLabel("level");
            plot.getXAxis().setTickLabelsVisible(false);
            this.levelRenderer = new SymbolLineRenderer();
            this.contextLevelRenderer = new SymbolLineRenderer();
            this.contextLevelRenderer.setColor(Color.GRAY);
            plot.addRenderer(this.contextLevelRenderer);
            plot.addRenderer(this.levelRenderer);
            this.topPlot = plot;
            DataPointSelectorMouseModule tweakSlicer = new DataPointSelectorMouseModule(this.topPlot, this.levelRenderer, new VerticalSliceSelectionRenderer(this.topPlot), "tweak cutoff");
            tweakSlicer.setDragEvents(true);
            tweakSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                public void dataPointSelected(DataPointSelectionEvent e) {
                    Datum x = e.getX();
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    if (e.getPlane("keyChar") != null) {
                        properties.put("comment", e.getPlane("keyChar"));
                    } else {
                        properties.put("comment", "tweak");
                    }
                    CutoffMouseModule.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent((Object)this, (DataSet)new SingleVectorDataSet(CutoffSlicer.this.xValue, e.getX(), properties)));
                }
            });
            this.topPlot.addMouseModule(tweakSlicer);
            this.topPlot.getDasMouseInputAdapter().setPrimaryModule(tweakSlicer);
            DataPointSelectorMouseModule levelSlicer = new DataPointSelectorMouseModule(this.topPlot, this.levelRenderer, new HorizontalSliceSelectionRenderer(this.topPlot), "cutoff level");
            levelSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                public void dataPointSelected(DataPointSelectionEvent e) {
                    Datum y = e.getY();
                    CutoffMouseModule.this.setLevelMin(y);
                }
            });
            levelSlicer.setDragEvents(false);
            levelSlicer.setKeyEvents(false);
            levelSlicer.setReleaseEvents(true);
            this.topPlot.addMouseModule(levelSlicer);
            canvas.add(plot, row1, col);
            this.slopePlot = plot = new DasPlot(xaxis.createAttachedAxis(), new DasAxis(new DatumRange(-0.3, 0.3, Units.dimensionless), 3)){

                protected void drawContent(Graphics2D g) {
                    super.drawContent(g);
                    int iy = (int)this.getYAxis().transform(CutoffMouseModule.this.slopeMin);
                    int ix = this.getColumn().getDMinimum();
                    g.setColor(Color.lightGray);
                    if (CutoffMouseModule.this.lowCutoff) {
                        g.drawString("slope greater than", ix + 3, iy);
                    } else {
                        g.drawString("slope less than", ix + 3, iy);
                    }
                    g.setColor(Color.GRAY);
                    g.drawLine(ix, iy, ix + this.getWidth(), iy);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.cutoff);
                    g.drawLine(ix, 0, ix, this.getHeight());
                    g.setColor(Color.pink);
                    ix = (int)this.getXAxis().transform(CutoffSlicer.this.yValue);
                    g.drawLine(ix, 0, ix, this.getHeight());
                }
            };
            plot.getYAxis().setLabel("slope");
            this.slopeRenderer = new SymbolLineRenderer();
            this.contextSlopeRenderer = new SymbolLineRenderer();
            this.contextSlopeRenderer.setColor(Color.GRAY);
            plot.addRenderer(this.slopeRenderer);
            DataPointSelectorMouseModule slopeSlicer = new DataPointSelectorMouseModule(plot, this.levelRenderer, new HorizontalSliceSelectionRenderer(plot), "slope level");
            slopeSlicer.addDataPointSelectionListener(new DataPointSelectionListener(){

                public void dataPointSelected(DataPointSelectionEvent e) {
                    Datum y = e.getY();
                    CutoffMouseModule.this.setSlopeMin(y);
                }
            });
            slopeSlicer.setDragEvents(false);
            slopeSlicer.setKeyEvents(false);
            slopeSlicer.setReleaseEvents(true);
            plot.addMouseModule(slopeSlicer);
            canvas.add(plot, row2, col);
            plot = new DasPlot(xaxis.createAttachedAxis(), new DasAxis(new DatumRange(-0.3, 1.3, Units.dimensionless), 3));
            plot.getYAxis().setLabel("icof");
            this.icofRenderer = new SymbolLineRenderer();
            plot.addRenderer(this.icofRenderer);
            canvas.add(plot, row3, col);
        }

        private void recalculate() {
            this.dataPointSelected(this.lastSelectedPoint);
        }

        public void dataPointSelected(DataPointSelectionEvent event) {
            this.lastSelectedPoint = event;
            TableDataSet tds = (TableDataSet)CutoffMouseModule.this.dataSetConsumer.getConsumedDataSet();
            this.xValue = event.getX();
            this.yValue = event.getY();
            if (CutoffMouseModule.this.xrange == null) {
                return;
            }
            AverageTableRebinner rebinner = new AverageTableRebinner();
            DatumRange range = DataSetUtil.xRange(tds);
            RebinDescriptor ddx = CutoffMouseModule.this.getRebinDescriptor(range);
            try {
                tds = (TableDataSet)rebinner.rebin(tds, ddx, null);
            }
            catch (DasException e) {
                throw new RuntimeException(e);
            }
            int i = DataSetUtil.closestColumn(tds, event.getX());
            VectorDataSet contextDs = tds.getXSlice(i);
            this.contextLevelRenderer.setDataSet(DataSetUtil.log10(contextDs));
            tds = new ClippedTableDataSet(tds, DataSetUtil.xRange(tds), CutoffMouseModule.this.yrange);
            this.xValue = tds.getXTagDatum(i);
            this.topPlot.setTitle("" + this.xValue + " " + this.yValue);
            VectorDataSet spec = DataSetUtil.log10(tds.getXSlice(i));
            int icutoff = CutoffMouseModule.this.cutoff(spec, CutoffMouseModule.this.slopeMin, CutoffMouseModule.this.nave, CutoffMouseModule.this.isLowCutoff() ? 1 : -1, CutoffMouseModule.this.levelMin);
            this.cutoff = icutoff == -1 ? spec.getXUnits().getFillDatum() : spec.getXTagDatum(icutoff);
            this.showPopup();
        }

        private void showPopup() {
            if (!this.frame.isVisible()) {
                this.frame.setVisible(true);
            }
        }
    }
}

