/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.das2.event.BoxZoomMouseModule;
import org.jdesktop.layout.GroupLayout;

public class BoxZoomDialog
extends JPanel {
    BoxZoomMouseModule module;
    private JCheckBox autoCheckBox;
    private JCheckBox constrainProportionsCheckBox;
    private JCheckBox disablePopupCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField xRangeTextField;
    private JTextField yRangeTextField;
    private JButton zoomBoxButton;
    private JButton zoomXButton;
    private JButton zoomYButton;

    public BoxZoomDialog(BoxZoomMouseModule module) {
        this.initComponents();
        this.module = module;
        this.zoomYButton.setAction(module.getZoomYAction());
        this.zoomXButton.setAction(module.getZoomXAction());
        this.zoomBoxButton.setAction(module.getZoomBoxAction());
    }

    String getXRange() {
        return this.xRangeTextField.getText();
    }

    String getYRange() {
        return this.yRangeTextField.getText();
    }

    public boolean isAutoBoxZoom() {
        return this.autoCheckBox.isSelected();
    }

    public boolean isConstrainProportions() {
        return this.constrainProportionsCheckBox.isSelected();
    }

    public boolean isDisablePopup() {
        return this.disablePopupCheckBox.isSelected();
    }

    public void setDisablePopup(boolean v) {
        this.disablePopupCheckBox.setSelected(v);
    }

    public void setConstrainProportions(boolean v) {
        this.constrainProportionsCheckBox.setSelected(v);
    }

    public void setAutoBoxZoom(boolean v) {
        this.autoCheckBox.setSelected(v);
    }

    public void setXRange(String s) {
        this.xRangeTextField.setText(s);
    }

    public void setYRange(String s) {
        this.yRangeTextField.setText(s);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.xRangeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.yRangeTextField = new JTextField();
        this.zoomYButton = new JButton();
        this.zoomBoxButton = new JButton();
        this.zoomXButton = new JButton();
        this.autoCheckBox = new JCheckBox();
        this.disablePopupCheckBox = new JCheckBox();
        this.constrainProportionsCheckBox = new JCheckBox();
        this.jLabel1.setText("X:");
        this.jLabel2.setText("Y:");
        this.zoomYButton.setText("<html>z<br>o<br>o<br>m<br>Y</html>");
        this.zoomYButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoomBoxButton.setText("<html>Zoom<br>Box</html>");
        this.zoomXButton.setText("zoom X");
        this.autoCheckBox.setText("auto box zoom");
        this.autoCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.autoCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxZoomDialog.this.autoCheckBoxActionPerformed(evt);
            }
        });
        this.disablePopupCheckBox.setText("disable popup");
        this.disablePopupCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.disablePopupCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.disablePopupCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxZoomDialog.this.disablePopupCheckBoxActionPerformed(evt);
            }
        });
        this.constrainProportionsCheckBox.setText("constrain proportions");
        this.constrainProportionsCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.constrainProportionsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.constrainProportionsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BoxZoomDialog.this.constrainProportionsCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.xRangeTextField, -2, 155, -2)).add(layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.yRangeTextField, -2, -1, -2).add(layout.createSequentialGroup().add(10, 10, 10).add(this.zoomYButton, -2, 21, -2).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.zoomXButton).add(this.zoomBoxButton, -1, 109, Short.MAX_VALUE))).add(this.constrainProportionsCheckBox).add(this.autoCheckBox).add(layout.createSequentialGroup().add(17, 17, 17).add(this.disablePopupCheckBox))))).addContainerGap()));
        layout.linkSize(new Component[]{this.xRangeTextField, this.yRangeTextField}, 1);
        layout.linkSize(new Component[]{this.zoomBoxButton, this.zoomXButton}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel1).add(this.xRangeTextField, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel2).add(this.yRangeTextField, -2, -1, -2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.zoomBoxButton).addPreferredGap(0).add(this.zoomXButton, -2, 31, -2)).add(this.zoomYButton, -2, 80, -2)).addPreferredGap(0).add(this.constrainProportionsCheckBox).addPreferredGap(0).add(this.autoCheckBox).addPreferredGap(0).add(this.disablePopupCheckBox).addContainerGap()));
    }

    private void disablePopupCheckBoxActionPerformed(ActionEvent evt) {
        if (this.disablePopupCheckBox.isSelected()) {
            int result = JOptionPane.showConfirmDialog(this, "<html>Hitting OK will disable this popup and will perform the zoom.  Popup may be re-enabled via the plot's property editor.</html>", "hiding box zoom popup", 2);
            if (result == 0) {
                this.module.setAutoUpdate(true);
                this.module.zoomBox();
                this.module.dialog.setVisible(false);
            } else {
                this.disablePopupCheckBox.setSelected(false);
            }
        }
        this.module.guiChanged();
    }

    private void constrainProportionsCheckBoxActionPerformed(ActionEvent evt) {
        this.module.guiChanged();
    }

    private void autoCheckBoxActionPerformed(ActionEvent evt) {
        this.disablePopupCheckBox.setEnabled(this.autoCheckBox.isSelected());
        if (!this.autoCheckBox.isSelected()) {
            this.disablePopupCheckBox.setSelected(false);
        }
        this.module.guiChanged();
    }
}

