/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.swing;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;

public class SwingDatumFormatter
extends JFormattedTextField.AbstractFormatter {
    private Units units;
    private DatumFormatter formatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();

    public Object stringToValue(String text) throws ParseException {
        if (this.units == null) {
            this.units = Units.dimensionless;
        }
        return this.units.parse(text);
    }

    public String valueToString(Object value) throws ParseException {
        Datum d = (Datum)value;
        if (d == null) {
            return "";
        }
        this.units = d.getUnits();
        return this.formatter.format(d, this.units);
    }

    public Units getUnits() {
        return this.units;
    }

    public void setUnits(Units units) {
        this.units = units;
    }

    public static final JFormattedTextField.AbstractFormatterFactory newFactory() {
        return new DefaultFormatterFactory(new SwingDatumFormatter());
    }
}

