/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.util.DasMath;
import org.das2.util.NumberFormatUtil;

public class ExponentialDatumFormatter
extends DatumFormatter {
    private DecimalFormat format;
    int digits;
    int exponent;
    NumberFormat mantFormat;
    String mantFormatString;

    public ExponentialDatumFormatter(int digits, int exponent) {
        this.digits = digits;
        this.exponent = exponent;
        StringBuffer buff = new StringBuffer(digits + 2).append("0");
        if (digits > 1) {
            buff.append('.');
        }
        for (int i = 1; i < digits; ++i) {
            buff.append('0');
        }
        this.mantFormatString = buff.toString();
        this.mantFormat = NumberFormatUtil.getDecimalFormat(buff.toString());
    }

    public String format(Datum datum) {
        return this.format(datum, datum.getUnits()) + " " + datum.getUnits();
    }

    public String format(Datum datum, Units units) {
        double x = datum.doubleValue(datum.getUnits());
        if (x == 0.0) {
            return "0.";
        }
        double exp = DasMath.exp10(this.exponent);
        double mant = x / exp;
        double tenToN = DasMath.exp10(this.digits);
        mant = (double)Math.round(mant * tenToN) / tenToN;
        return this.mantFormat.format(mant) + "E" + this.exponent;
    }

    public String grannyFormat(Datum datum, Units units) {
        String format = this.format(datum, units);
        if (format.indexOf("E") != -1) {
            int iE = format.indexOf("E");
            StringBuffer granny = new StringBuffer(format.length() + 4);
            String mant = format.substring(0, iE);
            granny.append(mant).append("\u00d7");
            granny.append("10").append("!A").append(format.substring(iE + 1)).append("!N");
            format = granny.toString();
        }
        return format;
    }

    public String grannyFormat(Datum datum) {
        String format = this.format(datum, datum.getUnits());
        if (format.indexOf("E") != -1) {
            int iE = format.indexOf("E");
            StringBuffer granny = new StringBuffer(format.length() + 4);
            String mant = format.substring(0, iE);
            granny.append(mant).append("\u00d7");
            granny.append("10").append("!A").append(format.substring(iE + 1)).append("!N");
            format = granny.toString();
        }
        return format + " " + datum.getUnits();
    }

    public String toString() {
        return this.mantFormatString + "E" + this.exponent;
    }
}

