/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.ParseException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.TimeDatumFormatter;

public class DatumRangeUtilOld {
    private static Datum parseUnit(double value, String s) {
        if (s.equals("d")) {
            return Units.microseconds.createDatum(value * 86400.0 * 1000000.0);
        }
        if (s.equals("h")) {
            return Units.microseconds.createDatum(value * 3600.0 * 1000000.0);
        }
        if (s.equals("m")) {
            return Units.microseconds.createDatum(value * 60.0 * 1000000.0);
        }
        if (s.equals("s")) {
            return Units.microseconds.createDatum(value * 1000000.0);
        }
        if (s.equals("ms")) {
            return Units.nanoseconds.createDatum(value * 1000000.0);
        }
        if (s.equals("us")) {
            return Units.nanoseconds.createDatum(value * 1000.0);
        }
        if (s.equals("ns")) {
            return Units.nanoseconds.createDatum(value);
        }
        throw new IllegalArgumentException("Unit not recognized: " + s);
    }

    private static Datum parseTimeWidth(String ss) {
        long days = 0L;
        long seconds = 0L;
        long nanos = 0L;
        double rseconds = 0.0;
        double rnanos = 0.0;
        String[] s = ss.split(" ");
        Datum accum = Units.nanoseconds.createDatum(0.0);
        int i = 0;
        while (i < s.length) {
            while (s[i].equals("")) {
                ++i;
            }
            double value = Double.parseDouble(s[i++]);
            while (s[i].equals("")) {
                ++i;
            }
            String unit = s[i++];
            Datum datum = DatumRangeUtilOld.parseUnit(value, unit);
            accum = accum.add(datum);
        }
        return accum;
    }

    public static int getIncrement(Datum startDatum, String s1) throws ParseException {
        try {
            int i;
            if (s1.length() < 4) {
                s1 = "2000-" + s1;
                TimeUtil.TimeStruct ts = TimeUtil.parseTime(s1);
                return 3;
            }
            if (s1.length() < 5) {
                s1 = s1 + "-001";
                TimeUtil.TimeStruct ts = TimeUtil.parseTime(s1);
                return 1;
            }
            TimeUtil.TimeStruct ts = TimeUtil.parseTime(s1);
            if (ts.want[3]) {
                return 2;
            }
            for (i = 6; i > 0 && ts.want[i]; --i) {
            }
            return i;
        }
        catch (ParseException e) {
            int i;
            String s = TimeDatumFormatter.DAYS.format(startDatum) + " " + s1;
            TimeUtil.TimeStruct ts = TimeUtil.parseTime(s);
            if (ts.want[3]) {
                return 2;
            }
            for (i = 6; i > 0 && ts.want[i]; --i) {
            }
            return i;
        }
    }

    private static Datum getStartDatum(String s1) throws ParseException {
        if (s1.length() < 5) {
            s1 = s1 + "-001";
            TimeUtil.TimeStruct ts = TimeUtil.parseTime(s1);
            return TimeUtil.toDatum(ts);
        }
        TimeUtil.TimeStruct ts = TimeUtil.parseTime(s1);
        return TimeUtil.toDatum(ts);
    }

    private static Datum getEndDatum(Datum startDatum, String s1) throws ParseException {
        Datum endStart;
        try {
            TimeUtil.TimeStruct ts;
            if (s1.length() < 4) {
                TimeUtil.TimeStruct tsStart = TimeUtil.toTimeStruct(startDatum);
                ts = TimeUtil.parseTime("" + tsStart.year + "-" + s1);
            } else {
                ts = s1.length() < 5 ? TimeUtil.parseTime(s1 + "-001") : TimeUtil.parseTime(s1);
            }
            endStart = TimeUtil.toDatum(ts);
        }
        catch (ParseException e) {
            String s = TimeDatumFormatter.DAYS.format(startDatum) + " " + s1;
            TimeUtil.TimeStruct ts = TimeUtil.parseTime(s);
            endStart = TimeUtil.toDatum(ts);
        }
        int inc = DatumRangeUtilOld.getIncrement(startDatum, s1);
        if (inc <= 3) {
            return TimeUtil.next(inc, endStart);
        }
        return endStart;
    }

    public static DatumRange parseTimeRange(String s) throws ParseException {
        int i;
        String[] delims = new String[]{"[", "to", "through", "-"};
        for (i = 0; i < delims.length && s.indexOf(delims[i]) < 0; ++i) {
        }
        if (i == delims.length) {
            Datum start = DatumRangeUtilOld.getStartDatum(s);
            Datum end = DatumRangeUtilOld.getEndDatum(start, s);
            return new DatumRange(start, end);
        }
        if (delims[i].equals("-")) {
            String[] ss = s.split("-");
            if (ss.length % 2 != 0) {
                throw new IllegalArgumentException("times contain even number of -'s, giving up");
            }
            int n = ss.length;
            StringBuffer sb1 = new StringBuffer(ss[0]);
            int ii = 1;
            while (i < n / 2) {
                sb1.append("-").append(ss[ii]);
                ++ii;
            }
            StringBuffer sb2 = new StringBuffer(ss[n / 2]);
            int ii2 = n / 2 + 1;
            while (i < n) {
                sb2.append("-").append(ss[ii2]);
                ++ii2;
            }
            if (sb1.length() == 4 && sb2.length() == 3) {
                String yyyy_ddd = sb1.append("/").append(sb2).toString();
                Datum start = DatumRangeUtilOld.getStartDatum(yyyy_ddd);
                Datum end = DatumRangeUtilOld.getEndDatum(start, yyyy_ddd);
                return new DatumRange(start, end);
            }
            Datum start = DatumRangeUtilOld.getStartDatum(sb1.toString());
            Datum end = DatumRangeUtilOld.getEndDatum(start, sb2.toString());
            return new DatumRange(start, end);
        }
        if (delims[i].equals("[")) {
            String[] ss = s.split("\\[");
            Datum start = DatumRangeUtilOld.getStartDatum(ss[0]);
            String widthString = ss[1];
            if (widthString.indexOf(93) != -1) {
                widthString = widthString.substring(0, widthString.indexOf(93));
            }
            Datum width = DatumRangeUtilOld.parseTimeWidth(widthString);
            return new DatumRange(start, start.add(width));
        }
        String[] ss = s.split(delims[i]);
        Datum start = DatumRangeUtilOld.getStartDatum(ss[0]);
        return new DatumRange(start, DatumRangeUtilOld.getEndDatum(start, ss[1]));
    }

    public static DatumRange newDimensionless(double lower, double upper) {
        return new DatumRange(Datum.create(lower), Datum.create(upper));
    }
}

