/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.MonthDatumRange;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.system.DasLogger;
import org.das2.util.DasMath;

public class DatumRangeUtil {
    private static final int DATEFORMAT_USA = 1;
    private static final int DATEFORMAT_EUROPE = 0;
    private static final int DATEFORMAT_YYYY_DDD = 2;
    private static final boolean DEBUG = false;

    private static boolean isYear(String string) {
        return string.length() == 4 && Pattern.matches("\\d{4}", string);
    }

    private static boolean isDayOfYear(String string) {
        return string.length() == 3 && Pattern.matches("\\d{3}", string);
    }

    private static int monthNumber(String string) throws ParseException {
        if (Pattern.matches("\\d+", string)) {
            return DatumRangeUtil.parseInt(string);
        }
        int month = DatumRangeUtil.monthNameNumber(string);
        if (month == -1) {
            throw new ParseException("hoping for month at, got " + string, 0);
        }
        return month;
    }

    private static int monthNameNumber(String string) {
        if (string.length() < 3) {
            return -1;
        }
        String[] monthNames = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
        string = string.substring(0, 3).toLowerCase();
        int r = -1;
        for (int i = 0; i < monthNames.length; ++i) {
            if (!string.equals(monthNames[i])) continue;
            r = i;
        }
        if (r == -1) {
            return -1;
        }
        return r + 1;
    }

    private static int y2k(String syear) throws ParseException {
        int year = DatumRangeUtil.parseInt(syear);
        if (year > 100) {
            return year;
        }
        if (year < 70) {
            return 2000 + year;
        }
        return 1900 + year;
    }

    private int stregex(String string, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(string);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    private static void caldat(int julday, DateDescriptor dateDescriptor) {
        int jalpha = (int)(((double)(julday - 1867216) - 0.25) / 36524.25);
        int j1 = julday + 1 + jalpha - jalpha / 4;
        int j2 = j1 + 1524;
        int j3 = 6680 + (int)(((double)(j2 - 2439870) - 122.1) / 365.25);
        int j4 = 365 * j3 + j3 / 4;
        int j5 = (int)((double)(j2 - j4) / 30.6001);
        int day = j2 - j4 - (int)(30.6001 * (double)j5);
        int month = j5 - 1;
        month = (month - 1) % 12 + 1;
        int year = j3 - 4715;
        dateDescriptor.day = "" + day;
        dateDescriptor.month = "" + month;
        dateDescriptor.year = "" + (year -= (year -= month > 2 ? 1 : 0) <= 0 ? 1 : 0);
    }

    private static int julday(int month, int day, int year) {
        int jd = 367 * year - 7 * (year + (month + 9) / 12) / 4 - 3 * ((year + (month - 9) / 7) / 100 + 1) / 4 + 275 * month / 9 + day + 1721029;
        return jd;
    }

    private static void printGroups(Matcher matcher) {
        for (int i = 0; i <= matcher.groupCount(); ++i) {
            System.out.println(" " + i + ": " + matcher.group(i));
        }
        System.out.println(" ");
    }

    private static int parseInt(String s) throws ParseException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ParseException("failed attempt to parse int in " + s, 0);
        }
    }

    public static DatumRange parseTimeRange(String string) throws ParseException {
        return new TimeRangeParser().parse(string);
    }

    public static DatumRange parseTimeRangeValid(String s) {
        try {
            return DatumRangeUtil.parseTimeRange(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static String efficientTime(Datum time, Datum time2, DatumRange context) {
        TimeUtil.TimeStruct ts = TimeUtil.toTimeStruct(time);
        int stopRes = 4;
        if (TimeUtil.getSecondsSinceMidnight(time) == 0.0 && time.equals(context.max())) {
            ts.hour = 24;
            --ts.day;
        }
        String timeString = "" + ts.hour + ":";
        Datum[] times = new Datum[]{time, time2};
        for (int i = 0; i < times.length; ++i) {
            int idigit;
            int[] arr = TimeUtil.toTimeArray(times[i]);
            for (idigit = 7; idigit > 3 && arr[idigit] <= 0; --idigit) {
            }
            stopRes = Math.max(stopRes, idigit);
        }
        int[] arr = TimeUtil.toTimeArray(time);
        if (stopRes > 3) {
            timeString = timeString + (arr[4] < 10 ? "0" : "") + arr[4];
            if (stopRes > 4) {
                int second = arr[5];
                timeString = timeString + ":" + (second < 10 ? "0" : "") + second;
                if (stopRes > 5) {
                    int millis = arr[6];
                    DecimalFormat nf = new DecimalFormat("000");
                    timeString = timeString + "." + nf.format(millis);
                    if (stopRes > 6) {
                        int micros = arr[7];
                        timeString = timeString + nf.format(micros);
                    }
                }
            }
        }
        return timeString;
    }

    public static String formatTimeRange(DatumRange self) {
        String[] monthStr = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "June", "July", "Aug", "Sep", "Oct", "Nov", "Dec"};
        double seconds = self.width().doubleValue(Units.seconds);
        TimeUtil.TimeStruct ts1 = TimeUtil.toTimeStruct(self.min());
        TimeUtil.TimeStruct ts2 = TimeUtil.toTimeStruct(self.max());
        boolean isMidnight1 = TimeUtil.getSecondsSinceMidnight(self.min()) == 0.0;
        boolean isMidnight2 = TimeUtil.getSecondsSinceMidnight(self.max()) == 0.0;
        boolean isMonthBoundry1 = isMidnight1 && ts1.day == 1;
        boolean isMonthBoundry2 = isMidnight2 && ts2.day == 1;
        boolean isYearBoundry1 = isMonthBoundry1 && ts1.month == 1;
        boolean isYearBoundry2 = isMonthBoundry2 && ts2.month == 1;
        String toDelim = " through ";
        if (isYearBoundry1 && isYearBoundry2) {
            if (ts2.year - ts1.year == 1) {
                return "" + ts1.year;
            }
            return "" + ts1.year + toDelim + (ts2.year - 1);
        }
        if (isMonthBoundry1 && isMonthBoundry2) {
            if (ts2.month == 1) {
                ts2.month = 13;
                --ts2.year;
            }
            if (ts2.year == ts1.year) {
                if (ts2.month - ts1.month == 1) {
                    return monthStr[ts1.month - 1] + " " + ts1.year;
                }
                return monthStr[ts1.month - 1] + toDelim + monthStr[ts2.month - 1 - 1] + " " + ts1.year;
            }
            return monthStr[ts1.month - 1] + " " + ts1.year + toDelim + monthStr[ts2.month - 1 - 1] + " " + ts2.year;
        }
        if (isMidnight1 && isMidnight2) {
            if (TimeUtil.getJulianDay(self.max()) - TimeUtil.getJulianDay(self.min()) == 1) {
                return TimeDatumFormatter.DAYS.format(self.min());
            }
            Datum endtime = self.max().subtract(Datum.create(1, Units.days));
            return TimeDatumFormatter.DAYS.format(self.min()) + toDelim + TimeDatumFormatter.DAYS.format(endtime);
        }
        if (seconds < 1.0) {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.MILLISECONDS;
        } else if (seconds < 60.0) {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.MILLISECONDS;
        } else if (seconds < 3600.0) {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.SECONDS;
        } else {
            TimeDatumFormatter timeOfDayFormatter = TimeDatumFormatter.MINUTES;
        }
        int maxDay = TimeUtil.getJulianDay(self.max());
        if (TimeUtil.getSecondsSinceMidnight(self.max()) == 0.0) {
            --maxDay;
        }
        if (maxDay == TimeUtil.getJulianDay(self.min())) {
            return TimeDatumFormatter.DAYS.format(self.min()) + " " + DatumRangeUtil.efficientTime(self.min(), self.max(), self) + " to " + DatumRangeUtil.efficientTime(self.max(), self.min(), self);
        }
        String t1str = DatumRangeUtil.efficientTime(self.min(), self.max(), self);
        String t2str = DatumRangeUtil.efficientTime(self.max(), self.min(), self);
        return TimeDatumFormatter.DAYS.format(self.min()) + " " + t1str + " to " + TimeDatumFormatter.DAYS.format(self.max()) + " " + t2str;
    }

    public static List generateList(DatumRange bounds, DatumRange element) {
        ArrayList<DatumRange> result = new ArrayList<DatumRange>();
        DatumRange dr = element;
        while (dr.max().gt(bounds.min())) {
            result.add(0, dr);
            dr = dr.previous();
        }
        dr = element.next();
        while (dr.min().lt(bounds.max())) {
            result.add(dr);
            dr = dr.next();
        }
        return result;
    }

    public static DatumRange newDimensionless(double lower, double upper) {
        return new DatumRange(Datum.create(lower), Datum.create(upper));
    }

    public static DatumRange parseDatumRange(String str, Units units) throws ParseException {
        Datum d2;
        if (units instanceof TimeLocationUnits) {
            return DatumRangeUtil.parseTimeRange(str);
        }
        String[] ss = str.split("to");
        if (ss.length == 1) {
            ss = str.split("\u2013");
        }
        if (ss.length != 2) {
            if (ss.length == 3) {
                ss[0] = "-" + ss[1];
                ss[1] = ss[2];
            } else {
                throw new IllegalArgumentException("failed to parse: " + str);
            }
        }
        try {
            d2 = DatumUtil.parse(ss[1]);
            if (d2.getUnits() == Units.dimensionless) {
                d2 = units.parse(ss[1]);
            }
        }
        catch (ParseException e) {
            d2 = units.parse(ss[1]);
        }
        Datum d1 = d2.getUnits().parse(ss[0]);
        if (d1.getUnits().isConvertableTo(units)) {
            return new DatumRange(d1.convertTo(units), d2.convertTo(units));
        }
        throw new ParseException("Can't convert parsed unit (" + d1.getUnits() + ") to " + units, 0);
    }

    public static DatumRange parseDatumRange(String str, DatumRange orig) throws ParseException {
        return DatumRangeUtil.parseDatumRange(str, orig.getUnits());
    }

    public static DatumRange rescale(DatumRange dr, double min, double max) {
        Datum w = dr.width();
        if (!w.isFinite()) {
            throw new RuntimeException("width is not finite");
        }
        if (w.doubleValue(w.getUnits()) == 0.0) {
            throw new RuntimeException("width is zero!");
        }
        return new DatumRange(dr.min().add(w.multiply(min)), dr.min().add(w.multiply(max)));
    }

    public static DatumRange rescaleLog(DatumRange dr, double min, double max) {
        Units u = dr.getUnits();
        double s1 = DasMath.log10(dr.min().doubleValue(u));
        double s2 = DasMath.log10(dr.max().doubleValue(u));
        double w = s2 - s1;
        if (w == 0.0) {
            throw new RuntimeException("width is zero!");
        }
        s2 = DasMath.exp10(s1 + max * w);
        s1 = DasMath.exp10(s1 + min * w);
        return new DatumRange(s1, s2, u);
    }

    public static double normalize(DatumRange dr, Datum d) {
        return d.subtract(dr.min()).divide(dr.width()).doubleValue(Units.dimensionless);
    }

    public static double normalizeLog(DatumRange dr, Datum d) {
        Units u = dr.getUnits();
        double d0 = Math.log(dr.min().doubleValue(u));
        double d1 = Math.log(dr.max().doubleValue(u));
        double dd = Math.log(d.doubleValue(u));
        return (dd - d0) / (d1 - d0);
    }

    public static DatumRange sloppyIntersection(DatumRange range, DatumRange include) {
        Units units = range.getUnits();
        double s11 = range.min().doubleValue(units);
        double s12 = include.min().doubleValue(units);
        double s21 = range.max().doubleValue(units);
        if (range.intersects(include)) {
            double s1 = Math.max(s11, s12);
            double s22 = include.max().doubleValue(units);
            double s2 = Math.min(s21, s22);
            return new DatumRange(s1, s2, units);
        }
        if (s11 < s12) {
            return new DatumRange(s21, s21, units);
        }
        return new DatumRange(s11, s11, units);
    }

    public static boolean sloppyContains(DatumRange context, Datum datum) {
        return context.contains(datum) || context.max().equals(datum);
    }

    public static DatumRange union(DatumRange range, DatumRange include) {
        Units units = range.getUnits();
        double s11 = range.min().doubleValue(units);
        double s12 = include.min().doubleValue(units);
        double s21 = range.max().doubleValue(units);
        double s22 = include.max().doubleValue(units);
        return new DatumRange(Math.min(s11, s12), Math.max(s21, s22), units);
    }

    static class TimeRangeParser {
        String token;
        String delim = "";
        String string;
        int ipos;
        final int YEAR = 0;
        final int MONTH = 1;
        final int DAY = 2;
        final int HOUR = 3;
        final int MINUTE = 4;
        final int SECOND = 5;
        final int NANO = 6;
        final int STATE_OPEN = 89;
        final int STATE_TS1TIME = 90;
        final int STATE_TS2TIME = 91;
        int state = 89;
        String delimRegEx = "\\s|-|/|\\.|:|to|through|span|T|Z|\u2013|,";
        Pattern delimPattern = Pattern.compile(this.delimRegEx);
        int[] ts1 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts2 = new int[]{-1, -1, -1, -1, -1, -1, -1};
        int[] ts = null;
        boolean beforeTo;
        private Pattern yyyymmddPattern = Pattern.compile("((\\d{4})(\\d{2})(\\d{2}))( |to|t|-|$)");

        TimeRangeParser() {
        }

        private boolean tryPattern(Pattern regex, String string, int[] groups, DateDescriptor dateDescriptor) throws ParseException {
            Matcher matcher = regex.matcher(string.toLowerCase());
            if (matcher.find() && matcher.start() == 0) {
                int posDate = matcher.start();
                int length = matcher.end() - matcher.start();
                dateDescriptor.delim = matcher.group(groups[3]);
                dateDescriptor.date = string.substring(matcher.start(), matcher.end() - dateDescriptor.delim.length());
                dateDescriptor.day = matcher.group(groups[2]);
                dateDescriptor.month = matcher.group(groups[1]);
                dateDescriptor.year = matcher.group(groups[0]);
                return true;
            }
            return false;
        }

        public boolean isTime(String string, int[] timearr) throws ParseException {
            Pattern hhmmssmmPattern = Pattern.compile("(\\d+):(\\d\\d+):(\\d\\d+).(\\d+) )");
            Pattern hhmmssPattern = Pattern.compile("(\\d+):(\\d\\d+):(\\d\\d+)");
            Pattern hhmmPattern = Pattern.compile("(\\d+):(\\d\\d+)");
            Pattern hhPattern = Pattern.compile("(\\d+):");
            Matcher m = hhmmssmmPattern.matcher(string);
            if (m.matches()) {
                timearr[3] = Integer.parseInt(m.group(1));
                timearr[4] = Integer.parseInt(m.group(2));
                timearr[5] = Integer.parseInt(m.group(3));
                timearr[6] = (int)((double)Integer.parseInt(m.group(4)) * (100000.0 / DasMath.exp10(m.group(4).length())));
                throw new RuntimeException("working on this");
            }
            m = hhmmssPattern.matcher(string);
            if (m.matches() || (m = hhmmPattern.matcher(string)).matches() || (m = hhPattern.matcher(string)).matches()) {
                // empty if block
            }
            return false;
        }

        public boolean isDate(String string, DateDescriptor dateDescriptor) throws ParseException {
            int[] groups;
            String euroDateRegex;
            if (string.length() < 6) {
                return false;
            }
            String dateDelimRegex = "( |to|t|-)";
            String yearRegex = "(\\d{2}(\\d{2})?)";
            if (this.tryPattern(this.yyyymmddPattern, string, new int[]{2, 3, 4, 5}, dateDescriptor)) {
                dateDescriptor.dateformat = 1;
                return true;
            }
            String delims = "(/|\\.|-| )";
            Matcher matcher = Pattern.compile(delims).matcher(string);
            if (!matcher.find()) {
                return false;
            }
            int posDelim = matcher.start();
            String delim = string.substring(matcher.start(), matcher.end());
            if (delim.equals(".")) {
                delim = "\\.";
            }
            String monthNameRegex = "(jan[a-z]*|feb[a-z]*|mar[a-z]*|apr[a-z]*|may|june?|july?|aug[a-z]*|sep[a-z]*|oct[a-z]*|nov[a-z]*|dec[a-z]*)";
            String monthRegex = "((\\d?\\d)|" + monthNameRegex + ")";
            String dayRegex = "(\\d?\\d)";
            if (delim.equals("\\.")) {
                euroDateRegex = "(" + dayRegex + delim + monthRegex + delim + yearRegex + dateDelimRegex + ")";
                groups = new int[]{6, 3, 2, 8};
            } else {
                euroDateRegex = "(" + dayRegex + delim + monthNameRegex + delim + yearRegex + dateDelimRegex + ")";
                groups = new int[]{4, 3, 2, 6};
            }
            if (this.tryPattern(Pattern.compile(euroDateRegex), string, groups, dateDescriptor)) {
                dateDescriptor.dateformat = 0;
                return true;
            }
            String usaDateRegex = monthRegex + delim + dayRegex + delim + yearRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(usaDateRegex), string, new int[]{5, 1, 4, 7}, dateDescriptor)) {
                dateDescriptor.dateformat = 1;
                return true;
            }
            String lastDateRegex = "(\\d{4})" + delim + monthRegex + delim + dayRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(lastDateRegex), string, new int[]{1, 2, 5, 6}, dateDescriptor)) {
                dateDescriptor.dateformat = 1;
                return true;
            }
            String doyRegex = "(\\d{3})";
            String dateRegex = doyRegex + "(-|/)" + yearRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(dateRegex), string, new int[]{3, 1, 1, 5}, dateDescriptor)) {
                int doy = DatumRangeUtil.parseInt(dateDescriptor.day);
                if (doy > 366) {
                    return false;
                }
                int year = DatumRangeUtil.parseInt(dateDescriptor.year);
                DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, year - 1) + doy, dateDescriptor);
                dateDescriptor.dateformat = 2;
                return true;
            }
            dateRegex = yearRegex + "(-|/)" + doyRegex + dateDelimRegex;
            if (this.tryPattern(Pattern.compile(dateRegex), string, new int[]{1, 4, 4, 5}, dateDescriptor)) {
                int doy = DatumRangeUtil.parseInt(dateDescriptor.day);
                if (doy > 366) {
                    return false;
                }
                int year = DatumRangeUtil.parseInt(dateDescriptor.year);
                DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, year - 1) + doy, dateDescriptor);
                dateDescriptor.dateformat = 2;
                return true;
            }
            return false;
        }

        private void nextToken() {
            Matcher matcher = this.delimPattern.matcher(this.string.substring(this.ipos));
            if (matcher.find()) {
                int r = matcher.start();
                int length = matcher.end() - matcher.start();
                this.token = this.string.substring(this.ipos, this.ipos + r);
                this.delim = this.string.substring(this.ipos + r, this.ipos + r + length);
                this.ipos = this.ipos + r + length;
            } else {
                this.token = this.string.substring(this.ipos);
                this.delim = "";
                this.ipos = this.string.length();
            }
        }

        private void setBeforeTo(boolean v) {
            this.beforeTo = v;
            this.ts = this.beforeTo ? this.ts1 : this.ts2;
        }

        public String normalizeTo(String s) throws ParseException {
            int minusCount = 0;
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) != '-') continue;
                ++minusCount;
            }
            if (minusCount == 0) {
                return s;
            }
            DateDescriptor dateDescriptor = new DateDescriptor();
            this.ipos = 0;
            StringBuffer newString = new StringBuffer();
            while (this.ipos < s.length()) {
                if (this.isDate(s.substring(this.ipos), dateDescriptor)) {
                    this.ipos = this.ipos + dateDescriptor.date.length() + dateDescriptor.delim.length();
                    this.token = dateDescriptor.date;
                    this.delim = dateDescriptor.delim;
                } else {
                    this.nextToken();
                }
                newString.append(this.token);
                if (this.delim.equals("-")) {
                    newString.append("to");
                    continue;
                }
                newString.append(this.delim);
            }
            String result = newString.toString();
            String[] ss = result.split("to");
            if (ss.length > 2) {
                result = ss[0];
                for (int i = 1; i < ss.length; ++i) {
                    result = result + "-" + ss[i];
                }
            } else if (ss.length == 2) {
                String s0 = ss[0].trim();
                String s1 = ss[1].trim();
                if (!DatumRangeUtil.isYear(s0) || !DatumRangeUtil.isYear(s1)) {
                    result = s0 + " " + s1;
                }
            }
            return result;
        }

        public DatumRange parse(String stringIn) throws ParseException {
            int i;
            int i2;
            int i3;
            String newString;
            Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
            this.string = stringIn + " ";
            this.ipos = 0;
            ArrayList<String> beforeToUnresolved = new ArrayList<String>();
            ArrayList<String> afterToUnresolved = new ArrayList<String>();
            String[] formatCodes = new String[]{"%y", "%m", "%d", "%H", "%M", "%S", ""};
            formatCodes[6] = "%N";
            String[] digitIdentifiers = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "NANO"};
            boolean isThroughNotTo = false;
            boolean YEAR = false;
            boolean MONTH = true;
            int DAY = 2;
            int HOUR = 3;
            int MINUTE = 4;
            int SECOND = 5;
            int NANO = 6;
            int STATE_OPEN = 89;
            int STATE_TS1TIME = 90;
            int STATE_TS2TIME = 91;
            int state = 89;
            String format = "";
            this.setBeforeTo(true);
            DateDescriptor dateDescriptor = new DateDescriptor();
            int dateFormat = 1;
            this.string = newString = this.normalizeTo(this.string);
            this.ipos = 0;
            while (this.ipos < this.string.length()) {
                boolean isWithinTime;
                String lastdelim = this.delim;
                format = format + lastdelim;
                if (lastdelim.equals("to")) {
                    this.setBeforeTo(false);
                }
                if (lastdelim.equals("through")) {
                    this.setBeforeTo(false);
                    isThroughNotTo = true;
                }
                if (lastdelim.equals("\u2013")) {
                    this.setBeforeTo(false);
                }
                if (lastdelim.equals("span")) {
                    this.setBeforeTo(false);
                    Datum start = TimeUtil.toDatum(this.ts1);
                    Datum width = DatumUtil.parse(newString.substring(this.ipos));
                    Datum stop = start.add(width);
                    TimeUtil.TimeStruct tt = TimeUtil.toTimeStruct(stop);
                    this.ts2[2] = tt.day;
                    this.ts2[1] = tt.month;
                    this.ts2[0] = tt.year;
                    this.ts2[3] = tt.hour;
                    this.ts2[4] = tt.minute;
                    this.ts2[5] = (int)tt.seconds;
                    this.ts2[6] = (int)((tt.seconds - (double)this.ts2[5]) * 1.0E9);
                    this.ipos = newString.length();
                }
                if (this.isDate(this.string.substring(this.ipos), dateDescriptor)) {
                    int day;
                    format = format + "%x";
                    if (this.ts1[2] != -1 || this.ts1[1] != -1 || this.ts1[0] != -1) {
                        this.setBeforeTo(false);
                    }
                    int month = DatumRangeUtil.monthNumber(dateDescriptor.month);
                    int year = DatumRangeUtil.y2k(dateDescriptor.year);
                    this.ts[2] = day = DatumRangeUtil.parseInt(dateDescriptor.day);
                    this.ts[1] = month;
                    this.ts[0] = year;
                    this.delim = dateDescriptor.delim;
                    this.ipos = this.ipos + dateDescriptor.date.length() + dateDescriptor.delim.length();
                    continue;
                }
                this.nextToken();
                if (this.token.equals("")) continue;
                if (DatumRangeUtil.isYear(this.token)) {
                    format = format + "%Y";
                    if (this.ts1[0] == -1 && this.beforeTo) {
                        this.ts1[0] = DatumRangeUtil.parseInt(this.token);
                        this.ts2[0] = this.ts1[0];
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[0] = DatumRangeUtil.parseInt(this.token);
                    if (this.ts1[0] != -1) continue;
                    this.ts1[0] = this.ts2[0];
                    continue;
                }
                if (DatumRangeUtil.isDayOfYear(this.token)) {
                    dateFormat = 2;
                    format = format + "%j";
                    if (this.ts1[0] == -1) {
                        throw new ParseException("day of year before year: " + stringIn + " (" + format + ")", this.ipos);
                    }
                    int doy = DatumRangeUtil.parseInt(this.token);
                    DatumRangeUtil.caldat(DatumRangeUtil.julday(12, 31, this.ts1[0] - 1) + doy, dateDescriptor);
                    dateFormat = 2;
                    int day = DatumRangeUtil.parseInt(dateDescriptor.day);
                    int month = DatumRangeUtil.parseInt(dateDescriptor.month);
                    if (this.ts1[2] == -1 && this.beforeTo) {
                        this.ts1[2] = day;
                        this.ts1[1] = month;
                        this.ts2[2] = day;
                        this.ts2[1] = month;
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[2] = day;
                    this.ts2[1] = month;
                    if (this.ts1[2] != -1) continue;
                    this.ts1[2] = day;
                    this.ts1[1] = month;
                    continue;
                }
                if (DatumRangeUtil.monthNameNumber(this.token) != -1) {
                    format = format + "%b";
                    int month = DatumRangeUtil.monthNameNumber(this.token);
                    if (this.ts1[1] == -1) {
                        this.ts1[1] = month;
                        this.ts2[1] = month;
                        continue;
                    }
                    this.setBeforeTo(false);
                    this.ts2[1] = month;
                    if (this.ts1[1] != -1) continue;
                    this.ts1[1] = month;
                    continue;
                }
                boolean bl = isWithinTime = this.delim.equals(":") || lastdelim.equals(":");
                if (isWithinTime) {
                    if (this.delim.equals(":") && !lastdelim.equals(":") && state == 89) {
                        format = format + "%H";
                        if (this.beforeTo && this.ts1[3] == -1) {
                            state = 90;
                        } else {
                            this.setBeforeTo(false);
                            state = 91;
                        }
                        this.ts[3] = DatumRangeUtil.parseInt(this.token);
                    } else {
                        int i4;
                        for (i4 = 3; i4 <= 6 && this.ts[i4] != -1; ++i4) {
                        }
                        if (i4 == 5 && this.delim.equals(".")) {
                            this.ts[i4] = DatumRangeUtil.parseInt(this.token);
                            format = format + formatCodes[i4];
                            this.nextToken();
                            i4 = 6;
                        }
                        if (i4 == 6) {
                            int tokenDigits = this.token.length();
                            this.ts[i4] = DatumRangeUtil.parseInt(this.token) * (int)Math.pow(10.0, 9 - tokenDigits);
                            switch (tokenDigits) {
                                case 3: {
                                    format = format + "%_ms";
                                    break;
                                }
                                case 6: {
                                    format = format + "%_us";
                                    break;
                                }
                                default: {
                                    format = format + "%N";
                                    break;
                                }
                            }
                        } else {
                            this.ts[i4] = DatumRangeUtil.parseInt(this.token);
                            format = format + formatCodes[i4];
                        }
                    }
                    if (this.delim.equals(":") || this.delim.equals(".")) continue;
                    state = 89;
                    continue;
                }
                if (this.beforeTo) {
                    beforeToUnresolved.add(this.token);
                    format = format + "UNRSV1" + beforeToUnresolved.size();
                    continue;
                }
                afterToUnresolved.add(this.token);
                format = format + "UNRSV2" + afterToUnresolved.size();
            }
            format = format + " ";
            StringBuffer stringBuffer = new StringBuffer("ts1: ");
            for (i3 = 0; i3 < 7; ++i3) {
                stringBuffer.append("" + this.ts1[i3] + " ");
            }
            logger.fine(stringBuffer.toString());
            stringBuffer = new StringBuffer("ts2: ");
            for (i3 = 0; i3 < 7; ++i3) {
                stringBuffer.append("" + this.ts2[i3] + " ");
            }
            logger.fine(stringBuffer.toString());
            logger.fine(format);
            if (this.beforeTo) {
                int idx = 0;
                for (i3 = 0; i3 < beforeToUnresolved.size(); ++i3) {
                    while (this.ts1[idx] != -1) {
                        ++idx;
                    }
                    this.ts1[idx] = DatumRangeUtil.parseInt((String)beforeToUnresolved.get(i3));
                    String[] s = format.split("UNRSV1" + (i3 + 1));
                    format = s[0] + formatCodes[idx] + s[1];
                }
                beforeToUnresolved.removeAll(beforeToUnresolved);
            }
            if (beforeToUnresolved.size() + afterToUnresolved.size() > 0) {
                String formatUn;
                ArrayList<String> unload;
                String[] s;
                int idx;
                if (beforeToUnresolved.size() < afterToUnresolved.size()) {
                    if (beforeToUnresolved.size() > 0) {
                        for (int i5 = 0; i5 < afterToUnresolved.size(); ++i5) {
                            while (idx < 7 && this.ts2[idx] != -1) {
                                ++idx;
                            }
                            if (idx == 7) {
                                throw new ParseException("can't resolve token in \"" + stringIn + "\": " + afterToUnresolved.get(i5) + " (" + format + ")", 0);
                            }
                            this.ts2[idx] = DatumRangeUtil.parseInt((String)afterToUnresolved.get(i5));
                            s = format.split("UNRSV2" + (i5 + 1));
                            format = s[0] + formatCodes[idx] + s[1];
                        }
                        unload = beforeToUnresolved;
                        formatUn = "UNRSV1";
                        this.ts = this.ts1;
                    } else {
                        for (idx = 0; idx < 7 && this.ts1[idx] != -1; ++idx) {
                        }
                        --idx;
                        unload = afterToUnresolved;
                        formatUn = "UNRSV2";
                        this.ts = this.ts2;
                    }
                } else if (afterToUnresolved.size() > 0) {
                    for (int i6 = 0; i6 < beforeToUnresolved.size(); ++i6) {
                        while (idx < 7 && this.ts1[idx] != -1) {
                            ++idx;
                        }
                        if (idx == 7) {
                            throw new ParseException("can't resolve token in \"" + stringIn + "\": " + beforeToUnresolved.get(i6) + " (" + format + ")", 0);
                        }
                        this.ts1[idx] = DatumRangeUtil.parseInt((String)beforeToUnresolved.get(i6));
                        s = format.split("UNRSV1" + (i6 + 1));
                        format = s[0] + formatCodes[idx] + s[1];
                    }
                    unload = afterToUnresolved;
                    formatUn = "UNRSV2";
                    this.ts = this.ts2;
                } else {
                    while (idx < 7 && this.ts2[idx] != -1) {
                        ++idx;
                    }
                    --idx;
                    unload = beforeToUnresolved;
                    formatUn = "UNRSV1";
                    this.ts = this.ts1;
                }
                int lsd = idx;
                for (int i7 = unload.size() - 1; i7 >= 0; --i7) {
                    while (this.ts[lsd] != -1 && lsd > 0) {
                        --lsd;
                    }
                    if (this.ts[lsd] != -1) {
                        throw new ParseException("can't resolve these tokens in \"" + stringIn + "\": " + unload + " (" + format + ")", 0);
                    }
                    this.ts[lsd] = DatumRangeUtil.parseInt((String)unload.get(i7));
                    String[] s2 = format.split(formatUn + (i7 + 1));
                    format = s2[0] + formatCodes[lsd] + s2[1];
                }
            }
            stringBuffer = new StringBuffer("ts1: ");
            for (i2 = 0; i2 < 7; ++i2) {
                stringBuffer.append("" + this.ts1[i2] + " ");
            }
            logger.fine(stringBuffer.toString());
            stringBuffer = new StringBuffer("ts2: ");
            for (i2 = 0; i2 < 7; ++i2) {
                stringBuffer.append("" + this.ts2[i2] + " ");
            }
            logger.fine(stringBuffer.toString());
            logger.fine(format);
            for (i = 0; i <= 2; ++i) {
                if (this.ts2[i] == -1 && this.ts1[i] != -1) {
                    this.ts2[i] = this.ts1[i];
                }
                if (this.ts1[i] != -1 || this.ts2[i] == -1) continue;
                this.ts1[i] = this.ts2[i];
            }
            int[] implicit_timearr = new int[]{-1, 1, 1, 0, 0, 0, 0};
            int ts1lsd = -1;
            int ts2lsd = -1;
            for (i = 6; i >= 0; --i) {
                if (this.ts2[i] != -1 && ts2lsd == -1) {
                    ts2lsd = i;
                }
                if (ts2lsd == -1) {
                    this.ts2[i] = implicit_timearr[i];
                }
                if (this.ts2[i] == -1 && ts2lsd != -1) {
                    throw new ParseException("not specified in stop time: " + digitIdentifiers[i] + " in " + stringIn + " (" + format + ")", this.ipos);
                }
                if (this.ts1[i] != -1 && ts1lsd == -1) {
                    ts1lsd = i;
                }
                if (ts1lsd == -1) {
                    this.ts1[i] = implicit_timearr[i];
                }
                if (this.ts1[i] != -1 || ts1lsd == -1) continue;
                throw new ParseException("not specified in start time:" + digitIdentifiers[i] + " in " + stringIn + " (" + format + ")", this.ipos);
            }
            if (ts1lsd != ts2lsd && (ts1lsd < 3 || ts2lsd < 3)) {
                throw new ParseException("resolution mismatch: " + digitIdentifiers[ts1lsd] + " specified for start, but " + digitIdentifiers[ts2lsd] + " specified for end, must be same" + " in \"" + stringIn + "\"" + " (" + format + ")", this.ipos);
            }
            if (this.beforeTo) {
                isThroughNotTo = true;
            }
            if (isThroughNotTo) {
                int n = ts2lsd;
                this.ts2[n] = this.ts2[n] + 1;
            }
            if (this.ts1[0] < 1900) {
                this.ts1[0] = DatumRangeUtil.y2k("" + this.ts1[0]);
            }
            if (this.ts2[0] < 1900) {
                this.ts2[0] = DatumRangeUtil.y2k("" + this.ts2[0]);
            }
            if (ts1lsd < 2) {
                try {
                    return new MonthDatumRange(this.ts1, this.ts2);
                }
                catch (IllegalArgumentException e) {
                    ParseException eNew = new ParseException("fails to parse due to MonthDatumRange: " + stringIn + " (" + format + ")", 0);
                    eNew.initCause(e);
                    throw eNew;
                }
            }
            Datum time1 = TimeUtil.createTimeDatum(this.ts1[0], this.ts1[1], this.ts1[2], this.ts1[3], this.ts1[4], this.ts1[5], this.ts1[6]);
            Datum time2 = TimeUtil.createTimeDatum(this.ts2[0], this.ts2[1], this.ts2[2], this.ts2[3], this.ts2[4], this.ts2[5], this.ts2[6]);
            return new DatumRange(time1, time2);
        }
    }

    public static class DateDescriptor {
        String date;
        String year;
        String month;
        String day;
        String delim;
        int dateformat;
    }
}

