/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.format.DatumFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Datum
implements Comparable<Datum> {
    private Units units;
    private Number value;
    private double resolution;
    private DatumFormatter formatter;

    private Datum(Number value, Units units, double resolution) {
        this(value, units, units.getDatumFormatterFactory().defaultFormatter(), resolution);
    }

    private Datum(Number value, Units units, DatumFormatter formatter, double resolution) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.value = value;
        this.units = units;
        this.resolution = resolution;
        this.formatter = formatter;
    }

    protected double doubleValue() {
        return this.getValue().doubleValue();
    }

    public double doubleValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).doubleValue();
        }
        return this.getValue().doubleValue();
    }

    public double getResolution(Units units) {
        Units offsetUnits = this.getUnits().getOffsetUnits();
        if (units != offsetUnits) {
            return offsetUnits.getConverter(units).convert(this.resolution);
        }
        return this.resolution;
    }

    protected int intValue() {
        return this.getValue().intValue();
    }

    public int intValue(Units units) {
        if (units != this.getUnits()) {
            return this.getUnits().getConverter(units).convert(this.getValue()).intValue();
        }
        return this.getValue().intValue();
    }

    public Units getUnits() {
        return this.units;
    }

    protected Number getValue() {
        return this.value;
    }

    public boolean isFill() {
        return this.getUnits().isFill(this.getValue());
    }

    public Datum add(Datum datum) {
        Datum result = this.add(datum.getValue(), datum.getUnits());
        result.resolution = Math.sqrt(datum.resolution * datum.resolution + this.resolution * this.resolution);
        return result;
    }

    public Datum add(Number value, Units units) {
        return this.getUnits().add(this.getValue(), value, units);
    }

    public Datum add(double d, Units units) {
        return this.add(new java.lang.Double(d), units);
    }

    public Datum subtract(Datum datum) {
        Datum result = this.subtract(datum.getValue(), datum.getUnits());
        result.resolution = Math.sqrt(datum.resolution * datum.resolution + this.resolution * this.resolution);
        return result;
    }

    public Datum subtract(Number a, Units units) {
        Datum result = this.getUnits().subtract(this.getValue(), a, units);
        return result;
    }

    public Datum subtract(double d, Units units) {
        return this.subtract(new java.lang.Double(d), units);
    }

    private static double relativeErrorMult(double x, double dx, double y, double dy) {
        return Math.sqrt(dx / x * dx / x + dy / y * dy / y);
    }

    public Datum divide(Datum a) {
        Datum result = this.divide(a.getValue(), a.getUnits());
        result.resolution = Math.abs(result.doubleValue()) * Datum.relativeErrorMult(this.doubleValue(), this.resolution, a.doubleValue(), a.resolution);
        return result;
    }

    public Datum divide(Number a, Units units) {
        return this.getUnits().divide(this.getValue(), a, units);
    }

    public Datum divide(double d) {
        return this.divide(new java.lang.Double(d), Units.dimensionless);
    }

    public Datum multiply(Datum a) {
        Datum result = this.multiply(a.getValue(), a.getUnits());
        result.resolution = result.doubleValue() * Datum.relativeErrorMult(this.doubleValue(), this.resolution, a.doubleValue(), a.resolution);
        return result;
    }

    public Datum multiply(Number a, Units units) {
        return this.getUnits().multiply(this.getValue(), a, units);
    }

    public Datum multiply(double d) {
        return this.multiply(new java.lang.Double(d), Units.dimensionless);
    }

    public Datum convertTo(Units units) throws IllegalArgumentException {
        UnitsConverter muc = this.units.getConverter(units);
        Datum result = units.createDatum(muc.convert(this.getValue()));
        if (this.resolution != 0.0) {
            muc = this.units.getOffsetUnits().getConverter(units.getOffsetUnits());
            result.resolution = muc.convert(this.resolution);
        }
        return result;
    }

    public int hashCode() {
        long bits = this.getValue().hashCode();
        int doubleHash = (int)(bits ^ bits >>> 32);
        int unitsHash = this.units.hashCode();
        return doubleHash ^ unitsHash;
    }

    public boolean equals(Object a) throws IllegalArgumentException {
        return a != null && a instanceof Datum && this.equals((Datum)a);
    }

    public boolean equals(Datum a) throws IllegalArgumentException {
        return a != null && this.getUnits().isConvertableTo(a.getUnits()) && this.compareTo(a) == 0;
    }

    public boolean lt(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) < 0;
    }

    public boolean gt(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) > 0;
    }

    public boolean le(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) <= 0;
    }

    public boolean ge(Datum a) throws IllegalArgumentException {
        return this.compareTo(a) >= 0;
    }

    @Override
    public int compareTo(Datum a) throws IllegalArgumentException {
        double d;
        if (this.units != a.units) {
            a = a.convertTo(this.units);
        }
        if ((d = this.getValue().doubleValue() - a.getValue().doubleValue()) == 0.0) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public boolean isValid() {
        return this.value.doubleValue() != java.lang.Double.NaN;
    }

    public boolean isFinite() {
        return this.value.doubleValue() != java.lang.Double.POSITIVE_INFINITY && this.value.doubleValue() != java.lang.Double.NEGATIVE_INFINITY && this.value.doubleValue() != java.lang.Double.NaN;
    }

    public String toString() {
        if (this.formatter == null) {
            return this.units.getDatumFormatterFactory().defaultFormatter().format(this);
        }
        return this.formatter.format(this);
    }

    public static Datum create(double value) {
        return Units.dimensionless.createDatum(value);
    }

    public static Datum create(double value, Units units) {
        return units.createDatum(value);
    }

    public static Datum create(double value, Units units, DatumFormatter formatter) {
        Datum result = Datum.create(value, units);
        result.formatter = formatter;
        return result;
    }

    public static Datum create(double value, Units units, double resolution) {
        Datum result = units.createDatum(value, resolution);
        result.formatter = units.getDatumFormatterFactory().defaultFormatter();
        return result;
    }

    public static Datum create(double value, Units units, double resolution, DatumFormatter formatter) {
        Datum result = units.createDatum(value, resolution);
        result.formatter = formatter;
        return result;
    }

    public static Datum create(int value) {
        return Units.dimensionless.createDatum(value);
    }

    public static Datum create(int value, Units units) {
        return units.createDatum(value);
    }

    public DatumFormatter getFormatter() {
        return this.formatter;
    }

    public static class Double
    extends Datum {
        Double(Number value, Units units) {
            super(value, units, 0.0);
        }

        Double(double value, Units units) {
            super((Number)new java.lang.Double(value), units, 0.0);
        }

        Double(double value) {
            super((Number)new java.lang.Double(value), Units.dimensionless, 0.0);
        }

        Double(double value, Units units, double resolution) {
            super(new java.lang.Double(value), units, units.getDatumFormatterFactory().defaultFormatter(), resolution);
        }
    }
}

